/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.functions;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.psi.SqlType;
import com.intellij.util.Function;
import com.intellij.util.PairConsumer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFunctionDefinition
extends BuiltinFunction {
    public static final Parameter COMMA = new SyntaxParameter(-1, ",");
    public static final Type ANY = new Type("ANY", "any", (SqlType)SqlType.UNKNOWN);
    public static final Type ARRAY = new Type("array", "array", (SqlType)SqlType.UNKNOWN);
    public static final Type N = new Type("N", "int", (SqlType)SqlType.INTEGER);
    public static final Type X = new Type("X", "real", (SqlType)SqlType.REAL);
    public static final Type STR = new Type("str", "string", (SqlType)SqlType.STRING);
    public static final Type BYTES = new Type("bytes", "bytes", (SqlType)SqlType.BYTES);
    public static final Type B = new Type("B", "boolean", (SqlType)SqlType.BOOLEAN);
    public static final Type REF = new Type("ref", "reference", (SqlType)SqlType.REFERENCE);
    public static final Type TIME = new Type("time", "time", (SqlType)SqlType.TIME);
    public static final Type DATE = new Type("date", "date", (SqlType)SqlType.DATE);
    public static final Type TIMESTAMP = new Type("timestamp", "timestamp", (SqlType)SqlType.TIMESTAMP);
    public static final Type DATETIME = new Type("datetime", "datetime", (SqlType)SqlType.DATE_TIME);
    public static final Type INTERVAL = new Type("interval", "interval", (SqlType)SqlType.INTERVAL);
    public static final Type TABLE = new Type("table", "table", null);
    public static final Type DATATYPE = new Type("datatype", "datatype", null);
    public static final Type TOKEN = new Type("token", "token", null);
    public static final Type[] SIMPLE_TYPES = new Type[]{ANY, N, X, STR, BYTES, B, ARRAY, REF, TIME, DATE, TIMESTAMP, DATETIME, INTERVAL, TABLE, DATATYPE, TOKEN};
    public static final String PARAM_TYPE_PREFIX = "P";
    private final Map<String, String> myDialectAttrs;
    private final Prototype[] myPrototypes;
    private final String myName;
    private final String myAliasedFunction;

    public SqlFunctionDefinition(String name, String aliasedFunction, Map<String, String> dialectAttrs, List<Prototype> prototypes) {
        this.myName = name;
        this.myAliasedFunction = aliasedFunction;
        this.myDialectAttrs = dialectAttrs;
        this.myPrototypes = new Prototype[prototypes.size()];
        for (int i = 0; i < prototypes.size(); ++i) {
            Prototype p = prototypes.get(i);
            this.myPrototypes[i] = new Prototype(this, p.getReturnType(), p.getPrototypeId(), p.getParams(), p.getTailBlock(), p.getAttributes());
        }
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/functions/SqlFunctionDefinition", "getName"));
        }
        return string;
    }

    public String getAliasedFunction() {
        return this.myAliasedFunction;
    }

    public Prototype[] getPrototypes() {
        return this.myPrototypes;
    }

    @Nullable
    public String getDialectAttribute(String name) {
        return this.myDialectAttrs.get(name);
    }

    public String toString() {
        return this.myName + Prototype.toString(this.myDialectAttrs) + Arrays.asList(this.myPrototypes);
    }

    public static class SyntaxParameter
    extends Parameter {
        private final String myText;

        public SyntaxParameter(int prototypeId, String text) {
            super(prototypeId);
            this.myText = text;
        }

        public String getText() {
            return this.myText;
        }

        public String toString() {
            return !"()[]{}.\\:|".contains(this.myText) ? this.myText : "'" + this.myText + "'";
        }

        @Override
        public Parameter copyWithPrototype(int prototypeId) {
            return new SyntaxParameter(prototypeId, this.myText);
        }
    }

    public static class ParamType
    extends Type {
        private final int myIndex;

        public ParamType(int index) {
            super(SqlFunctionDefinition.PARAM_TYPE_PREFIX + index, "TypeOf(" + index + ")", null);
            this.myIndex = index;
        }

        public int getIndex() {
            return this.myIndex;
        }
    }

    public static class Type {
        private final String myName;
        private final String myDisplayName;
        private final SqlType mySqlType;

        public Type(@NonNls String name, String displayName, SqlType sqlType) {
            this.myName = name;
            this.myDisplayName = displayName;
            this.mySqlType = sqlType;
        }

        public String getName() {
            return this.myName;
        }

        public String getDisplayName() {
            return this.myDisplayName;
        }

        public SqlType getSqlType() {
            return this.mySqlType;
        }

        public String toString() {
            return this.myDisplayName;
        }
    }

    public static class Keyword
    extends Parameter {
        private final String myName;

        public Keyword(int prototypeId, String name) {
            super(prototypeId);
            this.myName = name;
        }

        public String getName() {
            return this.myName;
        }

        public String toString() {
            return this.myName;
        }

        @Override
        public Parameter copyWithPrototype(int prototypeId) {
            return new Keyword(prototypeId, this.myName);
        }
    }

    public static class ReferenceParameter
    extends SimpleParameter {
        private final String myRefTypeName;

        public ReferenceParameter(int prototypeId, String name, Type type, @NotNull String refTypeName, boolean many) {
            if (refTypeName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refTypeName", "com/intellij/sql/dialects/functions/SqlFunctionDefinition$ReferenceParameter", "<init>"));
            }
            super(prototypeId, name, type, many);
            this.myRefTypeName = refTypeName;
        }

        @Override
        public Parameter copyWithPrototype(int prototypeId) {
            return new ReferenceParameter(prototypeId, this.getName(), this.getType(), this.myRefTypeName, this.isMany());
        }

        public String getRefTypeName() {
            return this.myRefTypeName;
        }

        @Override
        public String toString() {
            return super.toString() + "/" + this.myRefTypeName;
        }
    }

    public static class SimpleParameter
    extends Parameter {
        private final String myName;
        private final Type myType;
        private final boolean myMany;

        public SimpleParameter(int prototypeId, String name, @NotNull Type type, boolean many) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/sql/dialects/functions/SqlFunctionDefinition$SimpleParameter", "<init>"));
            }
            super(prototypeId);
            this.myName = name == null ? type.getName().toLowerCase() : name;
            this.myType = type;
            this.myMany = many;
        }

        @Override
        public boolean isMany() {
            return this.myMany;
        }

        @Override
        public Parameter copyWithPrototype(int prototypeId) {
            return new SimpleParameter(prototypeId, this.myName, this.myType, this.myMany);
        }

        public String getName() {
            return this.myName;
        }

        public Type getType() {
            return this.myType;
        }

        public String toString() {
            return this.myName + ":" + this.myType.getDisplayName() + (this.myMany ? "*" : "");
        }
    }

    public static class ParameterBlock
    extends Parameter {
        private final Parameter[] myParams;
        private final boolean myMany;
        private final ParameterBlockType myBlockType;

        public ParameterBlock(int prototypeId, ParameterBlockType blockType, Parameter[] params, boolean many) {
            super(prototypeId);
            this.myBlockType = blockType;
            this.myParams = params;
            this.myMany = many;
        }

        public ParameterBlockType getBlockType() {
            return this.myBlockType;
        }

        public Parameter[] getParams() {
            return this.myParams;
        }

        @Override
        public boolean isMany() {
            return this.myMany;
        }

        @Override
        public Parameter copyWithPrototype(int prototypeId) {
            Parameter[] params = this.myParams.length == 0 ? EMPTY_ARRAY : new Parameter[this.myParams.length];
            for (int i = 0; i < this.myParams.length; ++i) {
                params[i] = this.myParams[i].copyWithPrototype(prototypeId);
            }
            return new ParameterBlock(prototypeId, this.myBlockType, params, this.myMany);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb, null);
            return sb.toString();
        }

        public void toString(StringBuilder sb, @Nullable PairConsumer<Parameter, Boolean> markerProcessor) {
            boolean first = true;
            if (markerProcessor != null) {
                markerProcessor.consume((Object)this, (Object)true);
            }
            switch (this.myBlockType) {
                case CHOICE: {
                    sb.append("{");
                    break;
                }
                case OPTIONAL_SEQUENCE: {
                    sb.append("[");
                    break;
                }
                case SEQUENCE: {
                    sb.append("(");
                }
            }
            for (Parameter param : this.myParams) {
                if (first) {
                    first = false;
                } else if (this.myBlockType == ParameterBlockType.CHOICE) {
                    sb.append(" | ");
                } else if (param != COMMA) {
                    sb.append(' ');
                }
                if (param instanceof ParameterBlock) {
                    ((ParameterBlock)param).toString(sb, markerProcessor);
                    continue;
                }
                if (markerProcessor != null) {
                    markerProcessor.consume((Object)param, (Object)true);
                }
                sb.append(param);
                if (markerProcessor == null) continue;
                markerProcessor.consume((Object)param, (Object)false);
            }
            switch (this.myBlockType) {
                case CHOICE: {
                    sb.append("}");
                    break;
                }
                case OPTIONAL_SEQUENCE: {
                    sb.append("]");
                    break;
                }
                case SEQUENCE: {
                    sb.append(")");
                }
            }
            if (this.myMany) {
                sb.append("...");
            }
            if (markerProcessor != null) {
                markerProcessor.consume((Object)this, (Object)false);
            }
        }
    }

    public static enum ParameterBlockType {
        SEQUENCE,
        OPTIONAL_SEQUENCE,
        CHOICE;

    }

    public static abstract class Parameter {
        public static final Parameter[] EMPTY_ARRAY = new Parameter[0];
        private final int myPrototypeId;

        public Parameter(int prototypeId) {
            this.myPrototypeId = prototypeId;
        }

        public int getPrototypeId() {
            return this.myPrototypeId;
        }

        public boolean isMany() {
            return false;
        }

        public abstract Parameter copyWithPrototype(int var1);
    }

    public static class Prototype
    extends ParameterBlock {
        public static final Prototype[] EMPTY_ARRAY = new Prototype[0];
        private final Type myReturnType;
        private final SqlFunctionDefinition myFunction;
        private final Parameter myTailBlock;
        private final Map<String, String> myAttributes;

        public Prototype(@Nullable SqlFunctionDefinition function, @NotNull Type returnType, int id, Parameter[] parameters, @Nullable Parameter tailBlock, @NotNull Map<String, String> attributes) {
            if (returnType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "com/intellij/sql/dialects/functions/SqlFunctionDefinition$Prototype", "<init>"));
            }
            if (attributes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/sql/dialects/functions/SqlFunctionDefinition$Prototype", "<init>"));
            }
            super(id, ParameterBlockType.SEQUENCE, parameters, false);
            this.myFunction = function;
            this.myReturnType = returnType;
            this.myTailBlock = tailBlock;
            this.myAttributes = attributes.isEmpty() ? Collections.emptyMap() : attributes;
        }

        @Override
        public Parameter copyWithPrototype(int prototypeId) {
            throw new UnsupportedOperationException();
        }

        public Type getReturnType() {
            return this.myReturnType;
        }

        @Override
        public String toString() {
            return Prototype.toString(this.myAttributes) + super.toString() + ":" + this.myReturnType + (this.myTailBlock == null ? "" : " " + this.myTailBlock);
        }

        @NotNull
        public SqlFunctionDefinition getFunction() {
            assert (this.myFunction != null);
            SqlFunctionDefinition sqlFunctionDefinition = this.myFunction;
            if (sqlFunctionDefinition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/functions/SqlFunctionDefinition$Prototype", "getFunction"));
            }
            return sqlFunctionDefinition;
        }

        @Nullable
        public Parameter getTailBlock() {
            return this.myTailBlock;
        }

        @NotNull
        public Map<String, String> getAttributes() {
            Map<String, String> map = this.myAttributes;
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/functions/SqlFunctionDefinition$Prototype", "getAttributes"));
            }
            return map;
        }

        private static String toString(Map<String, String> attrs) {
            if (attrs.isEmpty()) {
                return "";
            }
            return "{" + StringUtil.join(attrs.entrySet(), (Function)new Function<Map.Entry<String, String>, String>(){

                public String fun(Map.Entry<String, String> entry) {
                    return entry.getKey() + ":" + entry.getValue();
                }
            }, (String)",") + "}";
        }
    }
}

