/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres;

import com.intellij.lexer.Lexer;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.postgres.PostgresDialect;
import com.intellij.sql.dialects.postgres.PostgresOptionalKeywords;
import com.intellij.sql.dialects.postgres.PostgresReservedKeywords;
import com.intellij.sql.dialects.postgres.PostgresTokens;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.lexer.SqlLexer;
import com.intellij.sql.psi.impl.lexer._PostgresLexer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostgresLexer
extends SqlLexer {
    private static final Pattern DOLLAR_QUOTE = Pattern.compile("^(\\$\\w*\\$).*$");
    public static final String OP_CHARS = "+-*/<>=~!@#%^&|`?";

    public PostgresLexer() {
        super(PostgresTokens.class, new _PostgresLexer());
    }

    @Override
    protected void lookAhead(Lexer baseLexer) {
        if (!(this.lookAheadRangeOperator(baseLexer) || this.lookAheadCustomQuotation(baseLexer) || this.lookAheadVariable(baseLexer) || this.lookAheadCustomOperator(baseLexer))) {
            super.lookAhead(baseLexer);
        }
    }

    protected boolean lookAheadVariable(Lexer baseLexer) {
        char nextChar;
        CharSequence text = baseLexer.getBufferSequence();
        int tokenStart = baseLexer.getTokenStart();
        int len = baseLexer.getBufferEnd();
        if (len > tokenStart + 1 && text.charAt(tokenStart) == '$' && (nextChar = text.charAt(tokenStart + 1)) >= '0' && nextChar <= '9') {
            char c;
            int tokenEnd;
            for (tokenEnd = tokenStart + 2; tokenEnd < len && (c = text.charAt(tokenEnd)) >= '0' && c <= '9'; ++tokenEnd) {
            }
            this.addToken(tokenEnd, (IElementType)SqlTokens.SQL_IDENT);
            baseLexer.start(text, tokenEnd, baseLexer.getBufferEnd(), 0);
            return true;
        }
        return false;
    }

    private boolean lookAheadCustomOperator(Lexer baseLexer) {
        CharSequence bufferSequence = baseLexer.getBufferSequence();
        int tokenStart = baseLexer.getTokenStart();
        int tokenEnd = baseLexer.getTokenEnd();
        int bufferEnd = baseLexer.getBufferEnd();
        for (int i = tokenStart; i <= bufferEnd; ++i) {
            int idx;
            char ch = i < bufferEnd ? bufferSequence.charAt(i) : (char)'\u0000';
            int n = idx = ch > '\u0000' ? OP_CHARS.indexOf(ch) : -1;
            if (idx != -1) continue;
            if (i == tokenStart) {
                return false;
            }
            String op = bufferSequence.subSequence(tokenStart, i).toString();
            int fix1 = op.indexOf("--");
            int fix2 = op.indexOf("/*");
            i = Math.min(fix2 < 0 ? i : tokenStart + fix2, fix1 < 0 ? i : tokenStart + fix1);
            if (i == tokenEnd) {
                return false;
            }
            boolean anychar = false;
            int oplen = i - tokenStart;
            for (int j = 0; j < oplen; ++j) {
                char c = op.charAt(j);
                anychar |= OP_CHARS.indexOf(c) >= 7;
            }
            while (i - tokenStart >= 2) {
                boolean valid;
                int oplen2 = i - tokenStart;
                boolean bl = valid = anychar || op.charAt(oplen2 - 1) != '+' && op.charAt(oplen2 - 1) != '-';
                if (valid) {
                    this.addToken(i, (IElementType)SqlTokens.PG_OP_CUSTOM);
                    baseLexer.start(bufferSequence, i, bufferEnd, 0);
                    return true;
                }
                --i;
            }
            return false;
        }
        return false;
    }

    private boolean lookAheadCustomQuotation(@NotNull Lexer baseLexer) {
        if (baseLexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseLexer", "com/intellij/sql/dialects/postgres/PostgresLexer", "lookAheadCustomQuotation"));
        }
        String identifier = PostgresLexer.getDollarQuotingIdent(baseLexer);
        if (identifier == null) {
            return false;
        }
        int len = identifier.length();
        int stringStart = baseLexer.getTokenStart() + len;
        baseLexer.advance();
        return this.processCustomQuotation(baseLexer, identifier, stringStart, false, SqlTokens.SQL_CUSTOM_LQUOTE, SqlTokens.SQL_CUSTOM_RQUOTE, SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN);
    }

    @Nullable
    private static String getDollarQuotingIdent(@NotNull Lexer baseLexer) {
        String identText;
        if (baseLexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseLexer", "com/intellij/sql/dialects/postgres/PostgresLexer", "getDollarQuotingIdent"));
        }
        IElementType tokenType = baseLexer.getTokenType();
        String string = identText = tokenType == SqlTokens.SQL_IDENT_DELIMITED || tokenType == TokenType.BAD_CHARACTER ? baseLexer.getTokenText() : null;
        if (identText == null) {
            return null;
        }
        if (tokenType == TokenType.BAD_CHARACTER) {
            Matcher matcher = DOLLAR_QUOTE.matcher(identText);
            return matcher.lookingAt() ? matcher.group(1) : null;
        }
        int len = identText.length();
        return len >= 2 && identText.charAt(0) == '$' && identText.charAt(len - 1) == '$' ? identText : null;
    }

    static {
        PostgresLexer.initTokensAndFunctions(PostgresTokens.class, PostgresReservedKeywords.class, PostgresOptionalKeywords.class, PostgresDialect.INSTANCE);
    }
}

