/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.sql92;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.sql92.Sql92ReservedKeywords;
import com.intellij.sql.dialects.sql92.Sql92Tokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.util.SqlTokenRegistry;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class Sql92Dialect
extends SqlLanguageDialectEx {
    public static final Sql92Dialect INSTANCE = new Sql92Dialect();

    public Sql92Dialect() {
        super("SQL92");
    }

    @Override
    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        GenericDialect genericDialect = GenericDialect.INSTANCE;
        if (genericDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/sql92/Sql92Dialect", "getDatabaseDialect"));
        }
        return genericDialect;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return LazyData.ourReservedTokens.contains(tokenType);
    }

    @Override
    @NotNull
    public Map<String, SqlFunctionDefinition> getSupportedFunctions() {
        Map map = LazyData.ourFunctionMap;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/sql92/Sql92Dialect", "getSupportedFunctions"));
        }
        return map;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set set = SqlTokenRegistry.getTokens(Sql92Tokens.class);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/sql92/Sql92Dialect", "getKeywords"));
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/sql92/Sql92Dialect", "getSystemVariables"));
        }
        return set;
    }

    @Override
    public ProblemDescriptor checkIdentifierText(SqlIdentifier o, InspectionManager manager, boolean onTheFly) {
        if (o.getNode().getFirstChildNode().getElementType() == SqlTokens.SQL_MODULE) {
            return null;
        }
        return super.checkIdentifierText(o, manager, onTheFly);
    }

    @Override
    public boolean supportsSql92CharSetSpecFor(@NotNull IElementType element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/sql92/Sql92Dialect", "supportsSql92CharSetSpecFor"));
        }
        return element == SqlCompositeElementTypes.SQL_STRING_LITERAL || element == SqlCompositeElementTypes.SQL_NUMERIC_LITERAL || element == SqlCompositeElementTypes.SQL_IDENTIFIER || element == SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE;
    }

    private static class LazyData {
        private static final Map<String, SqlFunctionDefinition> ourFunctionMap = Collections.unmodifiableMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        private static final TokenSet ourReservedTokens = SqlTokenRegistry.getTokenSet(Sql92ReservedKeywords.class);
        private static final TokenSet ourSupportedOperators = TokenSet.create((IElementType[])new IElementType[]{SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_AND, SqlTokens.SQL_NOT, SqlTokens.SQL_OR, SqlTokens.SQL_IS, SqlTokens.SQL_LIKE, SqlTokens.SQL_COLLATE, SqlTokens.SQL_IN, SqlTokens.SQL_INTERVAL, SqlTokens.SQL_OVERLAPS, SqlTokens.SQL_MATCH, SqlTokens.SQL_AT, SqlTokens.SQL_SECOND, SqlTokens.SQL_MINUTE, SqlTokens.SQL_HOUR, SqlTokens.SQL_DAY, SqlTokens.SQL_MONTH, SqlTokens.SQL_YEAR});

        private LazyData() {
        }
    }
}

