/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.generation.surroundWith;

import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;

public abstract class SqlSurrounderBase
implements Surrounder {
    @NotNull
    protected static TextRange surroundElementsWith(@NotNull Editor editor, @NotNull String open, @NotNull String close) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/generation/surroundWith/SqlSurrounderBase", "surroundElementsWith"));
        }
        if (open == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "open", "com/intellij/sql/generation/surroundWith/SqlSurrounderBase", "surroundElementsWith"));
        }
        if (close == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "close", "com/intellij/sql/generation/surroundWith/SqlSurrounderBase", "surroundElementsWith"));
        }
        SelectionModel model = editor.getSelectionModel();
        int[] starts = model.getBlockSelectionStarts();
        int[] ends = model.getBlockSelectionEnds();
        Document document = editor.getDocument();
        int offset = 0;
        for (int i = 0; i < starts.length; ++i) {
            document.insertString(starts[i] + offset++, (CharSequence)open);
            document.insertString(ends[i] + offset++, (CharSequence)close);
        }
        int caret = ends[ends.length - 1] + offset;
        TextRange textRange = new TextRange(caret, caret);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/generation/surroundWith/SqlSurrounderBase", "surroundElementsWith"));
        }
        return textRange;
    }
}

