/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixBase;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlTokens;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlNullComparisonInspection
extends SqlInspectionBase {
    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, final boolean onTheFly) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/inspections/SqlNullComparisonInspection", "createAnnotationVisitor"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/sql/inspections/SqlNullComparisonInspection", "createAnnotationVisitor"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/inspections/SqlNullComparisonInspection", "createAnnotationVisitor"));
        }
        if (dialect.getDatabaseDialect().getFamilyId().isSybase()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result){

            public void visitSqlBinaryExpression(@NotNull SqlBinaryExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/inspections/SqlNullComparisonInspection$1", "visitSqlBinaryExpression"));
                }
                if (PsiTreeUtil.getParentOfType((PsiElement)o, SqlFunctionCallExpression.class) != null) {
                    return;
                }
                if (!this.process(o, true)) {
                    this.process(o, false);
                }
                super.visitSqlBinaryExpression(o);
            }

            public boolean process(@NotNull SqlBinaryExpression o, boolean left) {
                boolean neq;
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/inspections/SqlNullComparisonInspection$1", "process"));
                }
                IElementType sign = o.getOpSign();
                SqlExpression r = o.getROperand();
                SqlExpression l = o.getLOperand();
                SqlExpression operand = left ? l : r;
                SqlExpression opposite = left ? r : l;
                boolean eq = sign == SqlTokens.SQL_OP_EQ;
                boolean bl = neq = sign == SqlTokens.SQL_OP_NEQ || sign == SqlTokens.SQL_OP_NEQ2 || sign == SqlTokens.SQL_OP_NEQ3 || sign == SqlTokens.SQL_OP_NEQ_WS || sign == SqlTokens.SQL_OP_NEQ2_WS || sign == SqlTokens.SQL_OP_NEQ3_WS;
                if (operand != null && opposite != null && operand.getNode().getElementType() == SqlCompositeElementTypes.SQL_SPECIAL_LITERAL && StringUtil.equalsIgnoreCase((CharSequence)"null", (CharSequence)operand.getText()) && (eq || neq)) {
                    DdlBuilder builder = new DdlBuilder().applyCodeStyle(o.getProject()).keyword("IS");
                    if (neq) {
                        builder.space().keyword("NOT");
                    }
                    String what = builder.space().keyword("NULL").getStatement();
                    String text = "Suspicious comparison with NULL, probably " + what + " operator should be used";
                    String title = "Use " + what + " operator";
                    String replacement = opposite.getText() + " " + what;
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o, text, (LocalQuickFix)new MyConvertFix(title, replacement), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                    return true;
                }
                return false;
            }
        };
    }

    private static class MyConvertFix
    extends LocalQuickFixBase {
        @NotNull
        private final String myReplacement;

        protected MyConvertFix(@NotNull String title, @NotNull String replacement) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/sql/inspections/SqlNullComparisonInspection$MyConvertFix", "<init>"));
            }
            if (replacement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replacement", "com/intellij/sql/inspections/SqlNullComparisonInspection$MyConvertFix", "<init>"));
            }
            super(title, "SQL");
            this.myReplacement = replacement;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiFile file;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/inspections/SqlNullComparisonInspection$MyConvertFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/sql/inspections/SqlNullComparisonInspection$MyConvertFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            PsiDocumentManager instance = PsiDocumentManager.getInstance((Project)project);
            Document document = instance.getDocument(file = element.getContainingFile());
            if (document != null) {
                TextRange range = element.getTextRange();
                document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)this.myReplacement);
            }
        }
    }
}

