/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi;

import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlFileType;
import com.intellij.util.messages.MessageBus;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDialectPusher
implements FilePropertyPusher<SqlLanguageDialect> {
    private static final FileAttribute PERSISTENCE = new FileAttribute("sql_dialect", 1 + (FSRecords.persistentAttributesList ? 1 : 0), FSRecords.persistentAttributesList);

    public void initExtra(@NotNull Project project, @NotNull MessageBus bus, @NotNull FilePropertyPusher.Engine languageLevelUpdater) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/psi/SqlDialectPusher", "initExtra"));
        }
        if (bus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bus", "com/intellij/sql/psi/SqlDialectPusher", "initExtra"));
        }
        if (languageLevelUpdater == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevelUpdater", "com/intellij/sql/psi/SqlDialectPusher", "initExtra"));
        }
    }

    @NotNull
    public Key<SqlLanguageDialect> getFileDataKey() {
        Key<SqlLanguageDialect> key = SqlDialectMappings.SQL_DIALECT_KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/SqlDialectPusher", "getFileDataKey"));
        }
        return key;
    }

    public boolean pushDirectoriesOnly() {
        return false;
    }

    protected static FileType getFileType(VirtualFile file) {
        return FileTypeRegistry.getInstance().getFileTypeByFileName(file.getName());
    }

    @NotNull
    public SqlLanguageDialect getDefaultValue() {
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlDialectMappings.getDefaultSqlDialect();
        if (sqlLanguageDialectEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/SqlDialectPusher", "getDefaultValue"));
        }
        return sqlLanguageDialectEx;
    }

    public SqlLanguageDialect getImmediateValue(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/psi/SqlDialectPusher", "getImmediateValue"));
        }
        return (SqlLanguageDialect)SqlDialectMappings.getInstance(project).getImmediateMapping(file);
    }

    public SqlLanguageDialect getImmediateValue(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/sql/psi/SqlDialectPusher", "getImmediateValue"));
        }
        return null;
    }

    public boolean acceptsFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/psi/SqlDialectPusher", "acceptsFile"));
        }
        return ((Object)((Object)SqlFileType.INSTANCE)).equals(SqlDialectPusher.getFileType(file));
    }

    public boolean acceptsDirectory(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/psi/SqlDialectPusher", "acceptsDirectory"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/psi/SqlDialectPusher", "acceptsDirectory"));
        }
        return true;
    }

    public void persistAttribute(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull SqlLanguageDialect dialect) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/psi/SqlDialectPusher", "persistAttribute"));
        }
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/sql/psi/SqlDialectPusher", "persistAttribute"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/SqlDialectPusher", "persistAttribute"));
        }
        if (!fileOrDir.isDirectory() && !((Object)((Object)SqlFileType.INSTANCE)).equals(SqlDialectPusher.getFileType(fileOrDir))) {
            return;
        }
        FileAttribute attribute = PERSISTENCE;
        String id = dialect.getID();
        if (!DbImplUtil.writeVFSAttribute(fileOrDir, attribute, id)) {
            return;
        }
        if (fileOrDir.isDirectory()) {
            for (VirtualFile child : fileOrDir.getChildren()) {
                if (child.isDirectory() || !this.acceptsFile(child)) continue;
                PushedFilePropertiesUpdater.getInstance((Project)project).filePropertiesChanged(child);
            }
        } else {
            PushedFilePropertiesUpdater.getInstance((Project)project).filePropertiesChanged(fileOrDir);
        }
    }

    public void afterRootsChanged(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/psi/SqlDialectPusher", "afterRootsChanged"));
        }
    }
}

