/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlAlterTableInstruction;
import com.intellij.sql.psi.SqlAlterTableStatement;
import com.intellij.sql.psi.SqlBatchBlock;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDeclareStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFileAttributes;
import com.intellij.sql.psi.SqlFileType;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlIfStatement;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRenameToClause;
import com.intellij.sql.psi.SqlResolveCache;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlUseDatabaseStatement;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlAlterTableInstructionImpl;
import com.intellij.sql.psi.impl.SqlDefinitionHolderStatement;
import com.intellij.sql.psi.impl.SqlElementDescriptionProvider;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlResolveCacheImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.util.CachedValueBase;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFileImpl
extends PsiFileBase
implements SqlFile {
    private final NamespaceImpl myRootMirror = new NamespaceImpl((SqlElement)this, DasUtil.NO_NAME, DasUtil.NO_NAME, ObjectKind.NONE);
    private final Map<Object, GroupImpl> myMirrors = ContainerUtil.newConcurrentMap();
    private final CachedValue<List<SqlElement>> myDdl;
    private final CachedValue<List<SqlReferenceExpression>> myGlobalVariables;
    private final CachedValue<State> myState;
    private final CachedValue<List<SqlDeclareStatement>> myDeclares;
    private final CachedValue<SqlResolveCacheImpl> myResolveCache;

    public SqlFileImpl(FileViewProvider viewProvider) {
        super(viewProvider, (Language)SqlLanguage.getInstance());
        final Project project = this.getProject();
        this.myDdl = CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)new CachedValueProvider<List<SqlElement>>(){

            public CachedValueProvider.Result<List<SqlElement>> compute() {
                return CachedValueProvider.Result.create((Object)SqlFileImpl.this.calcDdl(), (Object[])new Object[]{SqlFileImpl.this});
            }
        }, false);
        this.myGlobalVariables = CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)new CachedValueProvider<List<SqlReferenceExpression>>(){

            public CachedValueProvider.Result<List<SqlReferenceExpression>> compute() {
                return CachedValueProvider.Result.create((Object)SqlFileImpl.this.calcGlobalVariables(), (Object[])new Object[]{SqlFileImpl.this});
            }
        }, false);
        this.myState = CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)new CachedValueProvider<State>(){

            public CachedValueProvider.Result<State> compute() {
                return CachedValueProvider.Result.create((Object)SqlFileImpl.this.calcState(), (Object[])new Object[]{SqlFileImpl.this, DbPsiFacade.getInstance((Project)project)});
            }
        }, false);
        this.myDeclares = CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)new CachedValueProvider<List<SqlDeclareStatement>>(){

            public CachedValueProvider.Result<List<SqlDeclareStatement>> compute() {
                return CachedValueProvider.Result.create((Object)SqlFileImpl.this.calcDeclares(), (Object[])new Object[]{SqlFileImpl.this});
            }
        }, false);
        this.myResolveCache = CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)new CachedValueProvider<SqlResolveCacheImpl>(){

            @Nullable
            public CachedValueProvider.Result<SqlResolveCacheImpl> compute() {
                return CachedValueProvider.Result.create((Object)new SqlResolveCacheImpl(), (Object[])new Object[]{SqlFileImpl.this, DbPsiFacade.getInstance((Project)project)});
            }
        }, false);
    }

    public void clearCaches() {
        ((CachedValueBase)this.myState).clear();
        ((CachedValueBase)this.myDeclares).clear();
        ((CachedValueBase)this.myDdl).clear();
        ((CachedValueBase)this.myGlobalVariables).clear();
        ((CachedValueBase)this.myResolveCache).clear();
        super.clearCaches();
    }

    @NotNull
    public List<SqlElement> getDdl() {
        List list = (List)this.myDdl.getValue();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl", "getDdl"));
        }
        return list;
    }

    @Nullable
    public <T> T getAttributeAt(@NotNull Key<T> attr, int offset) {
        if (attr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attr", "com/intellij/sql/psi/impl/SqlFileImpl", "getAttributeAt"));
        }
        if (attr == SqlFileAttributes.DELIMITER) {
            return (T)this.getSqlLanguage().getDelimiterAt(this, offset);
        }
        return null;
    }

    @NotNull
    public List<SqlReferenceExpression> getGlobalVariables() {
        List list = (List)this.myGlobalVariables.getValue();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl", "getGlobalVariables"));
        }
        return list;
    }

    @NotNull
    public JBIterable<NamespaceImpl> getModelRoots() {
        JBIterable jBIterable = this.myRootMirror.children().filter(NamespaceImpl.class);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl", "getModelRoots"));
        }
        return jBIterable;
    }

    @NotNull
    public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/psi/impl/SqlFileImpl", "getCasing"));
        }
        Casing casing = ((State)this.myState.getValue()).casingProvider.getCasing(kind, context);
        if (casing == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl", "getCasing"));
        }
        return casing;
    }

    @NotNull
    public JBIterable<? extends DasConstraint> getExportedKeys(DasTable table) {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl", "getExportedKeys"));
        }
        return jBIterable;
    }

    @NotNull
    public JBTreeTraverser<DasObject> traverser() {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)DasUtil.dasTraverser().withRoots(this.getModelRoots());
        if (jBTreeTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl", "traverser"));
        }
        return jBTreeTraverser;
    }

    @Nullable
    public DasNamespace getCurrentRoot() {
        return null;
    }

    @Nullable
    public DasObject findDbParent(SqlDefinition o) {
        return (DasObject)((State)this.myState.getValue()).children.get(o);
    }

    @NotNull
    private List<SqlReferenceExpression> calcGlobalVariables() {
        SqlLanguageDialectEx language = this.getSqlLanguage();
        if (!language.getFamilyId().isMysql() || this.getStub() != null) {
            List<SqlReferenceExpression> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl", "calcGlobalVariables"));
            }
            return list;
        }
        HashMap gradedVariables = ContainerUtil.newHashMap();
        for (SqlReferenceExpression ref : SqlImplUtil.sqlTraverser((PsiElement)this).filter(SqlReferenceExpression.class)) {
            String prefix;
            if (ref.getReferenceElementType().getTargetKind() != ObjectKind.VARIABLE) continue;
            SqlIdentifier identifier = ref.getIdentifier();
            String string = prefix = identifier == null ? null : identifier.getNamePrefix();
            if (!language.isVariablePrefix(prefix)) continue;
            int grade = SqlFileImpl.getVariableReferenceGrade(ref);
            String name = ref.getName();
            Pair old = (Pair)gradedVariables.get(name);
            if (old != null && grade >= (Integer)old.second) continue;
            gradedVariables.put(name, Pair.create((Object)ref, (Object)grade));
        }
        List list = ContainerUtil.map2List(gradedVariables.values(), (Function)new Function<Pair<SqlReferenceExpression, Integer>, SqlReferenceExpression>(){

            public SqlReferenceExpression fun(Pair<SqlReferenceExpression, Integer> val) {
                return (SqlReferenceExpression)val.first;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl", "calcGlobalVariables"));
        }
        return list;
    }

    private static int getVariableReferenceGrade(@NotNull SqlReferenceExpression ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/sql/psi/impl/SqlFileImpl", "getVariableReferenceGrade"));
        }
        int grade = 0;
        boolean insideRoutine = PsiTreeUtil.getParentOfType((PsiElement)ref, SqlCreateProcedureStatement.class) != null;
        SqlSetAssignment assignment = (SqlSetAssignment)PsiTreeUtil.getParentOfType((PsiElement)ref, SqlSetAssignment.class);
        if (assignment != null && assignment.getLValue() == ref) {
            return insideRoutine ? grade + 1 : grade;
        }
        grade += 2;
        SqlBinaryExpression expr = (SqlBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)ref, SqlBinaryExpression.class);
        if (expr != null && expr.getLOperand() == ref && (expr.getOpSign() == SqlTokens.SQL_OP_ASSIGN || expr.getOpSign() == SqlTokens.SQL_OP_EQ)) {
            return insideRoutine ? grade + 1 : grade;
        }
        return insideRoutine ? grade + 1 : (grade += 2);
    }

    private List<SqlElement> calcDdl() {
        StubElement stub = this.getStub();
        if (stub != null) {
            return JBIterable.from((Iterable)stub.getChildrenStubs()).transform(SqlImplUtil.STUB_TO_PSI).filter(SqlElement.class).toList();
        }
        return ((SyntaxTraverser)SqlImplUtil.sqlTraverser((PsiElement)this).expand(Conditions.instanceOf((Class[])new Class[]{SqlBatchBlock.class, SqlIfStatement.class, SqlSelectStatement.class, SqlExpression.class, SqlDefinitionHolderStatement.class}))).traverse().filter((Condition)new Condition<PsiElement>(){

            public boolean value(PsiElement element) {
                return element instanceof StubBasedPsiElement;
            }
        }).filter(SqlElement.class).toList();
    }

    @NotNull
    private State calcState() {
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)this);
        final CasingProvider delegateCasing = SqlImplUtil.getCasingProvider(dialect, SqlImplUtil.getDataSources((PsiElement)this));
        CasingProvider casingProvider = new CasingProvider(){

            @NotNull
            public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
                if (kind == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/psi/impl/SqlFileImpl$8", "getCasing"));
                }
                if (context instanceof DbElement) {
                    Casing casing = ((DbElement)context).getDataSource().getModel().getCasing(kind, context);
                    if (casing == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl$8", "getCasing"));
                    }
                    return casing;
                }
                Casing casing = delegateCasing.getCasing(kind, context);
                if (casing == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl$8", "getCasing"));
                }
                return casing;
            }
        };
        DbElement context = DatabaseEditorHelper.getForcedContext((PsiFile)this);
        State state = new State(casingProvider);
        SqlReferenceExpression recentUseRef = null;
        ObjectTracer<?> currentContext = SqlFileImpl.trace(context);
        List<SqlElement> ddlList = this.getDdl();
        for (SqlElement ddl : ddlList) {
            if (ddl instanceof SqlUseDatabaseStatement) {
                SqlReferenceExpression useRef = (SqlReferenceExpression)ContainerUtil.getFirstItem((List)((SqlUseDatabaseStatement)ddl).getUseReferences());
                if (useRef != recentUseRef) {
                    recentUseRef = useRef;
                    currentContext = SqlFileImpl.trace((SqlNameElement)recentUseRef, dialect, casingProvider);
                }
                this.addDefinitionToMap(null, state, currentContext, casingProvider);
            }
            if (ddl instanceof SqlDefinition) {
                this.addDefinitionToMap((SqlDefinition)ddl, state, currentContext, casingProvider);
                continue;
            }
            if (ddl instanceof SqlAlterTableStatement) {
                for (SqlAlterTableInstruction i : ((SqlAlterTableStatement)ddl).getAlterTableInstructions()) {
                    if (i.getInstructionType() != SqlCompositeElementTypes.SQL_RENAME_TO_CLAUSE) continue;
                    for (SqlDefinition def : ((SqlAlterTableInstructionImpl)i).getDefinitions()) {
                        this.addDefinitionToMap(def, state, currentContext, casingProvider);
                    }
                }
                continue;
            }
            for (SqlRenameToClause renamed : SqlImplUtil.childrenIt((PsiElement)ddl).filter(SqlRenameToClause.class)) {
                this.addDefinitionToMap((SqlDefinition)renamed, state, currentContext, casingProvider);
            }
        }
        state.seal(this.myMirrors);
        State state2 = state;
        if (state2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl", "calcState"));
        }
        return state2;
    }

    private void addDefinitionToMap(@Nullable SqlDefinition o, @NotNull State newState, @Nullable ObjectTracer<?> context, @NotNull CasingProvider casingProvider) {
        ArrayList parts;
        if (newState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newState", "com/intellij/sql/psi/impl/SqlFileImpl", "addDefinitionToMap"));
        }
        if (casingProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "casingProvider", "com/intellij/sql/psi/impl/SqlFileImpl", "addDefinitionToMap"));
        }
        if (o == null && context == null) {
            return;
        }
        SqlLanguageDialectEx dialect = this.getSqlLanguage();
        ObjectKind curKind = SqlFileImpl.splitRef(dialect, casingProvider, o, context, (List<Object>)(parts = ContainerUtil.newArrayListWithCapacity((int)12)));
        if (curKind == ObjectKind.NONE) {
            return;
        }
        MetaModel<?> metaModel = dialect.getDatabaseDialect().getMetaModel();
        List<ObjectKind> path = SqlFileImpl.chooseShortestPath(o, curKind, metaModel);
        if (path.isEmpty()) {
            if (o != null) {
                newState.children.put(o, this.myRootMirror);
            }
            return;
        }
        SqlFileImpl.addSkippedParts(parts, path, ObjectKind.NONE);
        JBIterable rootKinds = metaModel.getRootKinds();
        Trinity mapKey = null;
        GroupImpl parent = this.myRootMirror;
        for (int i = parts.size() - 3; i >= 0; i -= 3) {
            boolean wrap;
            ObjectKind kind = (ObjectKind)parts.get(i);
            String name = (String)parts.get(i + 1);
            String uncased = (String)parts.get(i + 2);
            boolean isNamespace = metaModel.getNamespaces().contains(kind);
            mapKey = Trinity.create((Object)kind, (Object)name, mapKey);
            GroupImpl mirror = this.myMirrors.get(mapKey);
            boolean bl = wrap = isNamespace || kind == ObjectKind.PACKAGE || kind == ObjectKind.OBJECT_TYPE;
            if (mirror == null && wrap) {
                mirror = isNamespace ? new NamespaceImpl((SqlElement)parent, name, uncased, kind) : new GroupImpl((SqlElement)parent, name, uncased, kind);
                this.myMirrors.put(mapKey, mirror);
            }
            if (parent instanceof GroupImpl) {
                newState.children.put(mirror != null ? mirror : o, parent);
            } else if (rootKinds.contains((Object)kind)) {
                newState.children.put(mirror != null ? mirror : o, this.myRootMirror);
            }
            if (i == 0 && o != null && mirror != null) {
                newState.delegates.put(o, mirror);
            }
            parent = mirror != null ? mirror : parent;
        }
    }

    @NotNull
    static ObjectKind splitRef(@NotNull SqlLanguageDialectEx dialect, @NotNull CasingProvider casingProvider, @Nullable SqlDefinition o, @Nullable SqlReferenceExpression useRef, @NotNull List<Object> parts) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/impl/SqlFileImpl", "splitRef"));
        }
        if (casingProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "casingProvider", "com/intellij/sql/psi/impl/SqlFileImpl", "splitRef"));
        }
        if (parts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parts", "com/intellij/sql/psi/impl/SqlFileImpl", "splitRef"));
        }
        ObjectKind objectKind = SqlFileImpl.splitRef(dialect, casingProvider, o, SqlFileImpl.trace((SqlNameElement)useRef, dialect, casingProvider), parts);
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl", "splitRef"));
        }
        return objectKind;
    }

    @NotNull
    private static ObjectKind fillParts(@NotNull ObjectTracer<?> tracer, @NotNull List<Object> parts) {
        if (tracer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracer", "com/intellij/sql/psi/impl/SqlFileImpl", "fillParts"));
        }
        if (parts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parts", "com/intellij/sql/psi/impl/SqlFileImpl", "fillParts"));
        }
        ObjectKind curKind = tracer.getKind();
        ObjectTracer.ObjectTraceIt<?> it = tracer.trace();
        while (it.hasNext()) {
            it.next();
            ObjectKind kind = it.getKind();
            if (kind == ObjectKind.NONE) break;
            curKind = kind;
            parts.add(kind);
            parts.add(it.getCorrectName());
            parts.add(it.getName());
        }
        ObjectKind objectKind = curKind;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl", "fillParts"));
        }
        return objectKind;
    }

    @NotNull
    static ObjectKind splitRef(@NotNull SqlLanguageDialectEx dialect, @NotNull CasingProvider casingProvider, @Nullable SqlDefinition o, @Nullable ObjectTracer<?> useTracer, @NotNull List<Object> parts) {
        ObjectKind curKind;
        SqlNameElement nameElement;
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/impl/SqlFileImpl", "splitRef"));
        }
        if (casingProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "casingProvider", "com/intellij/sql/psi/impl/SqlFileImpl", "splitRef"));
        }
        if (parts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parts", "com/intellij/sql/psi/impl/SqlFileImpl", "splitRef"));
        }
        if (o == null && useTracer == null) {
            ObjectKind objectKind = ObjectKind.NONE;
            if (objectKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl", "splitRef"));
            }
            return objectKind;
        }
        SqlNameElement sqlNameElement = nameElement = o == null ? null : o.getNameElement();
        if (o != null && nameElement == null) {
            ObjectKind objectKind = ObjectKind.NONE;
            if (objectKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl", "splitRef"));
            }
            return objectKind;
        }
        if (o != null) {
            ObjectTracer<?> tracer = SqlFileImpl.trace(nameElement, dialect, casingProvider);
            curKind = SqlFileImpl.fillParts(tracer, parts);
            if (useTracer == null || useTracer.getKind() == ObjectKind.NONE || useTracer.getKind() == curKind) {
                ObjectKind objectKind = curKind;
                if (objectKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl", "splitRef"));
                }
                return objectKind;
            }
            List parentTypes = ContainerUtil.newSmartList();
            dialect.getParentDbTypes(parentTypes, curKind);
            if (!parentTypes.contains(useTracer.getKind())) {
                List<ObjectKind> path = SqlFileImpl.chooseShortestPath(o, tracer.getKind(), dialect.getDatabaseDialect().getMetaModel());
                if (!path.contains(useTracer.getKind())) {
                    ObjectKind objectKind = curKind;
                    if (objectKind == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl", "splitRef"));
                    }
                    return objectKind;
                }
                SqlFileImpl.addSkippedParts(parts, path, useTracer.getKind());
            }
        }
        ObjectKind objectKind = curKind = SqlFileImpl.fillParts(useTracer, parts);
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl", "splitRef"));
        }
        return objectKind;
    }

    private static List<ObjectKind> chooseShortestPath(@Nullable SqlDefinition o, @NotNull ObjectKind kind, @NotNull MetaModel<?> model) {
        ObjectKind expectedParent;
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/psi/impl/SqlFileImpl", "chooseShortestPath"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/sql/psi/impl/SqlFileImpl", "chooseShortestPath"));
        }
        JBIterable allPaths = model.getPathsToRoot(kind);
        List list = (List)allPaths.first();
        if (list == null) {
            return Collections.emptyList();
        }
        ObjectKind objectKind = expectedParent = kind == ObjectKind.BODY ? SqlImplUtil.getBodyParentKind(o) : SqlDbElementType.ANY;
        if (expectedParent != SqlDbElementType.ANY) {
            for (List path : allPaths) {
                if (!path.contains(expectedParent)) continue;
                list = path;
                break;
            }
        }
        return list.subList(1, list.size());
    }

    private static void addSkippedParts(List<Object> parts, Iterable<ObjectKind> path, ObjectKind upToKind) {
        for (ObjectKind kind : path) {
            if (kind == upToKind) break;
            parts.add(kind);
            parts.add("");
            parts.add("");
        }
    }

    @NotNull
    private List<SqlDeclareStatement> calcDeclares() {
        List list = SqlImplUtil.sqlChildren((PsiElement)this).filter(SqlDeclareStatement.class).toList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl", "calcDeclares"));
        }
        return list;
    }

    @NotNull
    public FileType getFileType() {
        SqlFileType sqlFileType = SqlFileType.INSTANCE;
        if (sqlFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl", "getFileType"));
        }
        return sqlFileType;
    }

    public String toString() {
        return "SqlFile:" + this.getName();
    }

    public void accept(SqlVisitor visitor) {
        visitor.visitSqlFile((SqlFile)this);
    }

    public void acceptChildren(SqlVisitor visitor) {
        SqlImplUtil.acceptChildren((SqlElement)this, visitor);
    }

    @NotNull
    public SqlLanguageDialectEx getSqlLanguage() {
        Language language = this.getLanguage();
        if (language instanceof SqlLanguageDialectEx) {
            SqlLanguageDialectEx sqlLanguageDialectEx = (SqlLanguageDialectEx)language;
            if (sqlLanguageDialectEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl", "getSqlLanguage"));
            }
            return sqlLanguageDialectEx;
        }
        SqlDialectMappings dialectMappings = SqlDialectMappings.getInstance(this.getProject());
        FileViewProvider viewProvider = this.getOriginalFile().getViewProvider();
        if (dialectMappings != null) {
            SqlLanguageDialectEx sqlLanguageDialectEx = (SqlLanguageDialectEx)dialectMappings.getMapping(viewProvider.isPhysical() ? viewProvider.getVirtualFile() : null);
            if (sqlLanguageDialectEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl", "getSqlLanguage"));
            }
            return sqlLanguageDialectEx;
        }
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlDialectMappings.getDefaultSqlDialect();
        if (sqlLanguageDialectEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl", "getSqlLanguage"));
        }
        return sqlLanguageDialectEx;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/psi/impl/SqlFileImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/sql/psi/impl/SqlFileImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/sql/psi/impl/SqlFileImpl", "processDeclarations"));
        }
        PsiFile file = this.getOriginalFile();
        if (file != this) {
            return file.processDeclarations(processor, state, lastParent, place);
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        boolean resolve = !(processor instanceof SqlScopeProcessor) || ((SqlScopeProcessor)processor).resolve;
        Condition<DasObject> importedCondition = SqlFileImpl.importedCondition(this, dialect, place, resolve);
        for (SqlDefinition o : ((State)this.myState.getValue()).children(this.myRootMirror)) {
            if (!processor.execute((PsiElement)o, state)) {
                return false;
            }
            if (!(o instanceof DasNamespace) || SqlFileImpl.processDeclarationsImpl(processor, state, (PsiObject)o, importedCondition)) continue;
            return false;
        }
        if (this.getStub() == null && this == place.getContainingFile().getOriginalFile()) {
            for (SqlDefinition o : (List)this.myDeclares.getValue()) {
                if (o.processDeclarations(processor, state, lastParent, place)) continue;
                return false;
            }
            if (!dialect.processFileDeclarations(this.getDdl(), processor, state, lastParent, place)) {
                return false;
            }
            for (SqlReferenceExpression expression : this.getGlobalVariables()) {
                if (processor.execute((PsiElement)expression, state)) continue;
                return false;
            }
        }
        return true;
    }

    static boolean processDeclarationsImpl(PsiScopeProcessor processor, ResolveState state, PsiObject element, Condition<? super DasObject> expandCondition) {
        if (!(element instanceof DatabaseSystem) && !expandCondition.value((Object)element)) {
            return processor.execute((PsiElement)element, state);
        }
        final SqlLanguageDialectEx dialect = processor instanceof SqlScopeProcessor ? ((SqlScopeProcessor)processor).dialect : SqlImplUtil.getSqlDialectSafe((PsiElement)element);
        Condition<DasObject> majorChildCondition = new Condition<DasObject>(){

            public boolean value(DasObject object) {
                return dialect.isMajorChild(object.getKind());
            }
        };
        boolean majorChildExpected = SqlImplUtil.isMajorChildExpected(processor);
        DasModel model = element instanceof DatabaseSystem ? ((DatabaseSystem)element).getModel() : null;
        JBTreeTraverser traverser = model != null ? model.traverser() : (JBTreeTraverser)DasUtil.dasTraverser().withRoot((Object)element);
        for (DasObject object : ((JBTreeTraverser)traverser.expand(expandCondition)).bfsTraversal()) {
            if (!processor.execute((PsiElement)object, state)) {
                return false;
            }
            if (!majorChildExpected || object.getKind() != ObjectKind.TABLE) continue;
            JBIterable children = DasUtil.getDbChildren((DasObject)object, (DasModel)model).filter((Condition)majorChildCondition);
            for (DasObject major : children) {
                if (processor.execute((PsiElement)major, state)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    static Condition<DasObject> importedCondition(final SqlFile file, final SqlLanguageDialectEx dialect, final PsiElement place, boolean resolve) {
        Condition<DasObject> condition = new Condition<DasObject>(){

            public boolean value(DasObject element) {
                return element instanceof DasNamespace && dialect.isImportedAtPlace(file, element, place);
            }
        };
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl", "importedCondition"));
        }
        return condition;
    }

    static boolean isEmptyFakeNamespace(DasObject target) {
        return target instanceof NamespaceImpl && ((NamespaceImpl)target).delegates().isEmpty() && ((NamespaceImpl)target).children().isEmpty();
    }

    @NotNull
    public SqlResolveCache getResolveCache() {
        SqlResolveCache sqlResolveCache = (SqlResolveCache)this.myResolveCache.getValue();
        if (sqlResolveCache == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl", "getResolveCache"));
        }
        return sqlResolveCache;
    }

    @NotNull
    Couple<FakeDefinition> getMirror(@NotNull SqlDefinition o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/psi/impl/SqlFileImpl", "getMirror"));
        }
        FakeDefinition parent = ((State)this.myState.getValue()).children.get(o);
        FakeDefinition delegate = ((State)this.myState.getValue()).delegates.get(o);
        if (parent == null && delegate == null) {
            Couple couple = Couple.getEmpty();
            if (couple == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl", "getMirror"));
            }
            return couple;
        }
        Couple couple = Couple.of((Object)((Object)parent), (Object)((Object)delegate));
        if (couple == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl", "getMirror"));
        }
        return couple;
    }

    @Nullable
    private static ObjectTracer<?> trace(@Nullable SqlNameElement ref, @NotNull SqlLanguageDialectEx dialect, @NotNull CasingProvider casingProvider) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/impl/SqlFileImpl", "trace"));
        }
        if (casingProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "casingProvider", "com/intellij/sql/psi/impl/SqlFileImpl", "trace"));
        }
        return ref == null ? null : new SqlObjectTracer(ref, dialect, casingProvider);
    }

    @Nullable
    private static ObjectTracer<?> trace(@Nullable DbElement element) {
        return element == null ? null : new DbObjectTracer(element);
    }

    private static abstract class ObjectTracer<T> {
        private ObjectTracer() {
        }

        public abstract ObjectTraceIt<T> trace();

        public abstract ObjectKind getKind();

        public static abstract class ObjectTraceIt<T>
        implements Iterator<T> {
            private JBIterator<? extends T> myIt;

            public ObjectTraceIt(Iterator<? extends T> it) {
                this.myIt = JBIterator.from(it);
            }

            @Override
            public boolean hasNext() {
                return this.myIt.hasNext();
            }

            @Override
            public T next() {
                return (T)this.myIt.next();
            }

            @Override
            public void remove() {
                this.myIt.remove();
            }

            public abstract ObjectKind getKind();

            public abstract String getName();

            public abstract String getCorrectName();
        }
    }

    private static class SqlObjectTracer
    extends ObjectTracer<SqlNameElement> {
        private final SqlNameElement myRef;
        private final SqlLanguageDialectEx myDialect;
        private final CasingProvider myProvider;
        private ObjectKind myBaseKind;

        public SqlObjectTracer(@NotNull SqlNameElement ref, @NotNull SqlLanguageDialectEx dialect, @NotNull CasingProvider casingProvider) {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/sql/psi/impl/SqlFileImpl$SqlObjectTracer", "<init>"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/impl/SqlFileImpl$SqlObjectTracer", "<init>"));
            }
            if (casingProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "casingProvider", "com/intellij/sql/psi/impl/SqlFileImpl$SqlObjectTracer", "<init>"));
            }
            this.myRef = ref;
            this.myDialect = dialect;
            this.myProvider = casingProvider;
            this.myBaseKind = ref instanceof SqlReferenceExpression ? ((SqlReferenceExpression)ref).getReferenceElementType().getTargetKind() : (ref.getParent() instanceof SqlDefinition ? ((SqlDefinition)ref.getParent()).getKind() : (ref instanceof DasObject ? ((DasObject)ref).getKind() : null));
            this.myBaseKind = this.myBaseKind == SqlDbElementType.ANY ? ObjectKind.TABLE : this.myBaseKind;
        }

        @Override
        public ObjectTracer.ObjectTraceIt<SqlNameElement> trace() {
            return new ObjectTracer.ObjectTraceIt<SqlNameElement>((this.myRef instanceof SqlReferenceExpression ? ((SyntaxTraverser)SyntaxTraverser.revPsiTraverser().withRoot((Object)this.myRef)).filter(SqlReferenceExpression.class) : JBIterable.of((Object[])new SqlNameElement[]{this.myRef})).iterator()){
                private int myLevel;
                private final List<ObjectKind> myParentTypes;
                private ObjectKind myKind;
                private String myName;
                private String myCorrectName;
                {
                    super(it);
                    this.myParentTypes = ContainerUtil.newSmartList();
                    this.myLevel = myRef.getLastChild() instanceof PsiErrorElement ? 1 : 0;
                    this.myKind = myBaseKind;
                    myDialect.getParentDbTypes(this.myParentTypes, this.myKind);
                }

                @Override
                public SqlNameElement next() {
                    SqlNameElement item = (SqlNameElement)super.next();
                    if (this.myLevel++ > 0) {
                        SqlReferenceExpression current = (SqlReferenceExpression)ObjectUtils.tryCast((Object)item, SqlReferenceExpression.class);
                        ObjectKind k = current != null ? current.getReferenceElementType().getTargetKind() : SqlDbElementType.ANY;
                        ObjectKind objectKind = this.myKind = k != SqlDbElementType.ANY ? k : (ObjectKind)ContainerUtil.getFirstItem(this.myParentTypes, (Object)ObjectKind.NONE);
                        if (this.myKind != ObjectKind.NONE) {
                            this.myParentTypes.clear();
                            myDialect.getParentDbTypes(this.myParentTypes, this.myKind);
                        }
                    }
                    this.myName = this.myKind == ObjectKind.BODY ? "" : item.getName();
                    Case casing = myProvider.getCasing(this.myKind, null).choose(SqlImplUtil.hasPlainIdentifier(item, myDialect.getDatabaseDialect()));
                    this.myCorrectName = casing.apply(this.myName);
                    return item;
                }

                @Override
                public ObjectKind getKind() {
                    return this.myKind;
                }

                @Override
                public String getName() {
                    return this.myName;
                }

                @Override
                public String getCorrectName() {
                    return this.myCorrectName;
                }
            };
        }

        @Override
        public ObjectKind getKind() {
            return this.myBaseKind;
        }
    }

    private static class DbObjectTracer
    extends ObjectTracer<DbElement> {
        private final DbElement myElement;

        public DbObjectTracer(@NotNull DbElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlFileImpl$DbObjectTracer", "<init>"));
            }
            this.myElement = element;
        }

        @Override
        public ObjectTracer.ObjectTraceIt<DbElement> trace() {
            return new ObjectTracer.ObjectTraceIt<DbElement>(DasUtil.dasParents((DasObject)this.myElement).filter(DbElement.class).iterator()){
                private DbElement myCurrent;

                @Override
                public DbElement next() {
                    this.myCurrent = (DbElement)super.next();
                    return this.myCurrent;
                }

                @Override
                public ObjectKind getKind() {
                    return this.myCurrent.getKind();
                }

                @Override
                public String getName() {
                    return this.myCurrent.getName();
                }

                @Override
                public String getCorrectName() {
                    return this.myCurrent.getName();
                }
            };
        }

        @Override
        public ObjectKind getKind() {
            return this.myElement.getKind();
        }
    }

    private static class State {
        final Map<SqlDefinition, FakeDefinition> children = ContainerUtil.newLinkedHashMap();
        final Map<SqlDefinition, FakeDefinition> delegates = ContainerUtil.newLinkedHashMap();
        final CasingProvider casingProvider;

        State(CasingProvider provider) {
            this.casingProvider = provider;
        }

        void seal(Map<Object, GroupImpl> mirrors) {
            Set used = JBIterable.from(this.delegates.values()).append(this.children.values()).toSet();
            Iterator<GroupImpl> it = mirrors.values().iterator();
            while (it.hasNext()) {
                GroupImpl next = it.next();
                if (next instanceof DasNamespace || used.contains((Object)next)) continue;
                it.remove();
            }
        }

        JBIterable<SqlDefinition> children(FakeDefinition o) {
            return this.forMirror(o, this.children);
        }

        JBIterable<SqlDefinition> delegates(FakeDefinition o) {
            return this.forMirror(o, this.delegates);
        }

        JBIterable<SqlDefinition> forMirror(final FakeDefinition group, Map<SqlDefinition, FakeDefinition> map) {
            return JBIterable.from(map.entrySet()).filter((Condition)new Condition<Map.Entry<SqlDefinition, FakeDefinition>>(){

                public boolean value(Map.Entry<SqlDefinition, FakeDefinition> entry) {
                    return entry.getValue() == group;
                }
            }).transform((Function)new Function<Map.Entry<SqlDefinition, FakeDefinition>, SqlDefinition>(){

                public SqlDefinition fun(Map.Entry<SqlDefinition, FakeDefinition> entry) {
                    return entry.getKey();
                }
            });
        }
    }

    private static class NamespaceImpl
    extends GroupImpl
    implements DasNamespace {
        NamespaceImpl(@NotNull SqlElement parent, @NotNull String name, @Nullable String originalName, @NotNull ObjectKind kind) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/sql/psi/impl/SqlFileImpl$NamespaceImpl", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/sql/psi/impl/SqlFileImpl$NamespaceImpl", "<init>"));
            }
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/psi/impl/SqlFileImpl$NamespaceImpl", "<init>"));
            }
            super(parent, name, originalName, kind);
        }
    }

    private static class GroupImpl
    extends FakeDefinition {
        final ObjectKind kind;

        GroupImpl(@NotNull SqlElement parent, @NotNull String name, @Nullable String originalName, @NotNull ObjectKind kind) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/sql/psi/impl/SqlFileImpl$GroupImpl", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/sql/psi/impl/SqlFileImpl$GroupImpl", "<init>"));
            }
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/psi/impl/SqlFileImpl$GroupImpl", "<init>"));
            }
            super((PsiElement)parent, name, originalName);
            this.kind = kind;
        }

        @Override
        @Nullable
        public String getOriginalName() {
            SqlDefinition o = (SqlDefinition)this.delegates().first();
            return o != null ? o.getName() : super.getOriginalName();
        }

        @Override
        @NotNull
        public PsiElement getNavigationElement() {
            PsiElement element = super.getNavigationElement();
            if (element != this) {
                PsiElement psiElement = element;
                if (psiElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl$GroupImpl", "getNavigationElement"));
                }
                return psiElement;
            }
            SqlDefinition o = (SqlDefinition)this.children().first();
            GroupImpl groupImpl = o == null ? this : o.getNavigationElement();
            if (groupImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl$GroupImpl", "getNavigationElement"));
            }
            return groupImpl;
        }

        @Override
        @Nullable
        public PsiElement getNameIdentifier() {
            return super.getNameIdentifier();
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = this.kind;
            if (objectKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl$GroupImpl", "getKind"));
            }
            return objectKind;
        }

        @Override
        @NotNull
        public <C> JBIterable<C> getDbChildren(@NotNull Class<C> clazz, @NotNull ObjectKind kind) {
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/sql/psi/impl/SqlFileImpl$GroupImpl", "getDbChildren"));
            }
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/psi/impl/SqlFileImpl$GroupImpl", "getDbChildren"));
            }
            JBIterable jBIterable = JBIterable.from(this.children()).append(this.delegates(), DasUtil.ALL_CHILDREN).filter(DasUtil.byKind((ObjectKind)kind)).filter(clazz);
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl$GroupImpl", "getDbChildren"));
            }
            return jBIterable;
        }

        public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/psi/impl/SqlFileImpl$GroupImpl", "processDeclarations"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/sql/psi/impl/SqlFileImpl$GroupImpl", "processDeclarations"));
            }
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/sql/psi/impl/SqlFileImpl$GroupImpl", "processDeclarations"));
            }
            SqlFile file = this.getContainingFile();
            SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
            boolean resolve = !(processor instanceof SqlScopeProcessor) || ((SqlScopeProcessor)processor).resolve;
            Condition<DasObject> importedCondition = SqlFileImpl.importedCondition(file, dialect, place, resolve);
            for (SqlDefinition delegate : this.delegates()) {
                if (delegate.processDeclarations(processor, state, lastParent, place)) continue;
                return false;
            }
            for (SqlDefinition child : this.children()) {
                if (SqlFileImpl.processDeclarationsImpl(processor, state, (PsiObject)child, importedCondition)) continue;
                return false;
            }
            return true;
        }
    }

    public static abstract class FakeDefinition
    extends RenameableFakePsiElement
    implements SqlDefinition,
    SqlNameElement {
        private String myName;
        private String myOriginalName;

        protected FakeDefinition(@NotNull PsiElement parent, @NotNull String name, @Nullable String originalName) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/sql/psi/impl/SqlFileImpl$FakeDefinition", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/sql/psi/impl/SqlFileImpl$FakeDefinition", "<init>"));
            }
            super(parent);
            this.myName = name;
            this.myOriginalName = originalName;
        }

        public boolean isPlainIdentifier() {
            return true;
        }

        public boolean isQuotedIdentifier() {
            return false;
        }

        public SqlFile getContainingFile() {
            return (SqlFile)super.getContainingFile();
        }

        @NotNull
        public PsiElement getNavigationElement() {
            SqlDefinition o = (SqlDefinition)this.delegates().first();
            FakeDefinition fakeDefinition = o == null ? this : o.getNavigationElement();
            if (fakeDefinition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl$FakeDefinition", "getNavigationElement"));
            }
            return fakeDefinition;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl$FakeDefinition", "getName"));
            }
            return string;
        }

        @Nullable
        public String getComment() {
            return null;
        }

        @NotNull
        public <C> JBIterable<C> getDbChildren(@NotNull Class<C> clazz, @NotNull ObjectKind kind) {
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/sql/psi/impl/SqlFileImpl$FakeDefinition", "getDbChildren"));
            }
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/psi/impl/SqlFileImpl$FakeDefinition", "getDbChildren"));
            }
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFileImpl$FakeDefinition", "getDbChildren"));
            }
            return jBIterable;
        }

        @Nullable
        public String getOriginalName() {
            return this.myOriginalName;
        }

        public FakeDefinition setName(@NonNls @NotNull String name) throws IncorrectOperationException {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/sql/psi/impl/SqlFileImpl$FakeDefinition", "setName"));
            }
            for (SqlDefinition delegate : this.delegates()) {
                if (!Comparing.equal((String)delegate.getName(), (String)this.myName)) continue;
                delegate.setName(name);
            }
            this.myName = name;
            this.myOriginalName = name;
            return this;
        }

        public String getTypeName() {
            return SqlElementDescriptionProvider.getKindName(this);
        }

        public Icon getIcon() {
            return DbPresentation.getIcon((DasObject)this);
        }

        public void accept(SqlVisitor visitor) {
            visitor.visitSqlElement((SqlElement)this);
        }

        public void acceptChildren(SqlVisitor visitor) {
            SqlImplUtil.acceptChildren((SqlElement)this, visitor);
        }

        public SqlNameElement getNameElement() {
            SqlDefinition o = (SqlDefinition)this.delegates().first();
            return o == null ? this : o.getNameElement();
        }

        @Nullable
        public PsiElement getNameIdentifier() {
            return this.getNameElement();
        }

        @Nullable
        public DasObject getDbParent() {
            PsiElement parent = this.getParent();
            return parent instanceof DasObject ? (DasObject)parent : null;
        }

        public boolean isEquivalentTo(PsiElement another) {
            for (SqlDefinition delegate : this.delegates()) {
                if (!delegate.isEquivalentTo(another)) continue;
                return true;
            }
            return super.isEquivalentTo(another);
        }

        public JBIterable<SqlDefinition> delegates() {
            SqlFileImpl file = (SqlFileImpl)this.getContainingFile();
            return ((State)file.myState.getValue()).delegates(this);
        }

        public JBIterable<SqlDefinition> children() {
            SqlFileImpl file = (SqlFileImpl)this.getContainingFile();
            return ((State)file.myState.getValue()).children(this);
        }

        public String toString() {
            return this.getKind() + ":" + this.getName();
        }
    }
}

