/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlCompositeElementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlReferenceExpressionImpl;
import com.intellij.sql.psi.impl.SqlStringTokenElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlIdentifierImpl
extends SqlCompositeElementImpl
implements SqlIdentifier {
    public SqlIdentifierImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlIdentifierImpl", "<init>"));
        }
        super(node);
    }

    @Override
    @NotNull
    public String getName() {
        ASTNode id = this.getIdentifierNode();
        IElementType type = PsiUtilCore.getElementType((ASTNode)id);
        if (type == SqlTokens.SQL_STRING_TOKEN || type == SqlTokens.SQL_IDENT_DELIMITED) {
            String string = SqlStringTokenElement.getTokenText(id);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlIdentifierImpl", "getName"));
            }
            return string;
        }
        String string = id != null ? id.getText() : this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlIdentifierImpl", "getName"));
        }
        return string;
    }

    public SqlIdentifier setName(String newElementName) throws IncorrectOperationException {
        SqlReferenceExpression ref;
        SqlIdentifier newIdentifier;
        SqlLanguageDialectEx language = SqlImplUtil.getSqlDialectSafe((PsiElement)this);
        String realNewName = this.shouldQuote() ? language.quoteIdentifier(this, newElementName) : newElementName;
        String prefix = this.getNamePrefix();
        if (prefix != null) {
            realNewName = prefix + realNewName;
        }
        SqlDialectImplUtil.LOG.assertTrue((newIdentifier = ((SqlReferenceExpression)ObjectUtils.assertNotNull((Object)(ref = SqlPsiElementFactory.createReferenceFromText(realNewName, language, SqlCompositeElementTypes.SQL_SHORT_REFERENCE, (PsiElement)this)))).getIdentifier()) != null, (Object)("newElementName=" + newElementName + "; language=" + language.getID()));
        return (SqlIdentifier)this.replace((PsiElement)newIdentifier);
    }

    private boolean shouldQuote() {
        DasObject obj;
        if (!SqlImplUtil.getSqlDialectSafe((PsiElement)this).getDatabaseDialect().getFamilyId().isTransactSql()) {
            return true;
        }
        PsiElement parent = this.getParent();
        ObjectKind kind = parent instanceof SqlReferenceExpressionImpl ? ((SqlReferenceExpressionImpl)parent).getReferenceElementType().getTargetKind() : ((obj = (DasObject)PsiTreeUtil.getParentOfType((PsiElement)parent, SqlDefinition.class, (boolean)false)) == null ? null : obj.getKind());
        return kind != ObjectKind.ARGUMENT && kind != ObjectKind.VARIABLE;
    }

    public boolean isPlainIdentifier() {
        ASTNode id = this.getIdentifierNode();
        ASTNode last = this.getNode().getLastChildNode();
        if (id == null || id != last) {
            return false;
        }
        IElementType elementType = id.getElementType();
        return elementType == SqlTokens.SQL_IDENT || elementType instanceof SqlKeywordTokenType;
    }

    public boolean isQuotedIdentifier() {
        return PsiUtilCore.getElementType((ASTNode)this.getIdentifierNode()) instanceof SqlTokens.SqlStringLeafTokenType;
    }

    public TextRange getNameRange() {
        ASTNode id = this.getIdentifierNode();
        if (id == null) {
            return TextRange.EMPTY_RANGE;
        }
        IElementType type = PsiUtilCore.getElementType((ASTNode)id);
        TextRange r = id.getTextRange();
        int offset = r.getStartOffset() - this.getNode().getStartOffset();
        if (type == SqlTokens.SQL_STRING_TOKEN || type == SqlTokens.SQL_IDENT_DELIMITED) {
            return SqlStringTokenElement.getRangeInElement(id).shiftRight(offset);
        }
        return TextRange.from((int)offset, (int)r.getLength());
    }

    @Nullable
    public ASTNode getIdentifierNode() {
        return this.adjustVariablePrefix(this.getNode().getFirstChildNode());
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlIdentifier((SqlIdentifier)this);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/psi/impl/SqlIdentifierImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/sql/psi/impl/SqlIdentifierImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/sql/psi/impl/SqlIdentifierImpl", "processDeclarations"));
        }
        return true;
    }

    private ASTNode adjustVariablePrefix(ASTNode first) {
        ASTNode next = first == null ? null : first.getTreeNext();
        return next != null && SqlImplUtil.getSqlDialectSafe((PsiElement)this).isVariablePrefix(first.getText()) ? next : first;
    }

    @Nullable
    public String getNamePrefix() {
        ASTNode first = this.getNode().getFirstChildNode();
        ASTNode id = this.adjustVariablePrefix(first);
        return id == first ? null : first.getText();
    }
}

