/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlParameterDefinition;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.SqlVariableDefinitionImpl;
import com.intellij.sql.psi.stubs.SqlTypedDefinitionStub;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlParameterDefinitionImpl
extends SqlVariableDefinitionImpl
implements SqlParameterDefinition {
    public SqlParameterDefinitionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlParameterDefinitionImpl", "<init>"));
        }
        super(node);
    }

    public SqlParameterDefinitionImpl(@NotNull SqlTypedDefinitionStub<SqlVariableDefinition> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/sql/psi/impl/SqlParameterDefinitionImpl", "<init>"));
        }
        super(stub);
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = SqlDbElementType.PARAMETER;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlParameterDefinitionImpl", "getKind"));
        }
        return objectKind;
    }

    public DasRoutine getRoutine() {
        PsiElement parent = this.getParent();
        return parent instanceof DasRoutine ? (DasRoutine)parent : null;
    }

    @NotNull
    public DasArgument.Direction getArgumentDirection() {
        boolean outFound;
        ASTNode node = this.getNode();
        boolean inFound = node.findChildByType((IElementType)SqlCommonKeywords.SQL_IN) != null;
        boolean bl = outFound = node.findChildByType((IElementType)SqlCommonKeywords.SQL_OUT) != null;
        if (inFound && outFound) {
            DasArgument.Direction direction = DasArgument.Direction.INOUT;
            if (direction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlParameterDefinitionImpl", "getArgumentDirection"));
            }
            return direction;
        }
        if (inFound) {
            DasArgument.Direction direction = DasArgument.Direction.IN;
            if (direction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlParameterDefinitionImpl", "getArgumentDirection"));
            }
            return direction;
        }
        if (outFound) {
            DasArgument.Direction direction = DasArgument.Direction.OUT;
            if (direction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlParameterDefinitionImpl", "getArgumentDirection"));
            }
            return direction;
        }
        if (node.findChildByType((IElementType)SqlCommonKeywords.SQL_INOUT) != null) {
            DasArgument.Direction direction = DasArgument.Direction.INOUT;
            if (direction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlParameterDefinitionImpl", "getArgumentDirection"));
            }
            return direction;
        }
        DasArgument.Direction direction = DasArgument.Direction.IN;
        if (direction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlParameterDefinitionImpl", "getArgumentDirection"));
        }
        return direction;
    }

    @Override
    @Nullable
    public SqlTypeElement getTypeElement() {
        return (SqlTypeElement)this.findChildByClass(SqlTypeElement.class);
    }
}

