/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.ObjectKind;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlColumnDefinitionInTypeImpl;
import com.intellij.sql.psi.impl.SqlDefinitionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlPivotedTableDefinitionImpl
extends SqlDefinitionImpl
implements SqlExpression {
    public SqlPivotedTableDefinitionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlPivotedTableDefinitionImpl", "<init>"));
        }
        super(node);
    }

    @Nullable
    public SqlType getExpressionType() {
        SqlExpression expression = this.getExpression();
        return expression != null ? expression.getSqlType() : null;
    }

    public SqlTableType getColumnBasedType() {
        return new TableBasedSqlTableTypeImpl(PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, SqlColumnDefinitionInTypeImpl.class), (PsiElement)this);
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = SqlDbElementType.LOCAL_ALIAS;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlPivotedTableDefinitionImpl", "getKind"));
        }
        return objectKind;
    }

    @Nullable
    public SqlIdentifier getNameElement() {
        return (SqlIdentifier)this.findChildByClass(SqlIdentifier.class);
    }

    @Nullable
    public PsiReference getReference() {
        PsiReferenceBase ref = null;
        SqlIdentifier nameElement = this.getNameElement();
        if (nameElement != null) {
            ref = PsiReferenceBase.createSelfReference((PsiElement)this, (PsiElement)this);
            ref.setRangeInElement(nameElement.getNameRange().shiftRight(nameElement.getStartOffsetInParent()));
        }
        return ref;
    }

    @NotNull
    public SearchScope getUseScope() {
        SqlStatement statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)this, SqlStatement.class, (boolean)true);
        LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)(statement == null ? this.getContainingFile() : statement));
        if (localSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlPivotedTableDefinitionImpl", "getUseScope"));
        }
        return localSearchScope;
    }

    @Nullable
    public SqlExpression getExpression() {
        return (SqlExpression)this.findChildByClass(SqlExpression.class);
    }

    @NotNull
    public SqlType getSqlType() {
        SqlType expressionType = this.getExpressionType();
        if (expressionType instanceof SqlTableType) {
            SqlTableType columnBasedType = this.getColumnBasedType();
            PsiElement iterator = this.getColumnReference();
            SqlFunctionCallExpression functionCall = (SqlFunctionCallExpression)PsiTreeUtil.findChildOfType((PsiElement)this, SqlFunctionCallExpression.class);
            PsiElement col1 = iterator instanceof SqlReferenceExpression ? ((SqlReferenceExpression)iterator).resolve() : null;
            SqlExpressionList paramList = functionCall != null ? functionCall.getParameterList() : null;
            List list = paramList != null ? paramList.getExpressionList() : ContainerUtil.emptyList();
            SqlExpression item = (SqlExpression)ContainerUtil.getFirstItem((List)list);
            PsiReference reference = item != null ? item.getReference() : null;
            PsiElement col2 = reference != null ? reference.resolve() : null;
            int count = ((SqlTableType)expressionType).getColumnCount();
            ArrayList<SqlImplUtil.Column> result = new ArrayList<SqlImplUtil.Column>(count);
            SqlTableType type = (SqlTableType)expressionType;
            for (int i = 0; i < count; ++i) {
                PsiElement element = type.getColumnElement(i);
                PsiElement source = type.getSourceColumnElement(i);
                if (element != null && (element == col1 || element == col2) || source != null && (source == col1 || source == col2)) continue;
                result.add(new SqlImplUtil.Column(type.getColumnName(i), type.getColumnType(i), type.getColumnElement(i), type.getSourceColumnElement(i)));
            }
            SqlTableType sqlTableType = SqlImplUtil.createType(result, (PsiElement)this).join(columnBasedType);
            if (sqlTableType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlPivotedTableDefinitionImpl", "getSqlType"));
            }
            return sqlTableType;
        }
        SqlTableType sqlTableType = SqlTableTypeBase.EMPTY_TABLE;
        if (sqlTableType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlPivotedTableDefinitionImpl", "getSqlType"));
        }
        return sqlTableType;
    }

    public PsiElement getColumnReference() {
        return this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_COLUMN_REFERENCE);
    }

    @Override
    @Nullable
    public PsiElement getNameIdentifier() {
        return this.getNameElement();
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/psi/impl/SqlPivotedTableDefinitionImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/sql/psi/impl/SqlPivotedTableDefinitionImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/sql/psi/impl/SqlPivotedTableDefinitionImpl", "processDeclarations"));
        }
        SqlExpression expression = this.getExpression();
        if (!PsiTreeUtil.isAncestor((PsiElement)expression, (PsiElement)place, (boolean)true)) {
            SqlType type;
            SqlType sqlType = type = expression != null ? expression.getSqlType() : null;
            if (type instanceof SqlTableType && !SqlImplUtil.processDeclarationsInType((SqlTableType)type, processor, state)) {
                return false;
            }
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }
}

