/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.util.DasUtil;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlSynonymDefinition;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.stubs.SqlStubbedDefinitionImpl;
import com.intellij.sql.psi.stubs.SqlSynonymStub;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlSynonymDefinitionImpl
extends SqlStubbedDefinitionImpl<SqlSynonymStub<?>>
implements SqlSynonymDefinition {
    public SqlSynonymDefinitionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlSynonymDefinitionImpl", "<init>"));
        }
        super(node);
    }

    public SqlSynonymDefinitionImpl(SqlSynonymStub<?> stub) {
        super(stub, stub.getStubType());
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlSynonymDefinition((SqlSynonymDefinition)this);
    }

    @Override
    protected SqlReferenceElementType getExpectedNameReferenceElementType() {
        return SqlCompositeElementTypes.SQL_SYNONYM_REFERENCE;
    }

    @Override
    public SqlNameElement getNameElement() {
        SqlSynonymStub stub = (SqlSynonymStub)this.getStub();
        if (stub != null) {
            return stub.getNameReference();
        }
        SqlNameElement[] refs = (SqlNameElement[])this.findChildrenByClass(SqlNameElement.class);
        return refs.length > 0 ? refs[refs.length - 1] : null;
    }

    public SqlReferenceExpression getTargetReference() {
        SqlNameElement nameElement;
        SqlSynonymStub stub = (SqlSynonymStub)this.getStub();
        if (stub != null) {
            return stub.getTargetReference();
        }
        SqlNameElement[] refs = (SqlNameElement[])this.findChildrenByClass(SqlNameElement.class);
        if (refs.length > 1 && refs[0] instanceof SqlReferenceExpression) {
            return (SqlReferenceExpression)refs[0];
        }
        SqlStatement statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)this, SqlStatement.class, (boolean)true);
        if (statement instanceof SqlAlterStatement) {
            return ((SqlAlterStatement)statement).getAlterTargetReference();
        }
        if (statement instanceof SqlDefinition && (nameElement = ((SqlDefinition)statement).getNameElement()) instanceof SqlReferenceExpression) {
            return (SqlReferenceExpression)nameElement;
        }
        return null;
    }

    @Override
    @Nullable
    public Icon getIcon(int flags) {
        if (this.getStub() != null) {
            return this.getIcon();
        }
        return this.getIconSuper(flags);
    }

    @Override
    public Icon getIcon() {
        SqlReferenceExpression targetReference = this.getTargetReference();
        return targetReference == null ? null : DbPresentation.getIcon((ObjectKind)targetReference.getReferenceElementType().getTargetKind());
    }

    @Nullable
    public DasObject resolveTarget() {
        SqlReferenceExpression ref = this.getTargetReference();
        return ref == null ? null : (DasObject)ObjectUtils.tryCast((Object)ref.resolve(), DasObject.class);
    }

    @NotNull
    public Iterable<String> getTargetPath() {
        SqlReferenceExpression ref = this.getTargetReference();
        if (ref == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlSynonymDefinitionImpl", "getTargetPath"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.revPsiTraverser().withRoot((Object)ref)).expand(DasUtil.byClass(SqlReferenceExpression.class))).filter(SqlIdentifier.class).transform(SqlImplUtil.IDENT_TO_NAME);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlSynonymDefinitionImpl", "getTargetPath"));
        }
        return jBIterable;
    }
}

