/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DataType;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubtractedSqlTableTypeImpl
extends SqlTableTypeBase {
    private final SqlTableType myType;
    private final int myIndex;

    public SubtractedSqlTableTypeImpl(@NotNull SqlTableType type, @Nullable PsiElement element) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/sql/psi/impl/SubtractedSqlTableTypeImpl", "<init>"));
        }
        this.myType = type;
        int index = -1;
        int count = this.myType.getColumnCount();
        for (int i = 0; i < count; ++i) {
            if (!this.myType.getColumnElement(i).isEquivalentTo(element)) continue;
            index = i;
            break;
        }
        this.myIndex = index;
    }

    @Override
    @Nullable
    public PsiElement getTypeElement() {
        return this.myType.getTypeElement();
    }

    private boolean before(int i) {
        return this.myIndex >= 0 && i < this.myIndex;
    }

    public int getColumnCount() {
        if (this.myIndex >= 0) {
            return this.myType.getColumnCount() - 1;
        }
        return this.myType.getColumnCount();
    }

    @Nullable
    public PsiElement getColumnQualifier(int i) {
        if (this.before(i)) {
            return this.myType.getColumnQualifier(i);
        }
        return this.myType.getColumnQualifier(i + 1);
    }

    public String getColumnName(int i) {
        if (this.before(i)) {
            return this.myType.getColumnName(i);
        }
        return this.myType.getColumnName(i + 1);
    }

    public SqlType getColumnType(int i) {
        if (this.before(i)) {
            return this.myType.getColumnType(i);
        }
        return this.myType.getColumnType(i + 1);
    }

    public DataType getDataType(int i) {
        if (this.before(i)) {
            return this.myType.getDataType(i);
        }
        return this.myType.getDataType(i + 1);
    }

    @NotNull
    public PsiElement getColumnElement(int i) {
        if (this.before(i)) {
            PsiElement psiElement = this.myType.getColumnElement(i);
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SubtractedSqlTableTypeImpl", "getColumnElement"));
            }
            return psiElement;
        }
        PsiElement psiElement = this.myType.getColumnElement(i + 1);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SubtractedSqlTableTypeImpl", "getColumnElement"));
        }
        return psiElement;
    }

    @Nullable
    public PsiElement getSourceColumnElement(int i) {
        if (this.before(i)) {
            return this.myType.getSourceColumnElement(i);
        }
        return this.myType.getSourceColumnElement(i + 1);
    }
}

