/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring.rename.inplace;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenameHandler;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlParameterDefinition;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlInplaceRenameHandler
extends MemberInplaceRenameHandler {
    protected boolean isAvailable(PsiElement element, Editor editor, PsiFile file) {
        SqlNameElement nameElement;
        if (!editor.getSettings().isVariableInplaceRenameEnabled()) {
            return false;
        }
        if (element instanceof SqlFileImpl.FakeDefinition) {
            return false;
        }
        SqlNameElement sqlNameElement = nameElement = element instanceof SqlDefinition ? ((SqlDefinition)element).getNameElement() : null;
        if (nameElement == null && element instanceof SqlReferenceExpression && element instanceof PsiNameIdentifierOwner) {
            nameElement = ((SqlReferenceExpression)element).getIdentifier();
        }
        return nameElement != null;
    }

    @NotNull
    protected MemberInplaceRenamer createMemberRenamer(@NotNull PsiElement element, PsiNameIdentifierOwner elementToRename, Editor editor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/refactoring/rename/inplace/SqlInplaceRenameHandler", "createMemberRenamer"));
        }
        PsiElement identifier = elementToRename.getNameIdentifier();
        if (identifier != null) {
            MyMemberInplaceRenamer myMemberInplaceRenamer = new MyMemberInplaceRenamer(elementToRename, element, editor);
            if (myMemberInplaceRenamer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/refactoring/rename/inplace/SqlInplaceRenameHandler", "createMemberRenamer"));
            }
            return myMemberInplaceRenamer;
        }
        MemberInplaceRenamer memberInplaceRenamer = super.createMemberRenamer(element, elementToRename, editor);
        if (memberInplaceRenamer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/refactoring/rename/inplace/SqlInplaceRenameHandler", "createMemberRenamer"));
        }
        return memberInplaceRenamer;
    }

    private static class MyMemberInplaceRenamer
    extends MemberInplaceRenamer {
        private String myForcedPrefix;

        public MyMemberInplaceRenamer(@NotNull PsiNameIdentifierOwner elementToRename, PsiElement substituted, Editor editor) {
            if (elementToRename == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToRename", "com/intellij/sql/refactoring/rename/inplace/SqlInplaceRenameHandler$MyMemberInplaceRenamer", "<init>"));
            }
            super((PsiNamedElement)elementToRename, substituted, editor);
            this.myForcedPrefix = MyMemberInplaceRenamer.getForcedPrefix((PsiNamedElement)elementToRename);
        }

        private MyMemberInplaceRenamer(@NotNull PsiNamedElement elementToRename, PsiElement substituted, Editor editor, String initialName, String oldName) {
            if (elementToRename == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToRename", "com/intellij/sql/refactoring/rename/inplace/SqlInplaceRenameHandler$MyMemberInplaceRenamer", "<init>"));
            }
            super(elementToRename, substituted, editor, initialName, oldName);
            this.myForcedPrefix = MyMemberInplaceRenamer.getForcedPrefix(elementToRename);
        }

        @Nullable
        private static String getForcedPrefix(@NotNull PsiNamedElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/refactoring/rename/inplace/SqlInplaceRenameHandler$MyMemberInplaceRenamer", "getForcedPrefix"));
            }
            DatabaseFamilyId id = SqlImplUtil.getSqlDialectSafe((PsiElement)element).getDatabaseDialect().getFamilyId();
            if (!id.isTransactSql()) {
                return null;
            }
            if (element instanceof SqlParameterDefinition || element instanceof SqlVariableDefinition) {
                return "@";
            }
            return null;
        }

        protected boolean isIdentifier(String newName, Language l) {
            if (StringUtil.isEmpty((String)newName)) {
                return false;
            }
            if (!this.checkPrefix(newName)) {
                return false;
            }
            SqlLanguageDialectEx language = SqlImplUtil.getSqlDialectSafe(this.myScope);
            String realNewName = language.quoteIdentifier(this.myProject, newName);
            SqlReferenceExpression ref = SqlPsiElementFactory.createReferenceFromText(realNewName, language, SqlCompositeElementTypes.SQL_SHORT_REFERENCE, this.myScope);
            return ref != null && ref.getIdentifier() != null;
        }

        private boolean checkPrefix(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/sql/refactoring/rename/inplace/SqlInplaceRenameHandler$MyMemberInplaceRenamer", "checkPrefix"));
            }
            return this.myForcedPrefix == null || name.startsWith(this.myForcedPrefix);
        }

        protected PsiElement getNameIdentifier() {
            PsiFile currentFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
            PsiFile psiFile = currentFile = currentFile == null ? null : SqlImplUtil.getTopLevelSqlFile(currentFile);
            if (currentFile == null || !PsiTreeUtil.isContextAncestor((PsiElement)currentFile, (PsiElement)this.myElementToRename, (boolean)false)) {
                return super.getNameIdentifier();
            }
            return this.myElementToRename instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)this.myElementToRename).getNameIdentifier() : null;
        }

        @NotNull
        protected TextRange getRangeToRename(@NotNull PsiReference reference) {
            SqlIdentifier identifier;
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/sql/refactoring/rename/inplace/SqlInplaceRenameHandler$MyMemberInplaceRenamer", "getRangeToRename"));
            }
            SqlReferenceExpression expression = (SqlReferenceExpression)ObjectUtils.tryCast((Object)reference.getElement(), SqlReferenceExpression.class);
            SqlIdentifier sqlIdentifier = identifier = expression == null ? null : expression.getIdentifier();
            if (identifier != null) {
                TextRange textRange = identifier.getNameRange().shiftRight(identifier.getStartOffsetInParent());
                if (textRange == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/refactoring/rename/inplace/SqlInplaceRenameHandler$MyMemberInplaceRenamer", "getRangeToRename"));
                }
                return textRange;
            }
            TextRange textRange = super.getRangeToRename(reference);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/refactoring/rename/inplace/SqlInplaceRenameHandler$MyMemberInplaceRenamer", "getRangeToRename"));
            }
            return textRange;
        }

        @NotNull
        protected TextRange getRangeToRename(@NotNull PsiElement element) {
            SqlIdentifier identifier;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/refactoring/rename/inplace/SqlInplaceRenameHandler$MyMemberInplaceRenamer", "getRangeToRename"));
            }
            PsiElement nameElement = element;
            if (element instanceof SqlReferenceExpression) {
                nameElement = ((SqlReferenceExpression)element).getIdentifier();
            }
            if ((identifier = (SqlIdentifier)ObjectUtils.tryCast((Object)nameElement, SqlIdentifier.class)) != null) {
                TextRange textRange = identifier.getNameRange().shiftRight(identifier.getStartOffsetInParent());
                if (textRange == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/refactoring/rename/inplace/SqlInplaceRenameHandler$MyMemberInplaceRenamer", "getRangeToRename"));
                }
                return textRange;
            }
            TextRange textRange = super.getRangeToRename(element);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/refactoring/rename/inplace/SqlInplaceRenameHandler$MyMemberInplaceRenamer", "getRangeToRename"));
            }
            return textRange;
        }

        @NotNull
        protected VariableInplaceRenamer createInplaceRenamerToRestart(PsiNamedElement variable, Editor editor, String initialName) {
            MyMemberInplaceRenamer myMemberInplaceRenamer = new MyMemberInplaceRenamer(variable, this.getSubstituted(), editor, initialName, this.myOldName);
            if (myMemberInplaceRenamer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/refactoring/rename/inplace/SqlInplaceRenameHandler$MyMemberInplaceRenamer", "createInplaceRenamerToRestart"));
            }
            return myMemberInplaceRenamer;
        }

        protected boolean performRefactoring() {
            if (this.myInsertedName != null && !this.checkPrefix(this.myInsertedName)) {
                final PsiNamedElement variable = this.getVariable();
                if (variable != null) {
                    String cont = "Continue editing";
                    String cancel = "Cancel";
                    String ignore = "Rename anyway";
                    BaseListPopupStep<String> step = new BaseListPopupStep<String>("Identifier should start with `" + this.myForcedPrefix + "`", new String[]{"Continue editing", "Cancel", "Rename anyway"}){

                        public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                            if (selectedValue.equals("Rename anyway")) {
                                myForcedPrefix = null;
                            }
                            this.performRefactoringRename(myInsertedName, myMarkAction);
                            int offset = variable.getTextOffset();
                            this.restoreCaretOffset(offset);
                            if (selectedValue.equals("Continue editing")) {
                                this.createInplaceRenamerToRestart(variable, myEditor, myInsertedName).performInplaceRefactoring(myNameSuggestions);
                            }
                            return FINAL_CHOICE;
                        }

                        public boolean isMnemonicsNavigationEnabled() {
                            return true;
                        }
                    };
                    step.setDefaultOptionIndex(0);
                    JBPopupFactory.getInstance().createListPopup((ListPopupStep)step).showInBestPositionFor(this.myEditor);
                }
                return true;
            }
            return super.performRefactoring();
        }

        protected boolean acceptReference(PsiReference reference) {
            String referenceText;
            PsiElement element = reference.getElement();
            if (element instanceof SqlReferenceExpression) {
                referenceText = ((SqlReferenceExpression)element).getName();
            } else if (element instanceof SqlIdentifier) {
                referenceText = ((SqlIdentifier)element).getName();
            } else {
                TextRange textRange = reference.getRangeInElement();
                referenceText = element.getText().substring(textRange.getStartOffset(), textRange.getEndOffset());
            }
            return Comparing.strEqual((String)referenceText, (String)this.myElementToRename.getName(), (boolean)false);
        }

        protected SearchScope getReferencesSearchScope(VirtualFile file) {
            PsiElement scope = SqlImplUtil.getResolveScope(PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument()));
            return scope != null ? new LocalSearchScope(scope) : super.getReferencesSearchScope(file);
        }

        protected RenameProcessor createRenameProcessor(PsiElement element, String newName) {
            return new MemberInplaceRenamer.MyRenameProcessor(element, newName){

                public void doRun() {
                    PostprocessReformattingAspect.getInstance((Project)this.myProject).disablePostprocessFormattingInside(new Runnable(){

                        @Override
                        public void run() {
                            this.doSuperRun();
                        }
                    });
                }

                public void doSuperRun() {
                    super.doRun();
                }
            };
        }
    }
}

