/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.lang.psi;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesConfigurableProvider;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.coffeescript.CoffeeScriptDocStringUtil;
import org.coffeescript.CoffeeScriptLanguage;
import org.coffeescript.file.CoffeeScriptFileType;
import org.coffeescript.lang.lexer.CoffeeScriptTokenTypes;
import org.coffeescript.refactoring.CoffeeScriptChangeUtil;
import org.jetbrains.annotations.NotNull;

public class CoffeeScriptJSLanguageConfigurableProvider
extends JSInheritedLanguagesConfigurableProvider {
    @NotNull
    public Language getLanguage() {
        CoffeeScriptLanguage coffeeScriptLanguage = CoffeeScriptLanguage.INSTANCE;
        if (coffeeScriptLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/lang/psi/CoffeeScriptJSLanguageConfigurableProvider", "getLanguage"));
        }
        return coffeeScriptLanguage;
    }

    public boolean isBadExpressionStatement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/coffeescript/lang/psi/CoffeeScriptJSLanguageConfigurableProvider", "isBadExpressionStatement"));
        }
        return element instanceof JSThrowStatement || element instanceof JSReturnStatement;
    }

    public boolean isNeedToBeTerminated(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/coffeescript/lang/psi/CoffeeScriptJSLanguageConfigurableProvider", "isNeedToBeTerminated"));
        }
        return false;
    }

    public boolean isLHSExpression(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/coffeescript/lang/psi/CoffeeScriptJSLanguageConfigurableProvider", "isLHSExpression"));
        }
        return element instanceof JSObjectLiteralExpression || element.getParent() instanceof JSDefinitionExpression;
    }

    public boolean isCaseStatementInterrupted(JSStatement statement) {
        return true;
    }

    public boolean forConditionShouldUseVariables() {
        return false;
    }

    public boolean constructorCallWithoutNewActual() {
        return false;
    }

    public boolean unnecessaryBlockStatement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/coffeescript/lang/psi/CoffeeScriptJSLanguageConfigurableProvider", "unnecessaryBlockStatement"));
        }
        return element instanceof JSCaseClause;
    }

    public boolean hasNonBlockBranch(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/coffeescript/lang/psi/CoffeeScriptJSLanguageConfigurableProvider", "hasNonBlockBranch"));
        }
        return true;
    }

    public boolean isRemoveUnnecessaryParenthesesEnabled(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/coffeescript/lang/psi/CoffeeScriptJSLanguageConfigurableProvider", "isRemoveUnnecessaryParenthesesEnabled"));
        }
        return false;
    }

    public boolean isSimplifyBooleanFixEnabled(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/coffeescript/lang/psi/CoffeeScriptJSLanguageConfigurableProvider", "isSimplifyBooleanFixEnabled"));
        }
        return false;
    }

    public boolean shouldRenameFileWithClass(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/coffeescript/lang/psi/CoffeeScriptJSLanguageConfigurableProvider", "shouldRenameFileWithClass"));
        }
        return false;
    }

    protected PsiElement createExpressionFromText(@NotNull String text, @NotNull PsiElement element, boolean reportErrorIfFailed) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/coffeescript/lang/psi/CoffeeScriptJSLanguageConfigurableProvider", "createExpressionFromText"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/coffeescript/lang/psi/CoffeeScriptJSLanguageConfigurableProvider", "createExpressionFromText"));
        }
        return CoffeeScriptChangeUtil.createElementFromText(text, (FileType)CoffeeScriptFileType.COFFEE_SCRIPT_FILE_TYPE, element.getProject()).getFirstChild();
    }

    protected PsiElement createStatementFromText(@NotNull String text, @NotNull PsiElement element) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/coffeescript/lang/psi/CoffeeScriptJSLanguageConfigurableProvider", "createStatementFromText"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/coffeescript/lang/psi/CoffeeScriptJSLanguageConfigurableProvider", "createStatementFromText"));
        }
        return CoffeeScriptChangeUtil.createElementFromText(text, (FileType)CoffeeScriptFileType.COFFEE_SCRIPT_FILE_TYPE, element.getProject());
    }

    public boolean isMultilineLiteral(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/coffeescript/lang/psi/CoffeeScriptJSLanguageConfigurableProvider", "isMultilineLiteral"));
        }
        return element instanceof JSLiteralExpression && element.getFirstChild().getNode().getElementType() == CoffeeScriptTokenTypes.HEREDOC_START;
    }

    public String getMultilineLiteralContent(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/coffeescript/lang/psi/CoffeeScriptJSLanguageConfigurableProvider", "getMultilineLiteralContent"));
        }
        return CoffeeScriptDocStringUtil.getDocStringElementText(text, 0);
    }

    public TextRange getRangeInElement(PsiElement element) {
        int length = element.getTextLength();
        return TextRange.from((int)Math.min(3, length), (int)Math.max(length - 6, 0));
    }
}

