/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.cloud;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.javaee.openshift.agent.cloud.OSCloudAgentDeployment;
import com.intellij.javaee.openshift.cloud.OSDeploymentConfiguration;
import com.intellij.javaee.openshift.cloud.OSServerRuntimeInstance;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.agent.util.CloudGitApplication;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.debug.JavaDebugConnectionData;
import com.intellij.remoteServer.runtime.log.LoggingHandler;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudGitDeploymentRuntime;
import com.intellij.remoteServer.util.CloudMultiSourceServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.remoteServer.util.ssh.SshKeyAwareServerRuntime;
import com.intellij.remoteServer.util.ssh.SshKeyChecker;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitSimpleHandler;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryImpl;
import java.io.File;

public abstract class OSDeploymentRuntimeBase
extends CloudGitDeploymentRuntime {
    private static final Logger LOG = Logger.getInstance((String)("#" + OSDeploymentRuntimeBase.class.getName()));
    private static final String REMOTE_ORIGIN = "origin";
    private static final String REMOTE_OPENSHIFT = "openshift";
    private static final String CLOUD_NAME = "OpenShift";
    private static final Integer DEBUG_PORT = 8787;
    private final DeploymentTask<? extends CloudDeploymentNameConfiguration> myDeploymentTask;

    public OSDeploymentRuntimeBase(CloudMultiSourceServerRuntimeInstance serverRuntime, DeploymentSource source, File repositoryRoot, DeploymentTask<? extends CloudDeploymentNameConfiguration> task, DeploymentLogManager logManager) throws ServerRuntimeException {
        super(serverRuntime, source, repositoryRoot, task, logManager, REMOTE_OPENSHIFT, CLOUD_NAME);
        this.myDeploymentTask = task;
    }

    public OSCloudAgentDeployment getDeployment() {
        return (OSCloudAgentDeployment)super.getDeployment();
    }

    private void cleanRepository(CloudGitApplication application) throws ServerRuntimeException {
        Project project = this.getProject();
        File cloneDir = new CloudGitDeploymentRuntime.CloneJob((CloudGitDeploymentRuntime)this).cloneToTemp(application.getGitUrl());
        try {
            GitSimpleHandler handlerRM = new GitSimpleHandler(project, cloneDir, GitCommand.RM);
            handlerRM.setSilent(false);
            handlerRM.addParameters(this.getCleanRepositoryParameters());
            handlerRM.addParameters(new String[]{"-r"});
            handlerRM.run();
        }
        catch (VcsException e) {
            throw new ServerRuntimeException((Throwable)e);
        }
        try {
            GitSimpleHandler handlerCommit = new GitSimpleHandler(project, cloneDir, GitCommand.COMMIT);
            handlerCommit.setSilent(false);
            handlerCommit.setStdoutSuppressed(false);
            handlerCommit.addParameters(new String[]{"-a"});
            handlerCommit.addParameters(new String[]{"-m", "Deploy"});
            handlerCommit.endOptions();
            handlerCommit.run();
        }
        catch (VcsException e) {
            throw new ServerRuntimeException((Throwable)e);
        }
        VirtualFile temp = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(cloneDir);
        LOG.assertTrue(temp != null);
        GitRepository repository = GitRepositoryImpl.getInstance((VirtualFile)temp, (Project)project, (boolean)false);
        this.push(application, repository, REMOTE_ORIGIN);
    }

    private void pull() throws ServerRuntimeException {
        try {
            GitLineHandler pullHandler = new GitLineHandler(this.getProject(), this.getRepositoryRoot(), GitCommand.PULL);
            pullHandler.setUrl(this.getApplication().getGitUrl());
            pullHandler.setSilent(false);
            pullHandler.addParameters(new String[]{REMOTE_OPENSHIFT});
            pullHandler.addParameters(new String[]{"master"});
            pullHandler.addLineListener(this.createGitLineHandlerListener());
            this.performRemoteGitTask(pullHandler, "Pull OpenShift");
        }
        catch (Exception e) {
            throw new ServerRuntimeException((Throwable)e);
        }
    }

    protected void doGitRemote(String remoteName, CloudGitApplication application, String subCommand, String failMessage) throws ServerRuntimeException {
        this.cleanRepository(application);
        super.doGitRemote(remoteName, application, subCommand, failMessage);
        this.pull();
    }

    public CloudGitApplication deploy() throws ServerRuntimeException {
        DeploymentLogManager logManager = this.getLogManager();
        try {
            if (this.myDeploymentTask.isDebugMode()) {
                File debugMarkerFile = new File(this.getRepositoryRootFile(), FileUtil.toSystemDependentName((String)".openshift/markers/enable_jpda"));
                FileUtil.createIfDoesntExist((File)debugMarkerFile);
            }
            CloudGitApplication result = this.doDeploy();
            this.getDeployment().startListeningLog();
            if (logManager != null) {
                LoggingHandler loggingHandler = logManager.getMainLoggingHandler();
                loggingHandler.print("Access your application using ");
                loggingHandler.printHyperlink("SSH session...", new HyperlinkInfo(){

                    public void navigate(Project project) {
                        OSDeploymentRuntimeBase.this.startSshSession();
                    }
                });
                loggingHandler.print("\n");
            }
            return result;
        }
        catch (ServerRuntimeException e) {
            new SshKeyChecker().checkDeploymentError(e.getMessage(), (SshKeyAwareServerRuntime)((OSServerRuntimeInstance)this.getServerRuntime()), logManager, this.getTask());
            throw e;
        }
    }

    private void startSshSession() {
        this.getTaskExecutor().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    OSDeploymentRuntimeBase.this.getAgentTaskExecutor().execute(new Computable(){

                        public Object compute() {
                            OSDeploymentRuntimeBase.this.getDeployment().startSshSession();
                            return null;
                        }
                    });
                }
                catch (ServerRuntimeException e) {
                    OSDeploymentRuntimeBase.this.getCloudNotifier().showMessage(e.getMessage(), MessageType.ERROR);
                }
            }
        });
    }

    protected CloudGitApplication doDeploy() throws ServerRuntimeException {
        return super.deploy();
    }

    public void undeploy() throws ServerRuntimeException {
        super.undeploy();
        this.getDeployment().stopListeningLog();
    }

    public JavaDebugConnectionData getDebugConnectionData() throws ServerRuntimeException {
        Integer debugPort = ((OSDeploymentConfiguration)this.myDeploymentTask.getConfiguration()).getDebugPort();
        if (debugPort == null) {
            debugPort = DEBUG_PORT;
        }
        final Integer finalDebugPort = debugPort;
        this.getAgentTaskExecutor().execute(new Computable(){

            public Object compute() {
                OSCloudAgentDeployment cloudAgentDeployment = OSDeploymentRuntimeBase.this.getDeployment();
                cloudAgentDeployment.stopDebugPortForwarding();
                cloudAgentDeployment.startDebugPortForwarding(finalDebugPort);
                return null;
            }
        });
        return new JavaDebugConnectionData("127.0.0.1", debugPort.intValue());
    }

    protected abstract String[] getCleanRepositoryParameters();
}

