/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.velocity.Icons;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.VtlFileIndex;
import com.intellij.velocity.inspections.Util;
import com.intellij.velocity.psi.PsiUtil;
import com.intellij.velocity.psi.VtlLoopVariable;
import com.intellij.velocity.psi.VtlParameterDeclaration;
import com.intellij.velocity.psi.files.VtlFile;
import com.intellij.velocity.psi.files.VtlFileViewProvider;
import com.intellij.velocity.psi.reference.VtlReferenceExpression;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DefineInCommentIntention
implements IntentionAction {
    private final String myText;
    private final String myFamilyName;
    public static final String VELOCITY_IMPLICIT_VM = "velocity_implicit.vm";

    public DefineInCommentIntention(@NotNull String text, @NotNull String familyName) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/velocity/inspections/DefineInCommentIntention", "<init>"));
        }
        if (familyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "familyName", "com/intellij/velocity/inspections/DefineInCommentIntention", "<init>"));
        }
        this.myText = text;
        this.myFamilyName = familyName;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/inspections/DefineInCommentIntention", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.myFamilyName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/inspections/DefineInCommentIntention", "getFamilyName"));
        }
        return string;
    }

    public final boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/velocity/inspections/DefineInCommentIntention", "isAvailable"));
        }
        return file.getViewProvider() instanceof VtlFileViewProvider && this.getReferenceElement(editor, file) != null && ModuleUtilCore.findModuleForPsiElement((PsiElement)file) != null;
    }

    @Nullable
    protected PsiElement getReferenceElement(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/velocity/inspections/DefineInCommentIntention", "getReferenceElement"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/velocity/inspections/DefineInCommentIntention", "getReferenceElement"));
        }
        VtlReferenceExpression ref = Util.findReferenceExpression(editor, file);
        if (ref == null) {
            return null;
        }
        PsiElement resolve = ref.resolve();
        if (resolve instanceof VtlParameterDeclaration || resolve instanceof VtlLoopVariable || ref.multiResolve(false).length == 0) {
            return this.isAvailable(ref) ? ref : null;
        }
        return null;
    }

    protected boolean isAvailable(@NotNull VtlReferenceExpression ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/velocity/inspections/DefineInCommentIntention", "isAvailable"));
        }
        return true;
    }

    protected void defineInComment(Editor editor, final PsiFile fileWithVarReference, final PsiFile fileToInsertComment, final boolean addFileReference) {
        final PsiElement ref = this.getReferenceElement(editor, fileWithVarReference);
        assert (ref != null);
        final Project project = fileWithVarReference.getProject();
        if (!FileModificationService.getInstance().prepareFileForWrite(fileToInsertComment)) {
            return;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        final Document documentToInsertComment = documentManager.getDocument(fileToInsertComment);
        assert (documentToInsertComment != null);
        new WriteCommandAction(project, new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/velocity/inspections/DefineInCommentIntention$1", "run"));
                }
                Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, fileToInsertComment.getViewProvider().getVirtualFile(), 0), true);
                assert (editor != null);
                assert (documentToInsertComment == editor.getDocument());
                int insertionIndex = DefineInCommentIntention.this.calcInsertionIndex(documentToInsertComment);
                editor.getCaretModel().moveToOffset(insertionIndex);
                TemplateManager manager = TemplateManager.getInstance((Project)project);
                Template template = manager.createTemplate("", "");
                String relativePath = addFileReference ? PsiUtil.getRelativePath(fileToInsertComment, fileWithVarReference) : null;
                DefineInCommentIntention.this.prepareTemplate(template, ref, relativePath, fileToInsertComment);
                manager.startTemplate(editor, template);
            }
        }.execute();
    }

    protected int calcInsertionIndex(Document documentToInsertComment) {
        return documentToInsertComment.getText().startsWith("#* @implicitly included *#\n") ? "#* @implicitly included *#\n".length() : 0;
    }

    protected abstract void prepareTemplate(@NotNull Template var1, @NotNull PsiElement var2, @Nullable String var3, @NotNull PsiFile var4);

    protected void chooseTargetFile(final PsiFile file, final Editor editor, final boolean addFileReference) {
        Collection<VtlFile> implicitlyIncludedFiles = VtlFileIndex.getImplicitlyIncludedFiles(file);
        if (implicitlyIncludedFiles.size() == 1) {
            this.defineInComment(editor, file, (PsiFile)implicitlyIncludedFiles.iterator().next(), addFileReference);
            return;
        }
        if (implicitlyIncludedFiles.size() < 1) {
            VtlFile newTargetFile = (VtlFile)new WriteCommandAction<VtlFile>(file.getProject(), new PsiFile[0]){

                protected void run(@NotNull Result<VtlFile> result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/velocity/inspections/DefineInCommentIntention$2", "run"));
                    }
                    VirtualFile virtualFile = this.createVelocityImplicitVmFile();
                    if (virtualFile == null) {
                        return;
                    }
                    VfsUtil.saveText((VirtualFile)virtualFile, (String)"#* @implicitly included *#\n");
                    PsiFile psiFile = file.getManager().findFile(virtualFile);
                    if (psiFile instanceof VtlFile) {
                        result.setResult((Object)((VtlFile)psiFile));
                    }
                }

                @Nullable
                private VirtualFile createVelocityImplicitVmFile() throws IOException {
                    VirtualFile dir;
                    Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
                    VirtualFile[] roots = module == null ? VirtualFile.EMPTY_ARRAY : ModuleRootManager.getInstance((Module)module).getSourceRoots();
                    PsiDirectory psiDirectory = file.getContainingDirectory();
                    Object object = roots.length > 0 ? roots[0] : (dir = psiDirectory != null ? psiDirectory.getVirtualFile() : null);
                    if (dir == null) {
                        return null;
                    }
                    List existingNames = ContainerUtil.map((Object[])dir.getChildren(), (Function)new Function<VirtualFile, String>(){

                        public String fun(VirtualFile virtualFile) {
                            return virtualFile.getName();
                        }
                    });
                    return dir.createChildData((Object)this, UniqueNameGenerator.generateUniqueName((String)"velocity_implicit", (String)"", (String)".vm", (Collection)existingNames));
                }
            }.execute().getResultObject();
            if (newTargetFile != null) {
                this.defineInComment(editor, file, (PsiFile)newTargetFile, addFileReference);
            }
            return;
        }
        BaseListPopupStep<VtlFile> step = new BaseListPopupStep<VtlFile>(VelocityBundle.message("choose.external.definitions.file", new Object[0]), implicitlyIncludedFiles.toArray(new VtlFile[implicitlyIncludedFiles.size()])){

            @NotNull
            public String getTextFor(VtlFile value) {
                String string = value.getViewProvider().getVirtualFile().getName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/inspections/DefineInCommentIntention$3", "getTextFor"));
                }
                return string;
            }

            public PopupStep onChosen(VtlFile selectedValue, boolean finalChoice) {
                if (finalChoice) {
                    DefineInCommentIntention.this.defineInComment(editor, file, (PsiFile)selectedValue, addFileReference);
                }
                return super.onChosen((Object)selectedValue, finalChoice);
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public Icon getIconFor(VtlFile aValue) {
                return Icons.VTL_ICON;
            }
        };
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)step).showInBestPositionFor(editor);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

