/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.inspections;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.lang.Language;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.inspections.DefineInCommentIntention;
import com.intellij.velocity.inspections.StringCollectionExpression;
import com.intellij.velocity.inspections.Util;
import com.intellij.velocity.psi.files.VelocityPropertiesProvider;
import com.intellij.velocity.psi.reference.VtlFileReferenceSet;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DefineVelocityPropertiesRefForFilesIntention
extends DefineInCommentIntention {
    public DefineVelocityPropertiesRefForFilesIntention(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/velocity/inspections/DefineVelocityPropertiesRefForFilesIntention", "<init>"));
        }
        super(text, VelocityBundle.message("add.velocity.properties.ref.fix.name", new Object[0]));
    }

    @Override
    @Nullable
    protected PsiElement getReferenceElement(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/velocity/inspections/DefineVelocityPropertiesRefForFilesIntention", "getReferenceElement"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/velocity/inspections/DefineVelocityPropertiesRefForFilesIntention", "getReferenceElement"));
        }
        FileReference ref = Util.findReferenceExpression(editor, file, FileReference.class);
        return ref != null && ref.resolve() == null && Util.canSetVelocityProperties(file) ? ref.getElement() : null;
    }

    @Override
    protected void prepareTemplate(@NotNull Template template, @NotNull PsiElement element, String relativePath, @NotNull PsiFile fileToInsertComment) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/velocity/inspections/DefineVelocityPropertiesRefForFilesIntention", "prepareTemplate"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/velocity/inspections/DefineVelocityPropertiesRefForFilesIntention", "prepareTemplate"));
        }
        if (fileToInsertComment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToInsertComment", "com/intellij/velocity/inspections/DefineVelocityPropertiesRefForFilesIntention", "prepareTemplate"));
        }
        List<String> allFiles = DefineVelocityPropertiesRefForFilesIntention.computeFilePaths(element, fileToInsertComment);
        template.addTextSegment("#* @velocityproperties path=");
        StringCollectionExpression pathExpression = new StringCollectionExpression(allFiles);
        template.addVariable("PATH", (Expression)pathExpression, (Expression)pathExpression, true);
        String fileRef = relativePath != null ? " file=\"" + relativePath + "\"" : "";
        template.addTextSegment(fileRef + " *#\n");
        template.addEndVariable();
    }

    private static List<String> computeFilePaths(PsiElement element, final PsiFile fileToInsertComment) {
        final VtlFileReferenceSet refSet = Util.findVtlFileReferenceSet(element);
        if (refSet == null) {
            return Collections.emptyList();
        }
        final PsiFile[] referencedFiles = Util.findReferencedFiles(ModuleUtil.findModuleForPsiElement((PsiElement)element), refSet.getLastReference().getCanonicalText());
        if (referencedFiles.length == 0) {
            return Collections.emptyList();
        }
        return Util.collectFilePaths(element, new Function<PsiFile, String>(){

            public String fun(@NotNull PsiFile psiFile) {
                if (psiFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/velocity/inspections/DefineVelocityPropertiesRefForFilesIntention$1", "fun"));
                }
                PsiFile file = psiFile.getViewProvider().getPsi((Language)PropertiesLanguage.INSTANCE);
                if (file instanceof PropertiesFile) {
                    PropertiesFile propFile = (PropertiesFile)file;
                    VelocityPropertiesProvider velocityProperties = new VelocityPropertiesProvider(propFile);
                    for (PsiFile referencedFile : referencedFiles) {
                        String referencedFilePath = referencedFile.getViewProvider().getVirtualFile().getPath();
                        String filePath = Util.computeFilePath(velocityProperties, referencedFilePath, refSet.getPathString(), fileToInsertComment);
                        if (filePath == null) continue;
                        return filePath;
                    }
                }
                return null;
            }
        });
    }

    public static class ModuleWide
    extends DefineVelocityPropertiesRefForFilesIntention {
        public ModuleWide() {
            super(VelocityBundle.message("add.velocity.properties.ref.fix.name.module.wide", new Object[0]));
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/velocity/inspections/DefineVelocityPropertiesRefForFilesIntention$ModuleWide", "invoke"));
            }
            this.chooseTargetFile(file, editor, false);
        }
    }

    public static class LocalExternal
    extends DefineVelocityPropertiesRefForFilesIntention {
        public LocalExternal() {
            super(VelocityBundle.message("add.velocity.properties.ref.fix.name.external", new Object[0]));
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/velocity/inspections/DefineVelocityPropertiesRefForFilesIntention$LocalExternal", "invoke"));
            }
            this.chooseTargetFile(file, editor, true);
        }
    }

    public static class Local
    extends DefineVelocityPropertiesRefForFilesIntention {
        public Local() {
            super(VelocityBundle.message("add.velocity.properties.ref.fix.name.local", new Object[0]));
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/velocity/inspections/DefineVelocityPropertiesRefForFilesIntention$Local", "invoke"));
            }
            this.defineInComment(editor, file, file, false);
        }
    }
}

