/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.velocity.Icons;
import com.intellij.velocity.psi.VtlMacro;
import com.intellij.velocity.psi.VtlVariable;
import com.intellij.velocity.psi.files.VtlFile;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VtlExternalMacro
extends FakePsiElement
implements VtlMacro {
    @NotNull
    private final PsiComment myComment;
    private final String myName;
    private VtlVariable[] myParameters;

    private VtlExternalMacro(@NotNull PsiComment comment, @NotNull String name) {
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/velocity/psi/VtlExternalMacro", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/velocity/psi/VtlExternalMacro", "<init>"));
        }
        this.myComment = comment;
        this.myName = name;
    }

    public PsiFile getContainingFile() {
        return this.myComment.getContainingFile();
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.myComment.getLanguage();
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/VtlExternalMacro", "getLanguage"));
        }
        return language;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myComment.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/VtlExternalMacro", "getProject"));
        }
        return project;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/VtlExternalMacro", "getName"));
        }
        return string;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiComment psiComment = this.myComment;
        if (psiComment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/VtlExternalMacro", "getNavigationElement"));
        }
        return psiComment;
    }

    @NotNull
    public PsiElement getParent() {
        PsiComment psiComment = this.myComment;
        if (psiComment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/VtlExternalMacro", "getParent"));
        }
        return psiComment;
    }

    @Override
    @NotNull
    public VtlVariable[] getParameters() {
        if (this.myParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/VtlExternalMacro", "getParameters"));
        }
        return this.myParameters;
    }

    public void setParameters(String[] parameterNames) {
        this.myParameters = new Parameter[parameterNames.length];
        for (int i = 0; i < this.myParameters.length; ++i) {
            this.myParameters[i] = new Parameter(parameterNames[i]);
        }
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Nullable
    public final Icon getIcon(boolean open) {
        return Icons.SHARP_ICON;
    }

    public String toString() {
        return "ExternalMacro " + this.myName;
    }

    @Override
    public PsiComment getDocComment() {
        return null;
    }

    public static VtlExternalMacro getOrCreate(Map<String, VtlExternalMacro> mapToAddTo, final @NotNull PsiComment comment, final String name) {
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/velocity/psi/VtlExternalMacro", "getOrCreate"));
        }
        return (VtlExternalMacro)ContainerUtil.getOrCreate(mapToAddTo, (Object)name, (Factory)new Factory<VtlExternalMacro>(){

            public VtlExternalMacro create() {
                return new VtlExternalMacro(comment, name);
            }
        });
    }

    public boolean isVisibleIn(VtlFile placeFile) {
        return true;
    }

    private class Parameter
    extends FakePsiElement
    implements VtlVariable {
        private String myName;

        public Parameter(String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/velocity/psi/VtlExternalMacro$Parameter", "<init>"));
            }
            this.myName = name;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/VtlExternalMacro$Parameter", "getName"));
            }
            return string;
        }

        public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/velocity/psi/VtlExternalMacro$Parameter", "setName"));
            }
            PsiElement res = super.setName(name);
            this.myName = name;
            return res;
        }

        public PsiElement getParent() {
            return VtlExternalMacro.this.myComment;
        }

        @Override
        public PsiType getPsiType() {
            return null;
        }

        @Override
        @Nullable
        public PsiComment getDocComment() {
            return null;
        }
    }
}

