/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.persistence.integration;

import com.intellij.jpa.facet.JpaFacet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.persistence.extensions.PersistencePackagesProvider;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.xml.DomSpringBeanPointer;
import com.intellij.spring.persistence.integration.SpringAnnoPersistenceUnit;
import com.intellij.spring.persistence.integration.SpringXmlPersistenceUnit;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringEntityManagerFactoryProvider
implements PersistencePackagesProvider {
    private static final Key<CachedValue<List<PersistencePackage>>> SPRING_ENTITY_MANAGER_FACTORIES_KEY = Key.create((String)"SPRING_ENTITY_MANAGER_FACTORIES_KEY");

    @NotNull
    public List<PersistencePackage> getPersistencePackages(final PersistenceFacet facet) {
        final Module module = facet.getModule();
        if (!(facet instanceof JpaFacet) || !module.isLoaded() || DumbService.isDumb((Project)module.getProject())) {
            List<PersistencePackage> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/persistence/integration/SpringEntityManagerFactoryProvider", "getPersistencePackages"));
            }
            return list;
        }
        final Project project = module.getProject();
        List list = (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, SPRING_ENTITY_MANAGER_FACTORIES_KEY, (CachedValueProvider)new CachedValueProvider<List<PersistencePackage>>(){

            @Nullable
            public CachedValueProvider.Result<List<PersistencePackage>> compute() {
                HashSet result = new HashSet();
                SpringManager springManager = SpringManager.getInstance((Project)project);
                SpringModel springModel = SpringEntityManagerFactoryProvider.this.getModelInReadAction(module);
                PsiClass psiClass = SpringCommonUtils.findLibraryClass((Module)module, (String)"javax.persistence.EntityManagerFactory");
                if (psiClass != null) {
                    GlobalSearchScope inheritorsSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
                    SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)psiClass).withInheritors(inheritorsSearchScope).effectiveBeanTypes();
                    for (SpringBeanPointer bean : SpringModelSearchers.findBeans((CommonSpringModel)springModel, (SpringModelSearchParameters.BeanClass)searchParameters)) {
                        if (bean.isAbstract()) continue;
                        if (bean instanceof DomSpringBeanPointer) {
                            result.add(new SpringXmlPersistenceUnit((DomSpringBeanPointer)bean, facet.getModule()));
                            continue;
                        }
                        result.add(new SpringAnnoPersistenceUnit(bean, facet.getModule()));
                    }
                }
                ArrayList factories = new ArrayList(result);
                HashSet dependencies = new HashSet();
                dependencies.addAll(springModel.getConfigFiles());
                SpringEntityManagerFactoryProvider.addComponentScanDependencies(springModel, (Set)dependencies, project);
                return CachedValueProvider.Result.create(factories, (Object[])springManager.getModelsDependencies(module, ArrayUtil.toObjectArray((Collection)dependencies)));
            }
        }, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/persistence/integration/SpringEntityManagerFactoryProvider", "getPersistencePackages"));
        }
        return list;
    }

    private static void addComponentScanDependencies(@NotNull SpringModel springModel, @NotNull Set<Object> dependencies, @NotNull Project project) {
        if (springModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springModel", "com/intellij/spring/persistence/integration/SpringEntityManagerFactoryProvider", "addComponentScanDependencies"));
        }
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/intellij/spring/persistence/integration/SpringEntityManagerFactoryProvider", "addComponentScanDependencies"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/persistence/integration/SpringEntityManagerFactoryProvider", "addComponentScanDependencies"));
        }
        if (springModel.getComponentScans().size() > 0) {
            dependencies.addAll(ContainerUtil.newArrayList((Object[])new ModificationTracker[]{SpringModificationTrackersManager.getInstance((Project)project).getOuterModelsModificationTracker()}));
        }
    }

    @NotNull
    public SpringModel getModelInReadAction(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/persistence/integration/SpringEntityManagerFactoryProvider", "getModelInReadAction"));
        }
        SpringModel springModel = (SpringModel)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SpringModel>(){

            public SpringModel compute() {
                return SpringManager.getInstance((Project)module.getProject()).getCombinedModel(module);
            }
        });
        if (springModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/persistence/integration/SpringEntityManagerFactoryProvider", "getModelInReadAction"));
        }
        return springModel;
    }
}

