/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jetty.server;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.oss.jetty.JettyUtil;
import com.intellij.javaee.oss.jetty.server.JettyConfigFile;
import com.intellij.javaee.oss.jetty.server.JettyConfigFileChecker;
import com.intellij.javaee.oss.jetty.server.JettyConfigFilesCollector;
import com.intellij.javaee.oss.jetty.server.JettyConfigFilesEditor;
import com.intellij.javaee.oss.jetty.server.JettyIniProcessor;
import com.intellij.javaee.oss.jetty.server.JettyLocalModel;
import com.intellij.javaee.oss.jetty.server.JettyRunSettingsEditor;
import com.intellij.javaee.oss.jetty.server.JettyServerModel;
import com.intellij.javaee.oss.jetty.version.JettyVersionHandler;
import com.intellij.javaee.oss.server.JavaeeServerBaseProvider;
import com.intellij.javaee.oss.server.JavaeeServerHomeProvider;
import com.intellij.javaee.oss.server.JavaeeServerVersionProvider;
import com.intellij.javaee.run.configuration.ApplicationServerSelectionListener;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.PortField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JettyLocalEditor
extends JettyRunSettingsEditor<JettyLocalModel>
implements ApplicationServerSelectionListener {
    private JPanel myMainPanel;
    private PortField myPortField;
    private final JettyConfigFilesEditor myConfigFilesEditor;
    private JPanel myConfigFilesPanel;
    private ApplicationServer mySelectedApplicationServer;

    public JettyLocalEditor() {
        this.$$$setupUI$$$();
        this.myConfigFilesEditor = new JettyConfigFilesEditor();
        this.myConfigFilesPanel.add((Component)this.myConfigFilesEditor.getMainPanel(), "Center");
    }

    private JettyConfigFilesEditor setupConfigFileTypeDescriptor(JettyVersionHandler versionHandler) {
        this.myConfigFilesEditor.setConfigFileTypeDescriptor(versionHandler.getConfigFileTypeDescriptor());
        return this.myConfigFilesEditor;
    }

    @NotNull
    protected JComponent getEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/jetty/server/JettyLocalEditor", "getEditor"));
        }
        return jPanel;
    }

    @Override
    protected PortField getPortField() {
        return this.myPortField;
    }

    public void serverSelected(@Nullable ApplicationServer server) {
        if (server != null && this.mySelectedApplicationServer != server) {
            String version = new JavaeeServerVersionProvider(server).getValue();
            String home = new JavaeeServerHomeProvider(server).getValue();
            String workDir = JettyUtil.getWorkDir(version, home, new JavaeeServerBaseProvider(server).getValue());
            JettyVersionHandler versionHandler = JettyServerModel.getVersionHandler(version);
            JettyConfigFilesCollector collector = versionHandler.getConfigFilesCollector(home, workDir, null);
            collector.scanDir();
            collector.updateEditor(this.setupConfigFileTypeDescriptor(versionHandler));
            this.mySelectedApplicationServer = server;
        }
    }

    public void serverProbablyEdited(@Nullable ApplicationServer server) {
    }

    @Override
    protected void resetEditorFrom(JettyLocalModel model) {
        super.resetEditorFrom(model);
        JettyVersionHandler versionHandler = model.getVersionHandler();
        JettyConfigFilesCollector collector = versionHandler.getConfigFilesCollector(model.getHome(), model.getWorkDir(), model.getConfigFiles());
        collector.scanDir();
        collector.updateEditor(this.setupConfigFileTypeDescriptor(versionHandler));
    }

    @Override
    protected void applyEditorTo(JettyLocalModel model) throws ConfigurationException {
        super.applyEditorTo(model);
        JettyVersionHandler versionHandler = model.getVersionHandler();
        final JettyConfigFilesEditor configFilesEditor = this.setupConfigFileTypeDescriptor(versionHandler);
        final List<JettyConfigFile> configFiles = configFilesEditor.getFiles();
        final Set<String> activePaths = JettyConfigFile.getActivePaths(configFiles);
        final HashSet doubleActivePaths = new HashSet();
        final List<JettyConfigFileChecker> checkers = versionHandler.getConfigFileCheckers(configFilesEditor);
        for (JettyConfigFileChecker checker : checkers) {
            checker.checkActiveIncluded(activePaths);
        }
        new JettyIniProcessor(model.getWorkDir()){

            @Override
            protected void processPathLine(String path) {
                this.doProcessDoublePaths(path);
            }

            @Override
            protected void processModuleLine(String moduleName, boolean isCommented) {
                if (!isCommented) {
                    this.doProcessDoublePaths(JettyUtil.getModuleRelativePath(moduleName));
                }
            }

            private void doProcessDoublePaths(String path) {
                String independentPath = FileUtil.toSystemIndependentName((String)path);
                if (activePaths.contains(independentPath)) {
                    doubleActivePaths.add(FileUtil.toSystemDependentName((String)path));
                }
                for (JettyConfigFileChecker checker : checkers) {
                    checker.checkIniIncluded(independentPath);
                }
            }
        }.process();
        if (!doubleActivePaths.isEmpty()) {
            throw new RuntimeConfigurationError("Duplicate config file paths found", new Runnable(){

                @Override
                public void run() {
                    for (JettyConfigFile configFile : configFiles) {
                        if (!doubleActivePaths.contains(configFile.getPath())) continue;
                        configFile.setActive(false);
                    }
                    configFilesEditor.setFiles(configFiles);
                }
            });
        }
        model.setConfigFiles(configFiles);
        for (JettyConfigFileChecker checker : checkers) {
            checker.warn(configFiles);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        PortField portField;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("resources/jetty").getString("From.JettyLocalEditor.jmxPort"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPortField = portField = new PortField();
        jPanel2.add((Component)portField, new GridConstraints(0, 1, 1, 1, 8, 0, 6, 0, null, null, null));
        this.myConfigFilesPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, new Dimension(-1, 150), null));
        jLabel.setLabelFor((Component)portField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

