/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import org.jetbrains.plugins.grails.actions.GrailsActionUtil;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.settings.GrailsInjectedTraitService;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsModuleBasedApplication;
import org.jetbrains.plugins.grails.structure.impl.Grails3Application;

public class UpdateGrailsSettingsAction
extends DumbAwareAction {
    public UpdateGrailsSettingsAction() {
        super("Synchronize Grails settings", "Refresh IntelliJ IDEA project structure so that it matches Grails build settings", AllIcons.Actions.Refresh);
    }

    public void update(AnActionEvent e) {
        GrailsApplication application = GrailsActionUtil.getGrailsApplication(e.getDataContext());
        e.getPresentation().setEnabledAndVisible(application instanceof GrailsModuleBasedApplication || application instanceof Grails3Application);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project;
        GrailsApplication application = GrailsActionUtil.getGrailsApplication(e.getDataContext());
        if (application instanceof GrailsModuleBasedApplication) {
            GrailsFramework.forceSynchronizationSetting(((GrailsModuleBasedApplication)application).getModule());
        }
        if ((project = e.getProject()) != null) {
            GrailsInjectedTraitService.getInstance(project).queueUpdate(true);
        }
    }
}

