/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.config;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.config.GrailsConfigUtils;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.config.GrailsSettings;
import org.jetbrains.plugins.grails.config.GrailsStructure;
import org.jetbrains.plugins.grails.util.GrailsUtils;

@State(name="grailsSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
public class GrailsSettingsService
implements PersistentStateComponent<StateHolder> {
    private static final Key<GrailsSettings> TEST_DATA_KEY = Key.create((String)"TEST_DATA_KEY");
    private final Map<Module, GrailsSettings> map = new THashMap();
    private final Project project;

    public GrailsSettingsService(Project project) {
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static GrailsSettings getGrailsSettings(@NotNull Module module) {
        Map<Module, GrailsSettings> map;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsSettingsService", "getGrailsSettings"));
        }
        GrailsSettingsService service = (GrailsSettingsService)ServiceManager.getService((Project)module.getProject(), GrailsSettingsService.class);
        Map<Module, GrailsSettings> map2 = map = service.map;
        // MONITORENTER : map2
        GrailsSettings res = map.get(module);
        if (res == null) {
            VirtualFile buildConfig;
            VirtualFile conf;
            if (ApplicationManager.getApplication().isUnitTestMode() && (conf = GrailsUtils.findConfDirectory(module)) != null && (buildConfig = conf.findChild("BuildConfig.groovy")) != null && (res = (GrailsSettings)buildConfig.getUserData(TEST_DATA_KEY)) != null) {
                map.put(module, res);
                GrailsSettings grailsSettings = res;
                // MONITOREXIT : map2
                if (grailsSettings != null) return grailsSettings;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/config/GrailsSettingsService", "getGrailsSettings"));
            }
            res = new GrailsSettings();
            map.put(module, res);
        }
        GrailsSettings grailsSettings = res;
        // MONITOREXIT : map2
        if (grailsSettings != null) return grailsSettings;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/config/GrailsSettingsService", "getGrailsSettings"));
    }

    public static Key<GrailsSettings> getTestDataKey() {
        return TEST_DATA_KEY;
    }

    public static String getGrailsWorkDir(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsSettingsService", "getGrailsWorkDir"));
        }
        GrailsSettings settings = GrailsSettingsService.getGrailsSettings(module);
        String res = settings.properties.get("grails.work.dir");
        if (res != null) {
            return res;
        }
        return SystemProperties.getUserHome() + "/.grails/" + GrailsConfigUtils.getGrailsVersion(module);
    }

    public static String getProjectWorkDir(@NotNull Module module) {
        String appName;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsSettingsService", "getProjectWorkDir"));
        }
        GrailsSettings settings = GrailsSettingsService.getGrailsSettings(module);
        String res = settings.properties.get("grails.project.work.dir");
        if (res != null) {
            return res;
        }
        GrailsStructure structure = GrailsStructure.getInstance(module);
        if (structure == null) {
            VirtualFile root = GrailsFramework.getInstance().findAppRoot(module);
            assert (root != null);
            appName = root.getName();
        } else {
            appName = structure.isAtLeastGrails1_4() ? structure.getAppName() : structure.getAppRoot().getName();
        }
        return GrailsSettingsService.getGrailsWorkDir(module) + "/projects/" + appName;
    }

    public static String getProjectPluginsDir(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsSettingsService", "getProjectPluginsDir"));
        }
        GrailsSettings settings = GrailsSettingsService.getGrailsSettings(module);
        String res = settings.properties.get("grails.project.plugins.dir");
        if (res != null) {
            return res;
        }
        return GrailsSettingsService.getProjectWorkDir(module) + "/plugins";
    }

    public static String getGlobalPluginsDir(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsSettingsService", "getGlobalPluginsDir"));
        }
        GrailsSettings settings = GrailsSettingsService.getGrailsSettings(module);
        String res = settings.properties.get("grails.global.plugins.dir");
        if (res != null) {
            return res;
        }
        return GrailsSettingsService.getGrailsWorkDir(module) + "/global-plugins";
    }

    public static boolean isDebugRunForked(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsSettingsService", "isDebugRunForked"));
        }
        String res = GrailsSettingsService.getGrailsSettings((Module)module).properties.get("grails.project.fork.run");
        return Boolean.valueOf(res);
    }

    public static boolean isDebugTestForked(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsSettingsService", "isDebugTestForked"));
        }
        String res = GrailsSettingsService.getGrailsSettings((Module)module).properties.get("grails.project.fork.test");
        return Boolean.valueOf(res);
    }

    public StateHolder getState() {
        StateHolder res = new StateHolder();
        for (Map.Entry<Module, GrailsSettings> entry : this.map.entrySet()) {
            Module module = entry.getKey();
            if (module.isDisposed()) continue;
            res.map.put(module.getName(), entry.getValue());
        }
        return res;
    }

    public void loadState(StateHolder state) {
        this.map.clear();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.project);
        for (Map.Entry<String, GrailsSettings> entry : state.map.entrySet()) {
            Module module = moduleManager.findModuleByName(entry.getKey());
            if (module == null) continue;
            this.map.put(module, entry.getValue());
        }
    }

    public static class StateHolder {
        public Map<String, GrailsSettings> map = new THashMap();
    }
}

