/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.database;

import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.dataSource.DataSourceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.config.GroovyConfigReader;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class GrailsDataSourceDetector
extends DataSourceDetector {
    public boolean isRelevantFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/grails/database/GrailsDataSourceDetector", "isRelevantFile"));
        }
        if (!file.getName().equals("DataSource.groovy")) {
            return false;
        }
        VirtualFile dataSourceFile = file.getVirtualFile();
        if (dataSourceFile == null) {
            return false;
        }
        VirtualFile confDir = dataSourceFile.getParent();
        if (confDir == null || !confDir.getName().equals("conf")) {
            return false;
        }
        VirtualFile grailsAppDir = confDir.getParent();
        return grailsAppDir != null && grailsAppDir.getName().equals("grails-app");
    }

    public void collectDataSources(@NotNull Module module, @NotNull DataSourceDetector.Builder builder, boolean onTheFly) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/database/GrailsDataSourceDetector", "collectDataSources"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/grails/database/GrailsDataSourceDetector", "collectDataSources"));
        }
        GrailsFramework framework = GrailsFramework.getInstance();
        if (!framework.hasSupport(module)) {
            return;
        }
        VirtualFile confDirectory = GrailsUtils.findConfDirectory(module);
        if (confDirectory == null) {
            return;
        }
        VirtualFile dataSource = confDirectory.findChild("DataSource.groovy");
        if (dataSource == null) {
            return;
        }
        PsiFile psiDataSource = PsiManager.getInstance((Project)module.getProject()).findFile(dataSource);
        if (!(psiDataSource instanceof GroovyFile)) {
            return;
        }
        GroovyConfigReader cfg = GroovyConfigReader.read((GroovyFile)psiDataSource);
        PsiElement urlElement = cfg.getValue("development", "dataSource.url");
        if (urlElement == null) {
            return;
        }
        String driver = cfg.getStringValue("development", "dataSource.driverClassName");
        if (StringUtil.isEmpty((String)driver) || driver.equals("org.h2.Driver")) {
            return;
        }
        String url = cfg.getStringValue("development", "dataSource.url");
        if (StringUtil.isEmpty((String)url)) {
            return;
        }
        String dataSourceName = module.getName() + " dev";
        if (onTheFly && DataSourceManager.getInstance((Project)module.getProject()).getDataSourceByName(dataSourceName) != null) {
            return;
        }
        String userName = cfg.getStringValue("development", "dataSource.username");
        if (StringUtil.isEmpty((String)userName)) {
            return;
        }
        String password = cfg.getStringValue("development", "dataSource.password");
        if (StringUtil.isEmpty((String)password)) {
            return;
        }
        builder.withName(dataSourceName).withDriverClass(driver).withUrl(url).withUser(userName).withPassword(password).withDriverPath(GrailsDataSourceDetector.findJarByClassName(module, driver)).commit("grails", (Object)urlElement);
    }

    @Nullable
    private static String findJarByClassName(@NotNull Module module, @NotNull String className) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/database/GrailsDataSourceDetector", "findJarByClassName"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/plugins/grails/database/GrailsDataSourceDetector", "findJarByClassName"));
        }
        PsiClass driverClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(className, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false));
        if (driverClass == null) {
            return null;
        }
        VirtualFile classFile = driverClass.getContainingFile().getVirtualFile();
        if (classFile == null) {
            return null;
        }
        if (!(classFile.getFileSystem() instanceof JarFileSystem)) {
            return className;
        }
        VirtualFile jar = JarFileSystem.getInstance().getLocalVirtualFileFor(classFile);
        if (jar == null) {
            return null;
        }
        return jar.getPath();
    }
}

