/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.editor;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.ClassUtil;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;
import org.jetbrains.plugins.groovy.mvc.MvcCommandExecutor;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;

public class GenerateArtifactAction
extends AnAction {
    private final GrailsArtifact myArtifact;
    private final String myArtifactName;
    private final String myCommand;

    public GenerateArtifactAction(GrailsArtifact artifact, String artifactName, String command) {
        this.myArtifact = artifact;
        this.myArtifactName = artifactName;
        this.myCommand = command;
    }

    public void actionPerformed(AnActionEvent e) {
        final Module module = (Module)e.getData(DataKeys.MODULE);
        assert (module != null);
        final Project project = module.getProject();
        PsiClass relatedClassInstance = this.getRelatedArtifactInstance(module);
        if (relatedClassInstance == null) {
            return;
        }
        final String relatedQName = relatedClassInstance.getQualifiedName();
        if (relatedQName == null) {
            return;
        }
        String domainName = ClassUtil.createNewClassQualifiedName((String)ClassUtil.extractPackageName((String)relatedQName), (String)StringUtil.capitalize((String)this.myArtifactName));
        MvcCommand mvcCommand = new MvcCommand(this.myCommand, new String[]{domainName});
        MvcCommandExecutor.run((Module)module, (MvcFramework)GrailsFramework.getInstance(), (MvcCommand)mvcCommand, (Runnable)new Runnable(){

            @Override
            public void run() {
                VirtualFile directory = GenerateArtifactAction.this.myArtifact.findDirectory(module);
                if (directory == null) {
                    return;
                }
                String newArtifact = ClassUtil.createNewClassQualifiedName((String)ClassUtil.extractPackageName((String)relatedQName), (String)(StringUtil.capitalize((String)GenerateArtifactAction.this.myArtifactName) + ((GenerateArtifactAction)GenerateArtifactAction.this).myArtifact.suffix));
                VirtualFile file = directory.findFileByRelativePath(newArtifact.replace('.', '/') + ".groovy");
                if (file == null) {
                    return;
                }
                FileEditorManager.getInstance((Project)project).openFile(file, true);
            }
        }, (boolean)true, (String[])new String[0]);
    }

    @Nullable
    private PsiClass getRelatedArtifactInstance(Module module) {
        Collection<GrClassDefinition> controllerInstances = GrailsArtifact.CONTROLLER.getInstances(module, this.myArtifactName);
        if (controllerInstances.size() != 0) {
            return (PsiClass)controllerInstances.iterator().next();
        }
        Collection<GrClassDefinition> domainInstances = GrailsArtifact.DOMAIN.getInstances(module, this.myArtifactName);
        if (domainInstances.size() != 0) {
            return (PsiClass)domainInstances.iterator().next();
        }
        return null;
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        super.update(e);
        if (!presentation.isEnabled()) {
            return;
        }
        Module module = (Module)e.getData(DataKeys.MODULE);
        if (module != null && GrailsUtils.hasSupport(module) && this.getRelatedArtifactInstance(module) != null && this.myArtifact.getInstances(module, this.myArtifactName).isEmpty()) {
            return;
        }
        presentation.setEnabled(false);
        presentation.setVisible(false);
    }
}

