/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.editor;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import java.util.Collection;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;
import org.jetbrains.plugins.groovy.mvc.MvcCommandExecutor;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;

public class GenerateViewsAction
extends AnAction {
    private final String myArtifactName;

    public GenerateViewsAction(String artifactName) {
        this.myArtifactName = artifactName;
    }

    public void actionPerformed(AnActionEvent e) {
        Module module = (Module)e.getData(DataKeys.MODULE);
        Collection<GrClassDefinition> instances = GrailsArtifact.DOMAIN.getInstances(module, this.myArtifactName);
        if (instances.isEmpty()) {
            return;
        }
        String qName = instances.iterator().next().getQualifiedName();
        MvcCommand mvcCommand = new MvcCommand(GenerateViewsAction.getCommand(), new String[]{qName});
        MvcCommandExecutor.run((Module)module, (MvcFramework)GrailsFramework.getInstance(), (MvcCommand)mvcCommand, null, (boolean)true, (String[])new String[0]);
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        super.update(e);
        if (!presentation.isEnabled()) {
            return;
        }
        Module module = (Module)e.getData(DataKeys.MODULE);
        if (module != null && GrailsUtils.hasSupport(module) && GrailsArtifact.DOMAIN.getInstances(module, this.myArtifactName).size() > 0) {
            return;
        }
        presentation.setEnabled(false);
        presentation.setVisible(false);
    }

    private static String getCommand() {
        return "generate-views";
    }
}

