/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.gradle;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.task.TaskCallbackAdapter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.gradle.GrailsGradleInvoker;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutor;
import org.jetbrains.plugins.grails.runner.GrailsRunConfiguration;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.impl.OldGrailsGradleApplication;
import org.jetbrains.plugins.grails.util.version.Version;
import org.jetbrains.plugins.groovy.mvc.ConsoleProcessDescriptor;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;

public class GrailsGradleCommandExecutor
extends GrailsCommandExecutor {
    @Override
    public boolean isApplicable(@NotNull GrailsApplication grailsApplication) {
        if (grailsApplication == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grailsApplication", "org/jetbrains/plugins/grails/gradle/GrailsGradleCommandExecutor", "isApplicable"));
        }
        return grailsApplication instanceof OldGrailsGradleApplication;
    }

    @Override
    @Nullable
    public RunProfileState getState(@NotNull GrailsRunConfiguration configuration, @NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/plugins/grails/gradle/GrailsGradleCommandExecutor", "getState"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/plugins/grails/gradle/GrailsGradleCommandExecutor", "getState"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/plugins/grails/gradle/GrailsGradleCommandExecutor", "getState"));
        }
        return (executor1, runner) -> {
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/plugins/grails/gradle/GrailsGradleCommandExecutor", "lambda$getState$37"));
            }
            MvcCommand command = configuration.getGrailsCommand();
            new GrailsGradleInvoker(configuration.getGrailsApplication()).invoke(executor1.getId(), configuration.getName(), command, null);
            return null;
        };
    }

    @Override
    @Nullable
    public ConsoleProcessDescriptor execute(@NotNull GrailsApplication application, @NotNull MvcCommand command, final @Nullable Runnable onDone, boolean close, String ... input) throws ExecutionException {
        TaskCallbackAdapter taskCallback;
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/grails/gradle/GrailsGradleCommandExecutor", "execute"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/grails/gradle/GrailsGradleCommandExecutor", "execute"));
        }
        TaskCallbackAdapter taskCallbackAdapter = taskCallback = onDone == null ? null : new TaskCallbackAdapter(){

            public void onSuccess() {
                ApplicationManager.getApplication().invokeLater(onDone);
            }
        };
        if (command.getArgs() == null) {
            command.setArgs((List)ContainerUtil.newArrayList());
        }
        StringBuilder executionName = new StringBuilder().append(command.getCommand());
        if (!command.getArgs().isEmpty()) {
            executionName.append(": ").append(StringUtil.join((Collection)command.getArgs(), (String)" "));
        }
        if (!command.getArgs().contains("--non-interactive")) {
            command.getArgs().add("--non-interactive");
        }
        if (!command.getArgs().contains("-plain-output") && application.getVersion().isAtLeast(Version.GRAILS_2_0)) {
            command.getArgs().add("-plain-output");
        }
        new GrailsGradleInvoker(application).invoke(executionName.toString(), command, (TaskCallback)taskCallback);
        return null;
    }
}

