/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.i18n;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.properties.PrefixBasedPropertyReference;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import java.text.MessageFormat;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.i18n.GrailsI18nPropertyReferenceProvider;
import org.jetbrains.plugins.grails.inspections.GspAndGroovyInspection;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.gtag.GspAttribute;
import org.jetbrains.plugins.grails.lang.gsp.resolve.taglib.TagLibNamespaceDescriptor;
import org.jetbrains.plugins.grails.references.common.GroovyGspAttributeWrapper;
import org.jetbrains.plugins.grails.references.common.XmlGspAttributeWrapper;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrailsI18nInspection
extends GspAndGroovyInspection {
    private static final String SHORT_NAME = "InvalidI18nProperty";
    private static final Key<GrailsI18nInspection> SHORT_NAME_KEY = Key.create((String)"InvalidI18nProperty");
    public boolean ignoreTagsWithDefault;

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Grails" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/i18n/GrailsI18nInspection", "getGroupDisplayName"));
        }
        return "Grails";
    }

    @NotNull
    public String[] getGroupPath() {
        String[] stringArray = new String[]{"Groovy", this.getGroupDisplayName()};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/i18n/GrailsI18nInspection", "getGroupPath"));
        }
        return stringArray;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Invalid i18n property key" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/i18n/GrailsI18nInspection", "getDisplayName"));
        }
        return "Invalid i18n property key";
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/i18n/GrailsI18nInspection", "getShortName"));
        }
        return SHORT_NAME;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Ignore if default value specified", (InspectionProfileEntry)this, "ignoreTagsWithDefault");
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/i18n/GrailsI18nInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @Override
    protected GroovyRecursiveElementVisitor createGroovyFileVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/grails/i18n/GrailsI18nInspection", "createGroovyFileVisitor"));
        }
        return new GroovyRecursiveElementVisitor(){

            public void visitNamedArgument(GrNamedArgument argument) {
                GrExpression expression = argument.getExpression();
                if (expression instanceof GrLiteralImpl) {
                    GroovyGspAttributeWrapper attr;
                    Boolean refType;
                    PsiElement resolve;
                    GrExpression invokedExpression;
                    GrCall call;
                    if (((GrLiteralImpl)expression).isStringLiteral() && (call = PsiUtil.getCallByNamedParameter((GrNamedArgument)argument)) instanceof GrMethodCall && (invokedExpression = ((GrMethodCall)call).getInvokedExpression()) instanceof GrReferenceExpression && (resolve = ((GrReferenceExpression)invokedExpression).resolve()) instanceof TagLibNamespaceDescriptor.GspTagMethod && (refType = GrailsI18nPropertyReferenceProvider.getTypeOfReference(attr = new GroovyGspAttributeWrapper(argument, (TagLibNamespaceDescriptor.GspTagMethod)resolve))) != null && (!refType.booleanValue() || !GrailsI18nInspection.this.ignoreTagsWithDefault)) {
                        for (PsiReference reference : expression.getReferences()) {
                            if (!(reference instanceof PropertyReference)) continue;
                            GrailsI18nInspection.checkReference(holder, refType, isOnTheFly, (PropertyReference)reference);
                            break;
                        }
                    }
                    return;
                }
                super.visitNamedArgument(argument);
            }
        };
    }

    private static void checkReference(ProblemsHolder holder, boolean isSoft, boolean isOnTheFly, @NotNull PropertyReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/plugins/grails/i18n/GrailsI18nInspection", "checkReference"));
        }
        if (!(reference instanceof PrefixBasedPropertyReference && ((PrefixBasedPropertyReference)reference).isDynamicPrefix() || reference.multiResolve(false).length != 0)) {
            Object[] quickFixes;
            String message;
            String pattern = reference.getUnresolvedMessagePattern();
            String string = message = pattern.contains("{0}") ? MessageFormat.format(pattern, reference.getCanonicalText()) : pattern;
            if (!isOnTheFly) {
                quickFixes = LocalQuickFix.EMPTY_ARRAY;
            } else {
                quickFixes = reference.getQuickFixes();
                if (quickFixes == null) {
                    quickFixes = LocalQuickFix.EMPTY_ARRAY;
                }
                if (isSoft) {
                    quickFixes = (LocalQuickFix[])ArrayUtil.append((Object[])quickFixes, (Object)new LocalQuickFix(){

                        @NotNull
                        public String getName() {
                            if ("Don't check message code if default value is specified" == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/i18n/GrailsI18nInspection$2", "getName"));
                            }
                            return "Don't check message code if default value is specified";
                        }

                        @NotNull
                        public String getFamilyName() {
                            String string = this.getName();
                            if (string == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/i18n/GrailsI18nInspection$2", "getFamilyName"));
                            }
                            return string;
                        }

                        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                            if (project == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/i18n/GrailsI18nInspection$2", "applyFix"));
                            }
                            if (descriptor == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/plugins/grails/i18n/GrailsI18nInspection$2", "applyFix"));
                            }
                            PsiElement element = descriptor.getPsiElement();
                            InspectionProfile profile = InspectionProjectProfileManager.getInstance((Project)project).getInspectionProfile();
                            profile.modifyToolSettings(SHORT_NAME_KEY, element, (Consumer)new Consumer<GrailsI18nInspection>(){

                                public void consume(GrailsI18nInspection tool) {
                                    tool.ignoreTagsWithDefault = true;
                                }
                            });
                        }
                    });
                }
            }
            holder.registerProblemForReference((PsiReference)reference, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, message, (LocalQuickFix[])quickFixes);
        }
    }

    @Override
    protected GspAndGroovyInspection.GspElementVisitor createGspElementVisitor() {
        return new GspAndGroovyInspection.GspElementVisitor(){

            public void visitXmlAttribute(XmlAttribute attribute) {
                if (!(attribute instanceof GspAttribute)) {
                    return;
                }
                Boolean refType = GrailsI18nPropertyReferenceProvider.getTypeOfReference(new XmlGspAttributeWrapper((GspAttribute)attribute));
                if (!(refType == null || refType.booleanValue() && GrailsI18nInspection.this.ignoreTagsWithDefault)) {
                    XmlAttributeValue attributeValue = attribute.getValueElement();
                    if (attributeValue == null) {
                        return;
                    }
                    PropertyReference reference = GrailsI18nPropertyReferenceProvider.getReferenceByElement(attributeValue);
                    if (reference == null) {
                        return;
                    }
                    GrailsI18nInspection.checkReference(this.getProblemHolder(), refType, this.isOnTheFly(), reference);
                }
            }
        };
    }
}

