/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.debug;

import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspFile;

public class GspPositionManager
implements PositionManager {
    private final DebugProcess myDebugProcess;
    private final Map<String, String> className2gspName = Collections.synchronizedMap(new HashMap());
    public static final Pattern ESCAPED_CHAR = Pattern.compile("[^\\w]");

    public GspPositionManager(DebugProcess debugProcess) {
        this.myDebugProcess = debugProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String getGspClassName(PsiFile file) {
        String path;
        if (!(file instanceof GspFile)) {
            return null;
        }
        AccessToken accessToken = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            VirtualFile virtualFile = file.getOriginalFile().getVirtualFile();
            if (virtualFile == null) {
                String string = null;
                return string;
            }
            path = virtualFile.getPath();
        }
        finally {
            accessToken.finish();
        }
        String className = ESCAPED_CHAR.matcher(path.startsWith("/") ? path.substring(1) : path).replaceAll("_");
        this.className2gspName.put(className, path);
        return className;
    }

    public SourcePosition getSourcePosition(Location location) throws NoDataException {
        if (location == null) {
            throw NoDataException.INSTANCE;
        }
        ReferenceType refType = location.declaringType();
        if (refType == null) {
            throw NoDataException.INSTANCE;
        }
        String className = refType.name();
        int dollar = className.indexOf(36);
        String qname = dollar == -1 ? className : className.substring(0, dollar);
        String path = this.className2gspName.get(qname);
        if (path == null) {
            throw NoDataException.INSTANCE;
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
        if (virtualFile == null) {
            throw NoDataException.INSTANCE;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myDebugProcess.getProject()).findFile(virtualFile);
        GspPositionManager.checkGspFile(psiFile);
        return SourcePosition.createFromLine((PsiFile)psiFile, (int)(location.lineNumber() - 1));
    }

    private static void collectNestedTypes(List<ReferenceType> res, ReferenceType type, int line) {
        if (!type.isPrepared()) {
            return;
        }
        try {
            if (type.locationsOfLine(line).size() > 0) {
                res.add(type);
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        HashMap<String, ReferenceType> nestedTypeMap = new HashMap<String, ReferenceType>();
        for (ReferenceType referenceType : type.nestedTypes()) {
            nestedTypeMap.put(referenceType.name(), referenceType);
        }
        for (ReferenceType referenceType : nestedTypeMap.values()) {
            GspPositionManager.collectNestedTypes(res, referenceType, line);
        }
    }

    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition classPosition) throws NoDataException {
        if (classPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classPosition", "org/jetbrains/plugins/grails/lang/gsp/debug/GspPositionManager", "getAllClasses"));
        }
        PsiFile file = classPosition.getFile();
        GspPositionManager.checkGspFile(file);
        String className = this.getGspClassName(file);
        if (className == null) {
            throw NoDataException.INSTANCE;
        }
        ArrayList<ReferenceType> res = new ArrayList<ReferenceType>();
        List referenceTypes = this.myDebugProcess.getVirtualMachineProxy().classesByName(className);
        if (referenceTypes.size() > 0) {
            GspPositionManager.collectNestedTypes(res, (ReferenceType)referenceTypes.get(referenceTypes.size() - 1), classPosition.getLine() + 1);
        }
        ArrayList<ReferenceType> arrayList = res;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/debug/GspPositionManager", "getAllClasses"));
        }
        return arrayList;
    }

    private static void checkGspFile(PsiFile file) throws NoDataException {
        if (!(file instanceof GspFile)) {
            throw NoDataException.INSTANCE;
        }
    }

    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type, @NotNull SourcePosition position) throws NoDataException {
        block6: {
            List<Location> list;
            String qname;
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/grails/lang/gsp/debug/GspPositionManager", "locationsOfLine"));
            }
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/jetbrains/plugins/grails/lang/gsp/debug/GspPositionManager", "locationsOfLine"));
            }
            GspPositionManager.checkGspFile(position.getFile());
            String className = type.name();
            int dollar = className.indexOf(36);
            String string = qname = dollar == -1 ? className : className.substring(0, dollar);
            if (!this.className2gspName.containsKey(qname)) {
                throw NoDataException.INSTANCE;
            }
            try {
                List<Location> locations = type.locationsOfLine(position.getLine() + 1);
                if (locations.size() <= 0) break block6;
                list = locations;
            }
            catch (AbsentInformationException absentInformationException) {
                // empty catch block
            }
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/debug/GspPositionManager", "locationsOfLine"));
            }
            return list;
        }
        throw NoDataException.INSTANCE;
    }

    public ClassPrepareRequest createPrepareRequest(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) throws NoDataException {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "org/jetbrains/plugins/grails/lang/gsp/debug/GspPositionManager", "createPrepareRequest"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/jetbrains/plugins/grails/lang/gsp/debug/GspPositionManager", "createPrepareRequest"));
        }
        String className = this.getGspClassName(position.getFile());
        if (className == null) {
            throw NoDataException.INSTANCE;
        }
        return this.myDebugProcess.getRequestsManager().createClassPrepareRequest(requestor, className + '*');
    }
}

