/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.parsing.html;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.CharTable;
import com.intellij.util.LocalTimeCounter;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.lang.gsp.lexer.GspTokenTypesEx;
import org.jetbrains.plugins.grails.lang.gsp.parsing.gsp.lexer.GspLexer;
import org.jetbrains.plugins.grails.lang.gsp.psi.html.impl.GspHtmlOuterElementImpl;

public class GspHtmlTemplateRootType
extends IFileElementType {
    public GspHtmlTemplateRootType(@NonNls String debugName) {
        super(debugName, StdLanguages.HTML);
    }

    public ASTNode parseContents(ASTNode chameleon) {
        CharTable table = SharedImplUtil.findCharTableByTree((ASTNode)chameleon);
        PsiManagerEx manager = ((TreeElement)chameleon).getManager();
        CharSequence chars = chameleon.getChars();
        String templateText = GspHtmlTemplateRootType.createTemplateText(chars);
        PsiFile templateFile = GspHtmlTemplateRootType.createHtmlFileFromText(templateText, (PsiManager)manager);
        FileElement parsed = ((PsiFileImpl)templateFile).calcTreeElement();
        GspLexer lexer = new GspLexer();
        lexer.start(chars);
        GspHtmlTemplateRootType.insertOuters((TreeElement)parsed, (Lexer)lexer, table);
        FileElement treeElement = new DummyHolder((PsiManager)manager, null, table).getTreeElement();
        if (parsed != null) {
            treeElement.rawAddChildren(parsed.getFirstChildNode());
        }
        treeElement.subtreeChanged();
        return treeElement.getFirstChildNode();
    }

    private static String createTemplateText(CharSequence buf) {
        IElementType tokenType;
        GspLexer lexer = new GspLexer();
        StringBuilder result = new StringBuilder(buf.length());
        lexer.start(buf);
        while ((tokenType = lexer.getTokenType()) != null) {
            if (tokenType == GspTokenTypesEx.GSP_TEMPLATE_DATA || tokenType == XmlTokenType.XML_WHITE_SPACE) {
                result.append(buf, lexer.getTokenStart(), lexer.getTokenEnd());
            }
            lexer.advance();
        }
        return result.toString();
    }

    private static PsiFile createHtmlFileFromText(String text, PsiManager manager) {
        LightVirtualFile virtualFile = new LightVirtualFile("foo", (FileType)new LanguageFileType(StdLanguages.HTML){

            @NotNull
            @NonNls
            public String getDefaultExtension() {
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/parsing/html/GspHtmlTemplateRootType$1", "getDefaultExtension"));
                }
                return "";
            }

            @NotNull
            @NonNls
            public String getDescription() {
                String string = "fake for language" + StdLanguages.HTML.getID();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/parsing/html/GspHtmlTemplateRootType$1", "getDescription"));
                }
                return string;
            }

            @Nullable
            public Icon getIcon() {
                return null;
            }

            @NotNull
            @NonNls
            public String getName() {
                String string = StdLanguages.HTML.getID();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/parsing/html/GspHtmlTemplateRootType$1", "getName"));
                }
                return string;
            }
        }, (CharSequence)text, LocalTimeCounter.currentTime());
        SingleRootFileViewProvider viewProvider = new SingleRootFileViewProvider(manager, (VirtualFile)virtualFile, false){

            @NotNull
            public Language getBaseLanguage() {
                Language language = StdLanguages.HTML;
                if (language == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/parsing/html/GspHtmlTemplateRootType$2", "getBaseLanguage"));
                }
                return language;
            }
        };
        return viewProvider.getPsi(StdLanguages.HTML);
    }

    private static void insertOuters(TreeElement root, Lexer lexer, CharTable table) {
        IElementType tt;
        PsiManagerEx manager = root.getManager();
        int treeOffset = 0;
        Object leaf = TreeUtil.findFirstLeaf((ASTNode)root);
        while ((tt = lexer.getTokenType()) != null) {
            if (tt != GspTokenTypesEx.GSP_TEMPLATE_DATA && tt != XmlTokenType.XML_WHITE_SPACE) {
                int tokenStart = lexer.getTokenStart();
                while (leaf != null && treeOffset < tokenStart) {
                    if ((treeOffset += leaf.getTextLength()) > tokenStart) {
                        leaf = GspHtmlTemplateRootType.split((PsiManager)manager, leaf, leaf.getTextLength() - (treeOffset - tokenStart), table);
                        treeOffset = tokenStart;
                    }
                    leaf = (LeafElement)TreeUtil.nextLeaf((ASTNode)leaf);
                }
                if (leaf == null) break;
                GspHtmlOuterElementImpl element = GspHtmlTemplateRootType.createOuterElement(lexer, table);
                TreeElement anchor = GspHtmlTemplateRootType.insert(leaf.getTreeParent(), (TreeElement)leaf, element);
                anchor.getTreeParent().subtreeChanged();
                leaf = element;
            }
            lexer.advance();
        }
        if (tt != null) {
            do {
                assert (tt != GspTokenTypesEx.GSP_TEMPLATE_DATA && tt != XmlTokenType.XML_WHITE_SPACE);
                GspHtmlOuterElementImpl outerElement = GspHtmlTemplateRootType.createOuterElement(lexer, table);
                ((CompositeElement)root).rawAddChildren((TreeElement)outerElement);
                lexer.advance();
            } while ((tt = lexer.getTokenType()) != null);
            ((CompositeElement)root).subtreeChanged();
        }
    }

    private static GspHtmlOuterElementImpl createOuterElement(Lexer lexer, CharTable table) {
        return new GspHtmlOuterElementImpl(GspTokenTypesEx.GSP_FRAGMENT_IN_HTML, LexerUtil.internToken((Lexer)lexer, (CharTable)table));
    }

    private static TreeElement insert(CompositeElement parent, @NotNull TreeElement anchorBefore, OuterLanguageElement toInsert) {
        if (anchorBefore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchorBefore", "org/jetbrains/plugins/grails/lang/gsp/parsing/html/GspHtmlTemplateRootType", "insert"));
        }
        if (parent.getPsi() instanceof XmlTag && anchorBefore.getElementType() == XmlTokenType.XML_START_TAG_START) {
            parent.rawInsertBeforeMe((TreeElement)toInsert);
            return parent;
        }
        anchorBefore.rawInsertBeforeMe((TreeElement)toInsert);
        return anchorBefore;
    }

    private static LeafElement split(PsiManager manager, LeafElement leaf, int offset, CharTable table) {
        CharSequence chars = leaf.getChars();
        LeafElement leftPart = Factory.createSingleLeafElement((IElementType)leaf.getElementType(), (CharSequence)chars, (int)0, (int)offset, (CharTable)table, (PsiManager)manager);
        LeafElement rightPart = Factory.createSingleLeafElement((IElementType)leaf.getElementType(), (CharSequence)chars, (int)offset, (int)chars.length(), (CharTable)table, (PsiManager)manager);
        leaf.rawInsertAfterMe((TreeElement)leftPart);
        leftPart.rawInsertAfterMe((TreeElement)rightPart);
        leaf.rawRemove();
        return leftPart;
    }
}

