/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.resolve.taglib;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.search.AllClassesSearchExecutor;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Consumer;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.lang.gsp.resolve.taglib.TagLibNamespaceDescriptor;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.mvc.MvcModuleStructureSynchronizer;
import org.jetbrains.plugins.groovy.util.LightCacheKey;

public class GspTagLibUtil {
    private static final LightCacheKey<Pair<Map<String, XmlAttributeDescriptor>, Set<String>>> ATTR_FROM_SOURCE_KEY = LightCacheKey.createByFileModificationCount();
    private static final Set<String> NOT_TAGS = ContainerUtil.newHashSet((Object[])new String[]{"grailsApplication", "out", "grailsUrlMappingsHolder", "typeConverter", "renderNoSelectionOption"});
    @NonNls
    public static final String DEFAULT_TAGLIB_PREFIX = "g";
    @NonNls
    public static final String DYNAMIC_TAGLIB_PACKAGE = "org.codehaus.groovy.grails.plugins.web.taglib";
    @NonNls
    public static final String NAMESPACE_FIELD = "namespace";
    private static final Map<String, String> TAG_NAME_TO_CLASS_NAME = new HashMap<String, String>();
    private static final Map<String, String> CLASS_NAME_TO_TAG_NAME = new HashMap<String, String>();
    public static final Map<String, String> TAGLIB_PREFEXES;

    private GspTagLibUtil() {
    }

    public static Set<String> getExcludedTags(String prefix) {
        return DEFAULT_TAGLIB_PREFIX.equals(prefix) ? NOT_TAGS : Collections.emptySet();
    }

    public static TagLibNamespaceDescriptor getTagLibClasses(@NotNull PsiElement place, @NotNull String tagLibPrefix) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/grails/lang/gsp/resolve/taglib/GspTagLibUtil", "getTagLibClasses"));
        }
        if (tagLibPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagLibPrefix", "org/jetbrains/plugins/grails/lang/gsp/resolve/taglib/GspTagLibUtil", "getTagLibClasses"));
        }
        return GspTagLibUtil.getTagLibClasses(place).get(tagLibPrefix);
    }

    public static Map<String, TagLibNamespaceDescriptor> getTagLibClasses(@NotNull PsiElement place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/grails/lang/gsp/resolve/taglib/GspTagLibUtil", "getTagLibClasses"));
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)place);
        if (module == null) {
            return Collections.emptyMap();
        }
        return GspTagLibUtil.getTagLibClasses(module);
    }

    public static Map<String, TagLibNamespaceDescriptor> getTagLibClasses(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/lang/gsp/resolve/taglib/GspTagLibUtil", "getTagLibClasses"));
        }
        return (Map)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, (CachedValueProvider)new CachedValueProvider<Map<String, TagLibNamespaceDescriptor>>(){

            public CachedValueProvider.Result<Map<String, TagLibNamespaceDescriptor>> compute() {
                return CachedValueProvider.Result.create((Object)GspTagLibUtil.computeCustomTaglibClasses(module), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
        });
    }

    private static Map<String, TagLibNamespaceDescriptor> computeCustomTaglibClasses(Module module) {
        HashMap<String, TagLibNamespaceDescriptor> res = new HashMap<String, TagLibNamespaceDescriptor>();
        res.put(DEFAULT_TAGLIB_PREFIX, new TagLibNamespaceDescriptor(DEFAULT_TAGLIB_PREFIX, module));
        LinkedHashSet taglibs = ContainerUtil.newLinkedHashSet();
        taglibs.addAll(GrailsArtifact.TAGLIB.getInstances(module).values());
        taglibs.addAll(GspTagLibUtil.searchTaglibsInClassPath(module));
        for (GrClassDefinition classDefinition : taglibs) {
            String prefix = GspTagLibUtil.getPrefixByTagLibClass(classDefinition);
            TagLibNamespaceDescriptor descr = (TagLibNamespaceDescriptor)res.get(prefix);
            if (descr == null) {
                descr = new TagLibNamespaceDescriptor(prefix, module);
                res.put(prefix, descr);
            }
            descr.addClass((PsiClass)classDefinition);
        }
        PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)module.getProject()).findPackage(DYNAMIC_TAGLIB_PACKAGE);
        if (psiPackage != null) {
            for (PsiClass tagLibClass : psiPackage.getClasses(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module))) {
                TagLibNamespaceDescriptor descr;
                String name = tagLibClass.getName();
                if (name == null || !name.endsWith(GrailsArtifact.TAGLIB.suffix)) continue;
                String prefix = TAGLIB_PREFEXES.get(tagLibClass.getQualifiedName());
                if (prefix == null) {
                    prefix = DEFAULT_TAGLIB_PREFIX;
                }
                if ((descr = (TagLibNamespaceDescriptor)res.get(prefix)) == null) {
                    descr = new TagLibNamespaceDescriptor(prefix, module);
                    res.put(prefix, descr);
                }
                descr.addClass(tagLibClass);
            }
        }
        return res;
    }

    @NotNull
    private static Collection<GrClassDefinition> searchTaglibsInClassPath(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/lang/gsp/resolve/taglib/GspTagLibUtil", "searchTaglibsInClassPath"));
        }
        final Project project = module.getProject();
        Collection collection = (Collection)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, (CachedValueProvider)new CachedValueProvider<Collection<GrClassDefinition>>(){

            @NotNull
            public CachedValueProvider.Result<Collection<GrClassDefinition>> compute() {
                CachedValueProvider.Result result = CachedValueProvider.Result.create((Object)GspTagLibUtil.doSearchTaglibsInClassPath(module), (Object[])new Object[]{MvcModuleStructureSynchronizer.getInstance((Project)project).getFileAndRootsModificationTracker()});
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/resolve/taglib/GspTagLibUtil$2", "compute"));
                }
                return result;
            }
        });
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/resolve/taglib/GspTagLibUtil", "searchTaglibsInClassPath"));
        }
        return collection;
    }

    @NotNull
    private static Collection<GrClassDefinition> doSearchTaglibsInClassPath(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/lang/gsp/resolve/taglib/GspTagLibUtil", "doSearchTaglibsInClassPath"));
        }
        Project project = module.getProject();
        GlobalSearchScope scope = module.getModuleRuntimeScope(false);
        final ArrayList taglibNames = ContainerUtil.newArrayList();
        AllClassesSearchExecutor.processClassNames((Project)project, (GlobalSearchScope)scope, (Consumer)new Consumer<String>(){

            public void consume(String fqn) {
                if (fqn.endsWith(GrailsArtifact.TAGLIB.suffix)) {
                    taglibNames.add(fqn);
                }
            }
        });
        PsiShortNamesCache namesCache = PsiShortNamesCache.getInstance((Project)project);
        LinkedHashSet taglibs = ContainerUtil.newLinkedHashSet();
        for (String name : taglibNames) {
            PsiClass[] classes;
            for (PsiClass clazz : classes = namesCache.getClassesByName(name, scope)) {
                PsiElement mirror;
                if (!(clazz instanceof PsiCompiledElement) || !((mirror = clazz.getNavigationElement()) instanceof GrClassDefinition)) continue;
                taglibs.add((GrClassDefinition)mirror);
            }
        }
        LinkedHashSet linkedHashSet = taglibs;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/resolve/taglib/GspTagLibUtil", "doSearchTaglibsInClassPath"));
        }
        return linkedHashSet;
    }

    @Nullable
    public static PsiClass getBuiltInTagByName(@NotNull String name, PsiElement place) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/grails/lang/gsp/resolve/taglib/GspTagLibUtil", "getBuiltInTagByName"));
        }
        String className = TAG_NAME_TO_CLASS_NAME.get(name);
        if (className == null) {
            return null;
        }
        return JavaPsiFacade.getInstance((Project)place.getProject()).findClass(className, place.getResolveScope());
    }

    public static boolean isSdkTagLib(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/grails/lang/gsp/resolve/taglib/GspTagLibUtil", "isSdkTagLib"));
        }
        String name = aClass.getQualifiedName();
        return CLASS_NAME_TO_TAG_NAME.containsKey(name) || DYNAMIC_TAGLIB_PACKAGE.equals(ClassUtil.extractPackageName((String)name));
    }

    @Nullable
    public static String getTagNameByClass(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/plugins/grails/lang/gsp/resolve/taglib/GspTagLibUtil", "getTagNameByClass"));
        }
        return CLASS_NAME_TO_TAG_NAME.get(className);
    }

    @NotNull
    public static String getPrefixByTagLibClass(GrClassDefinition clazz) {
        Object value;
        GrExpression initializer;
        PsiField field = clazz.findFieldByName(NAMESPACE_FIELD, true);
        if (field != null && field.hasModifierProperty("static") && (initializer = ((GrField)field).getInitializerGroovy()) != null && (value = JavaPsiFacade.getInstance((Project)clazz.getProject()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)initializer)) instanceof String) {
            String res = ((String)value).trim();
            String string = res.length() == 0 ? DEFAULT_TAGLIB_PREFIX : res;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/resolve/taglib/GspTagLibUtil", "getPrefixByTagLibClass"));
            }
            return string;
        }
        if (DEFAULT_TAGLIB_PREFIX == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/resolve/taglib/GspTagLibUtil", "getPrefixByTagLibClass"));
        }
        return DEFAULT_TAGLIB_PREFIX;
    }

    public static void processBuiltInTagClasses(PsiElement place, PairProcessor<String, PsiClass> processor) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)place.getProject());
        for (String tagName : TAG_NAME_TO_CLASS_NAME.keySet()) {
            PsiClass builtInClass = facade.findClass(TAG_NAME_TO_CLASS_NAME.get(tagName), place.getResolveScope());
            if (builtInClass == null || processor.process((Object)tagName, (Object)builtInClass)) continue;
            return;
        }
    }

    public static boolean processGrailsTags(PsiScopeProcessor processor, PsiElement ref, ResolveState state, @Nullable String name, @Nullable ElementClassHint classHint) {
        return GspTagLibUtil.processGrailsTags(processor, ref, state, name, classHint, GspTagLibUtil.getTagLibClasses(ref));
    }

    public static boolean processGrailsTags(PsiScopeProcessor processor, PsiElement ref, ResolveState state, @Nullable String name, @Nullable ElementClassHint classHint, Map<String, TagLibNamespaceDescriptor> tagClassMap) {
        TagLibNamespaceDescriptor descriptor;
        if (ResolveUtil.shouldProcessProperties((ElementClassHint)classHint)) {
            PsiVariable variable;
            if (name == null) {
                for (TagLibNamespaceDescriptor descriptor2 : tagClassMap.values()) {
                    PsiVariable variable2 = descriptor2.getDummyClassVariable();
                    if (variable2 == null || processor.execute((PsiElement)variable2, ResolveState.initial())) continue;
                    return false;
                }
            } else if (ref.getParent() instanceof GrReferenceExpression && (descriptor = tagClassMap.get(name)) != null && (variable = descriptor.getDummyClassVariable()) != null && !processor.execute((PsiElement)variable, ResolveState.initial())) {
                return false;
            }
        }
        return !ResolveUtil.shouldProcessMethods((ElementClassHint)classHint) || (descriptor = tagClassMap.get(DEFAULT_TAGLIB_PREFIX)) == null || descriptor.processTags(processor, state, name);
    }

    public static Pair<Map<String, XmlAttributeDescriptor>, Set<String>> getAttributesDescriptorsFromJavadocs(PsiElement place) {
        PsiElement element = place.getNavigationElement().getNavigationElement();
        Pair res = (Pair)ATTR_FROM_SOURCE_KEY.getCachedValue(element);
        if (res == null) {
            PsiDocTag[] attrs;
            PsiDocComment docComment;
            Map<String, XmlAttributeDescriptor> javaDocAttrMap = null;
            if (element instanceof PsiDocCommentOwner && (docComment = ((PsiDocCommentOwner)element).getDocComment()) != null && (attrs = docComment.findTagsByName("attr")).length > 0) {
                javaDocAttrMap = new HashMap();
                for (PsiDocTag attr : attrs) {
                    XmlAttributeDescriptor descriptor = GspTagLibUtil.createDescriptorByDoc(attr);
                    if (descriptor == null) continue;
                    javaDocAttrMap.put(descriptor.getName(), descriptor);
                }
            }
            if (javaDocAttrMap == null) {
                javaDocAttrMap = Collections.emptyMap();
            }
            Set sourceAttrName = null;
            if (element instanceof GrField) {
                for (String attrName : ((GrField)element).getNamedParameters().keySet()) {
                    if (javaDocAttrMap.containsKey(attrName) || "tagName".equals(attrName) || "type".equals(attrName) || "remove".equals(attrName)) continue;
                    if (sourceAttrName == null) {
                        sourceAttrName = new HashSet();
                    }
                    sourceAttrName.add(attrName);
                }
            }
            if (sourceAttrName == null) {
                sourceAttrName = Collections.emptySet();
            }
            res = (Pair)ATTR_FROM_SOURCE_KEY.putCachedValue(element, (Object)Pair.create(javaDocAttrMap, sourceAttrName));
        }
        return res;
    }

    @Nullable
    private static XmlAttributeDescriptor createDescriptorByDoc(PsiDocTag docTag) {
        final PsiDocTagValue valueElement = docTag.getValueElement();
        if (valueElement == null) {
            return null;
        }
        String name = valueElement.getText().trim();
        if (name.isEmpty()) {
            return null;
        }
        PsiElement[] dataElements = docTag.getDataElements();
        final boolean isRequired = dataElements.length > 1 && StringUtil.startsWithIgnoreCase((String)dataElements[1].getText().trim(), (String)"required");
        return new AnyXmlAttributeDescriptor(name){

            public boolean isRequired() {
                return isRequired;
            }

            public PsiElement getDeclaration() {
                return valueElement;
            }
        };
    }

    static {
        TAG_NAME_TO_CLASS_NAME.put("renderInput", "org.codehaus.groovy.grails.web.taglib.RenderInputTag");
        TAG_NAME_TO_CLASS_NAME.put("each", "org.codehaus.groovy.grails.web.taglib.GroovyEachTag");
        TAG_NAME_TO_CLASS_NAME.put("if", "org.codehaus.groovy.grails.web.taglib.GroovyIfTag");
        TAG_NAME_TO_CLASS_NAME.put("unless", "org.codehaus.groovy.grails.web.taglib.GroovyUnlessTag");
        TAG_NAME_TO_CLASS_NAME.put("else", "org.codehaus.groovy.grails.web.taglib.GroovyElseTag");
        TAG_NAME_TO_CLASS_NAME.put("elseif", "org.codehaus.groovy.grails.web.taglib.GroovyElseIfTag");
        TAG_NAME_TO_CLASS_NAME.put("findAll", "org.codehaus.groovy.grails.web.taglib.GroovyFindAllTag");
        TAG_NAME_TO_CLASS_NAME.put("collect", "org.codehaus.groovy.grails.web.taglib.GroovyCollectTag");
        TAG_NAME_TO_CLASS_NAME.put("grep", "org.codehaus.groovy.grails.web.taglib.GroovyGrepTag");
        TAG_NAME_TO_CLASS_NAME.put("while", "org.codehaus.groovy.grails.web.taglib.GroovyWhileTag");
        TAG_NAME_TO_CLASS_NAME.put("def", "org.codehaus.groovy.grails.web.taglib.GroovyDefTag");
        for (Map.Entry<String, String> entry : TAG_NAME_TO_CLASS_NAME.entrySet()) {
            CLASS_NAME_TO_TAG_NAME.put(entry.getValue(), entry.getKey());
        }
        TAGLIB_PREFEXES = new HashMap<String, String>();
        TAGLIB_PREFEXES.put("org.codehaus.groovy.grails.plugins.web.taglib.PluginTagLib", "plugin");
        TAGLIB_PREFEXES.put("org.codehaus.groovy.grails.plugins.web.taglib.SitemeshTagLib", "sitemesh");
    }
}

