/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.pluginSupport.spock;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.compiled.ClsFieldImpl;
import com.intellij.psi.impl.compiled.ClsMethodImpl;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.tests.GrailsTestUtils;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrReferenceTypeEnhancer;

public class GrailsSpockEnhancer
extends GrReferenceTypeEnhancer {
    private static Map<String, String> typeMap;

    public static Map<String, String> getTypeMap() {
        if (typeMap == null) {
            typeMap = GrailsUtils.createMap("getForwardArgs", "java.util.Map", "getRedirectArgs", "java.util.Map", "getChainArgs", "java.util.Map", "webRequest", "org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest", "getMockRequest", "javax.servlet.http.HttpServletRequest", "getMockResponse", "javax.servlet.http.HttpServletResponse", "getMockSession", "javax.servlet.http.HttpSession", "getRenderArgs", "java.util.Map", "getMockParams", "org.codehaus.groovy.grails.web.servlet.mvc.GrailsParameterMap", "getMockFlash", "org.codehaus.groovy.grails.web.servlet.FlashScope");
        }
        return typeMap;
    }

    @Nullable
    private static PsiType getFromMap(String memberName, PsiElement context) {
        String type = GrailsSpockEnhancer.getTypeMap().get(memberName);
        if (type == null) {
            return null;
        }
        return JavaPsiFacade.getElementFactory((Project)context.getProject()).createTypeByFQClassName(type, context.getResolveScope());
    }

    public PsiType getReferenceType(GrReferenceExpression ref, PsiElement resolved) {
        if (!(resolved instanceof ClsFieldImpl || resolved instanceof ClsMethodImpl && ((ClsMethodImpl)resolved).getParameterList().getParametersCount() <= 0)) {
            return null;
        }
        PsiClass containingClass = ((PsiMember)resolved).getContainingClass();
        if (containingClass == null) {
            return null;
        }
        String className = containingClass.getQualifiedName();
        String memberName = ((PsiNamedElement)resolved).getName();
        if ("grails.plugin.spock.ControllerSpec".equals(className)) {
            if ("getControllerClass".equals(memberName)) {
                return GrailsTestUtils.getTestedClassClass(ref);
            }
            if ("getController".equals(memberName)) {
                return GrailsTestUtils.getTestedClass(ref);
            }
            return GrailsSpockEnhancer.getFromMap(memberName, (PsiElement)ref);
        }
        if ("grails.plugin.spock.TagLibSpec".equals(className)) {
            if ("getTagLibClass".equals(memberName)) {
                return GrailsTestUtils.getTestedClassClass(ref);
            }
            if ("getTagLib".equals(memberName)) {
                return GrailsTestUtils.getTestedClass(ref);
            }
            return null;
        }
        if ("grails.plugin.spock.MvcSpec".equals(className)) {
            if ("classUnderTest".equals(memberName)) {
                return GrailsTestUtils.getTestedClassClass(ref);
            }
            if ("instanceUnderTest".equals(memberName)) {
                return GrailsTestUtils.getTestedClass(ref);
            }
            return GrailsSpockEnhancer.getFromMap(memberName, (PsiElement)ref);
        }
        if ("grails.plugin.spock.UnitSpec".equals(className) && "errorsMap".equals(memberName)) {
            return JavaPsiFacade.getElementFactory((Project)containingClass.getProject()).createTypeByFQClassName("java.util.Map", ref.getResolveScope());
        }
        return null;
    }
}

