/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.config.GrailsPluginWebHelpReferenceProvider;
import org.jetbrains.plugins.grails.pluginSupport.resources.GrailsResourcesReferenceProvider;
import org.jetbrains.plugins.grails.pluginSupport.webflow.WebFlowStateNameReferenceProvider;
import org.jetbrains.plugins.grails.references.domain.GormNamedArgumentReferenceProvider;
import org.jetbrains.plugins.grails.references.domain.criteria.CriteriaPropertyReferenceProvider;
import org.jetbrains.plugins.grails.references.domain.detachedCriteria.DetachedCriteriaReferenceProvider;
import org.jetbrains.plugins.grails.references.tagSupport.GspTagSupportGspReferenceProvider;
import org.jetbrains.plugins.grails.references.tagSupport.TagAttributeReferenceProvider;
import org.jetbrains.plugins.grails.spring.GrailsSpringMethodReferenceProvider;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.util.dynamicMembers.DynamicMemberUtils;

public class GrailsMethodNamedArgumentReferenceProvider
extends PsiReferenceProvider {
    public static volatile GrailsMethodNamedArgumentReferenceProvider instance;
    private final Map<Object, Map<String, List<Pair<Contributor.Provider, Condition<PsiMethod>>>>> MAP = new HashMap<Object, Map<String, List<Pair<Contributor.Provider, Condition<PsiMethod>>>>>();

    private GrailsMethodNamedArgumentReferenceProvider() {
    }

    public static GrailsMethodNamedArgumentReferenceProvider getInstance() {
        GrailsMethodNamedArgumentReferenceProvider res = instance;
        if (res == null) {
            res = new GrailsMethodNamedArgumentReferenceProvider();
            new GrailsResourcesReferenceProvider().register(res);
            new GormNamedArgumentReferenceProvider().register(res);
            new DetachedCriteriaReferenceProvider().register(res);
            new CriteriaPropertyReferenceProvider().register(res);
            new GrailsSpringMethodReferenceProvider().register(res);
            new GrailsPluginWebHelpReferenceProvider().register(res);
            Contributor.LightMethodCondition condition = new Contributor.LightMethodCondition("Grails:GSP_TAG");
            for (TagAttributeReferenceProvider provider : GspTagSupportGspReferenceProvider.PROVIDERS) {
                res.register((Object)provider.getAttributeName(), provider, (Condition<PsiMethod>)condition, provider.getTagNames());
            }
            res.register((Object)0, WebFlowStateNameReferenceProvider.class, (Condition<PsiMethod>)new Contributor.ClassNameCondition("org.codehaus.groovy.grails.webflow.engine.builder.TransitionTo"), "to");
            instance = res;
        }
        return res;
    }

    public void register(@NotNull Object attrNameOrParameterIndex, Class<? extends Contributor.Provider> referenceGenerator, Condition<PsiMethod> methodCondition, String ... methods) {
        if (attrNameOrParameterIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrNameOrParameterIndex", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider", "register"));
        }
        this.register(attrNameOrParameterIndex, new ProviderProxy(referenceGenerator), methodCondition, methods);
    }

    public void register(@NotNull Object attrNameOrParameterIndex, Contributor.Provider referenceGenerator, Condition<PsiMethod> methodCondition, String ... methods) {
        if (attrNameOrParameterIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrNameOrParameterIndex", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider", "register"));
        }
        assert (methods == null || methods.length > 0);
        Map<String, List<Pair<Contributor.Provider, Condition<PsiMethod>>>> methodsMap = this.MAP.get(attrNameOrParameterIndex);
        if (methodsMap == null) {
            methodsMap = new HashMap<String, List<Pair<Contributor.Provider, Condition<PsiMethod>>>>();
            this.MAP.put(attrNameOrParameterIndex, methodsMap);
        }
        if (methods == null) {
            List<Pair<Contributor.Provider, Condition<PsiMethod>>> list = methodsMap.get(null);
            if (list == null) {
                list = new ArrayList<Pair<Contributor.Provider, Condition<PsiMethod>>>();
                methodsMap.put(null, list);
            }
            list.add((Pair<Contributor.Provider, Condition<PsiMethod>>)Pair.create((Object)referenceGenerator, methodCondition));
        } else {
            for (String methodName : methods) {
                List<Pair<Contributor.Provider, Condition<PsiMethod>>> list = methodsMap.get(methodName);
                if (list == null) {
                    list = new ArrayList<Pair<Contributor.Provider, Condition<PsiMethod>>>();
                    methodsMap.put(methodName, list);
                }
                list.add((Pair<Contributor.Provider, Condition<PsiMethod>>)Pair.create((Object)referenceGenerator, methodCondition));
            }
        }
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        GrCall call;
        Object attrNameOrParameterIndex;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider", "getReferencesByElement"));
        }
        GrExpression argument = (GrExpression)element;
        PsiElement parent = element.getParent();
        if (parent instanceof GrConditionalExpression) {
            if (((GrConditionalExpression)parent).getCondition() == parent) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
            argument = (GrConditionalExpression)parent;
            parent = parent.getParent();
        }
        if (parent instanceof GrListOrMap && !((GrListOrMap)parent).isMap()) {
            argument = (GrListOrMap)parent;
            parent = parent.getParent();
        }
        GrNamedArgument namedArgument = null;
        if (parent instanceof GrNamedArgument) {
            namedArgument = (GrNamedArgument)parent;
            attrNameOrParameterIndex = namedArgument.getLabelName();
            if (attrNameOrParameterIndex == null) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
            call = PsiUtil.getCallByNamedParameter((GrNamedArgument)namedArgument);
        } else if (parent instanceof GrArgumentList) {
            GrArgumentList argumentList = (GrArgumentList)parent;
            attrNameOrParameterIndex = argumentList.getExpressionArgumentIndex(argument);
            call = argumentList.getParent();
        } else {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (!(call instanceof GrMethodCall)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] res = this.createReferencesInternal(element, attrNameOrParameterIndex, (GrMethodCall)call, namedArgument);
        if (res.length == 0 && attrNameOrParameterIndex instanceof Integer) {
            res = this.createReferencesInternal(element, -1, (GrMethodCall)call, null);
        }
        if (res == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider", "getReferencesByElement"));
        }
        return res;
    }

    @NotNull
    private PsiReference[] createReferencesInternal(@NotNull PsiElement element, @NotNull Object attrNameOrParameterIndex, @NotNull GrMethodCall methodCall, GrNamedArgument namedArgument) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider", "createReferencesInternal"));
        }
        if (attrNameOrParameterIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrNameOrParameterIndex", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider", "createReferencesInternal"));
        }
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider", "createReferencesInternal"));
        }
        Map<String, List<Pair<Contributor.Provider, Condition<PsiMethod>>>> methodMap = this.MAP.get(attrNameOrParameterIndex);
        if (methodMap == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider", "createReferencesInternal"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        GrExpression invokedExpression = methodCall.getInvokedExpression();
        if (!(invokedExpression instanceof GrReferenceExpression)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider", "createReferencesInternal"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String methodName = ((GrReferenceExpression)invokedExpression).getReferenceName();
        if (methodName == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider", "createReferencesInternal"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        for (String key : new String[]{methodName, null}) {
            List<Pair<Contributor.Provider, Condition<PsiMethod>>> list = methodMap.get(key);
            if (list == null) continue;
            for (GroovyResolveResult result : ((GrReferenceExpression)invokedExpression).multiResolve(false)) {
                PsiElement eMethod = result.getElement();
                if (!(eMethod instanceof PsiMethod)) continue;
                PsiMethod method = (PsiMethod)eMethod;
                if (key != null && !key.equals(method.getName())) continue;
                for (Pair<Contributor.Provider, Condition<PsiMethod>> pair : list) {
                    PsiReference[] res;
                    if (!((Condition)pair.second).value((Object)method)) continue;
                    if (attrNameOrParameterIndex instanceof Integer) {
                        res = ((Contributor.Provider)pair.first).createRef(element, methodCall, (Integer)attrNameOrParameterIndex, result);
                    } else {
                        assert (namedArgument != null);
                        res = ((Contributor.Provider)pair.first).createRef(element, namedArgument, result);
                    }
                    if (res.length <= 0) continue;
                    if (res == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider", "createReferencesInternal"));
                    }
                    return res;
                }
            }
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider", "createReferencesInternal"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public static interface Contributor {
        public void register(GrailsMethodNamedArgumentReferenceProvider var1);

        public static class ClassSourceCondition
        implements Condition<PsiMethod> {
            private final String myClassSource;

            public ClassSourceCondition(String classSource) {
                this.myClassSource = classSource;
            }

            public boolean value(PsiMethod method) {
                return DynamicMemberUtils.isDynamicElement((PsiElement)method, (String)this.myClassSource);
            }
        }

        public static class ClassNameWithSuperCondition
        implements Condition<PsiMethod> {
            private final String myClassName;

            private ClassNameWithSuperCondition(String className) {
                this.myClassName = className;
            }

            public boolean value(PsiMethod method) {
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null) {
                    return false;
                }
                return GroovyPsiManager.isInheritorCached((PsiClass)containingClass, (String)this.myClassName);
            }
        }

        public static class LightMethodCondition
        implements Condition<PsiMethod> {
            private final Object myKey;

            public LightMethodCondition(@NotNull Object key) {
                if (key == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider$Contributor$LightMethodCondition", "<init>"));
                }
                this.myKey = key;
            }

            public boolean value(PsiMethod method) {
                return GrLightMethodBuilder.checkKind((PsiElement)method, (Object)this.myKey);
            }
        }

        public static class ClassNameCondition
        implements Condition<PsiMethod> {
            private final String myClassName;

            public ClassNameCondition(@NotNull String className) {
                if (className == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider$Contributor$ClassNameCondition", "<init>"));
                }
                this.myClassName = className;
            }

            public boolean value(PsiMethod method) {
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null) {
                    return false;
                }
                return this.myClassName.equals(containingClass.getQualifiedName());
            }
        }

        public static class ProviderAdapter
        extends Provider {
            private static final ProcessingContext CONTEXT = new ProcessingContext();
            private final PsiReferenceProvider myProvider;

            public ProviderAdapter(@NotNull PsiReferenceProvider provider) {
                if (provider == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider$Contributor$ProviderAdapter", "<init>"));
                }
                this.myProvider = provider;
            }

            @Override
            protected PsiReference[] createRef(@NotNull PsiElement element, @NotNull GroovyResolveResult resolveResult) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider$Contributor$ProviderAdapter", "createRef"));
                }
                if (resolveResult == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider$Contributor$ProviderAdapter", "createRef"));
                }
                return this.myProvider.getReferencesByElement(element, CONTEXT);
            }
        }

        public static abstract class Provider {
            protected PsiReference[] createRef(@NotNull PsiElement element, @NotNull GroovyResolveResult resolveResult) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider$Contributor$Provider", "createRef"));
                }
                if (resolveResult == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider$Contributor$Provider", "createRef"));
                }
                throw new UnsupportedOperationException();
            }

            public PsiReference[] createRef(@NotNull PsiElement element, @NotNull GrNamedArgument namedArgument, @NotNull GroovyResolveResult resolveResult) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider$Contributor$Provider", "createRef"));
                }
                if (namedArgument == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedArgument", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider$Contributor$Provider", "createRef"));
                }
                if (resolveResult == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider$Contributor$Provider", "createRef"));
                }
                return this.createRef(element, resolveResult);
            }

            public PsiReference[] createRef(@NotNull PsiElement element, @NotNull GrMethodCall methodCall, int argumentIndex, @NotNull GroovyResolveResult resolveResult) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider$Contributor$Provider", "createRef"));
                }
                if (methodCall == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider$Contributor$Provider", "createRef"));
                }
                if (resolveResult == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider$Contributor$Provider", "createRef"));
                }
                return this.createRef(element, resolveResult);
            }
        }
    }

    private static class ProviderProxy
    extends Contributor.Provider {
        private final Class<? extends Contributor.Provider> myClass;
        private Contributor.Provider myInstance;

        private ProviderProxy(Class<? extends Contributor.Provider> aClass) {
            this.myClass = aClass;
        }

        private void ensureInit() {
            if (this.myInstance == null) {
                try {
                    this.myInstance = this.myClass.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public PsiReference[] createRef(@NotNull PsiElement element, @NotNull GrNamedArgument namedArgument, @NotNull GroovyResolveResult resolveResult) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider$ProviderProxy", "createRef"));
            }
            if (namedArgument == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedArgument", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider$ProviderProxy", "createRef"));
            }
            if (resolveResult == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider$ProviderProxy", "createRef"));
            }
            this.ensureInit();
            return this.myInstance.createRef(element, namedArgument, resolveResult);
        }

        @Override
        public PsiReference[] createRef(@NotNull PsiElement element, @NotNull GrMethodCall methodCall, int parameterIndex, @NotNull GroovyResolveResult resolveResult) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider$ProviderProxy", "createRef"));
            }
            if (methodCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider$ProviderProxy", "createRef"));
            }
            if (resolveResult == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "org/jetbrains/plugins/grails/references/GrailsMethodNamedArgumentReferenceProvider$ProviderProxy", "createRef"));
            }
            this.ensureInit();
            return this.myInstance.createRef(element, methodCall, parameterIndex, resolveResult);
        }
    }
}

