/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.domain;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.references.domain.DomainDescriptor;
import org.jetbrains.plugins.grails.references.domain.GormUtils;
import org.jetbrains.plugins.grails.references.util.PsiFieldReference;
import org.jetbrains.plugins.groovy.lang.completion.CompleteReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;

public class GormPropertyConstraintReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/domain/GormPropertyConstraintReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/grails/references/domain/GormPropertyConstraintReferenceProvider", "getReferencesByElement"));
        }
        final GrArgumentList argumentList = (GrArgumentList)element.getParent();
        GrIndexProperty index = (GrIndexProperty)argumentList.getParent();
        GrExpression expression = index.getInvokedExpression();
        if (!(expression instanceof GrReferenceExpression)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/domain/GormPropertyConstraintReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        GrReferenceExpression ref = (GrReferenceExpression)expression;
        if (!"properties".equals(ref.getReferenceName())) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/domain/GormPropertyConstraintReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        final GrExpression qualifier = ref.getQualifierExpression();
        if (qualifier == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/domain/GormPropertyConstraintReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new PsiFieldReference(element, false){

            @Nullable
            private Map<String, Pair<PsiType, PsiElement>> getPropertyMap() {
                PsiClass domainClass = PsiTypesUtil.getPsiClass((PsiType)qualifier.getType());
                if (!GormUtils.isGormBean(domainClass)) {
                    return null;
                }
                assert (domainClass != null);
                return DomainDescriptor.getDescriptor(domainClass).getPersistentProperties();
            }

            public PsiElement resolve() {
                Map<String, Pair<PsiType, PsiElement>> map = this.getPropertyMap();
                if (map == null) {
                    return null;
                }
                Pair<PsiType, PsiElement> pair = map.get(this.getValue());
                if (pair == null) {
                    return null;
                }
                return (PsiElement)pair.second;
            }

            @NotNull
            public Object[] getVariants() {
                Map<String, Pair<PsiType, PsiElement>> map = this.getPropertyMap();
                if (map == null) {
                    if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/domain/GormPropertyConstraintReferenceProvider$1", "getVariants"));
                    }
                    return ArrayUtil.EMPTY_OBJECT_ARRAY;
                }
                HashSet<String> existingFields = new HashSet<String>();
                for (GrExpression expression : argumentList.getExpressionArguments()) {
                    Object value;
                    if (!(expression instanceof GrLiteralImpl) || expression == this.getElement() || !((value = ((GrLiteralImpl)expression).getValue()) instanceof String)) continue;
                    existingFields.add((String)value);
                }
                ArrayList<LookupElementBuilder> res = new ArrayList<LookupElementBuilder>();
                for (Map.Entry<String, Pair<PsiType, PsiElement>> entry : map.entrySet()) {
                    String name = entry.getKey();
                    if (existingFields.contains(name)) continue;
                    res.add(CompleteReferenceExpression.createPropertyLookupElement((String)name, (PsiType)((PsiType)entry.getValue().first)));
                }
                Object[] objectArray = res.toArray();
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/domain/GormPropertyConstraintReferenceProvider$1", "getVariants"));
                }
                return objectArray;
            }
        }};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/domain/GormPropertyConstraintReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }
}

