/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.runner;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.notification.NotificationType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutor;
import org.jetbrains.plugins.grails.runner.GrailsCommandLineExecutor;
import org.jetbrains.plugins.grails.runner.GrailsConsole;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.groovy.mvc.ConsoleProcessDescriptor;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;

public final class GrailsCommandExecutorUtil {
    @Nullable
    public static ConsoleProcessDescriptor execute(@NotNull GrailsApplication application, @NotNull MvcCommand command, @Nullable Runnable onDone, boolean close, String ... input) {
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/grails/runner/GrailsCommandExecutorUtil", "execute"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/grails/runner/GrailsCommandExecutorUtil", "execute"));
        }
        try {
            GrailsCommandExecutor executor = GrailsCommandExecutor.getGrailsExecutor(application);
            if (executor == null) {
                return null;
            }
            return executor.execute(application, command, onDone, close, input);
        }
        catch (ExecutionException e) {
            GrailsConsole.getInstance(application.getProject());
            GrailsConsole.NOTIFICATION_GROUP.createNotification(e.getMessage(), NotificationType.ERROR);
            return null;
        }
    }

    @NotNull
    public static GeneralCommandLine createCommandLine(@NotNull GrailsApplication application, @NotNull MvcCommand command) throws ExecutionException {
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/grails/runner/GrailsCommandExecutorUtil", "createCommandLine"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/grails/runner/GrailsCommandExecutorUtil", "createCommandLine"));
        }
        GrailsCommandExecutor executor = GrailsCommandExecutor.getGrailsExecutor(application);
        if (executor instanceof GrailsCommandLineExecutor) {
            GeneralCommandLine generalCommandLine = ((GrailsCommandLineExecutor)executor).createCommandLine(application, command);
            if (generalCommandLine == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/GrailsCommandExecutorUtil", "createCommandLine"));
            }
            return generalCommandLine;
        }
        throw new ExecutionException("Cannot execute " + command + " in " + application.getRoot());
    }
}

