/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.runner.impl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.application.BaseJavaApplicationCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutor;
import org.jetbrains.plugins.grails.runner.GrailsCommandLineExecutor;
import org.jetbrains.plugins.grails.runner.GrailsRunConfiguration;
import org.jetbrains.plugins.grails.runner.GrailsRunConfigurationExtension;
import org.jetbrains.plugins.grails.runner.util.GrailsExecutionUtils;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.util.version.Version;

public class GrailsCommandLineState
extends BaseJavaApplicationCommandLineState<GrailsRunConfiguration> {
    @NotNull
    protected final GrailsApplication myApplication;
    @NotNull
    protected final GrailsCommandLineExecutor myExecutor;

    public GrailsCommandLineState(@NotNull ExecutionEnvironment environment, @NotNull GrailsRunConfiguration configuration, @NotNull GrailsCommandLineExecutor executor) throws ExecutionException {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/plugins/grails/runner/impl/GrailsCommandLineState", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/plugins/grails/runner/impl/GrailsCommandLineState", "<init>"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/plugins/grails/runner/impl/GrailsCommandLineState", "<init>"));
        }
        super(environment, (RunConfigurationBase)configuration);
        this.myApplication = configuration.getGrailsApplication();
        this.myExecutor = executor;
    }

    @NotNull
    public GrailsApplication getApplication() {
        GrailsApplication grailsApplication = this.myApplication;
        if (grailsApplication == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/impl/GrailsCommandLineState", "getApplication"));
        }
        return grailsApplication;
    }

    @NotNull
    public GrailsCommandExecutor getExecutor() {
        GrailsCommandLineExecutor grailsCommandLineExecutor = this.myExecutor;
        if (grailsCommandLineExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/impl/GrailsCommandLineState", "getExecutor"));
        }
        return grailsCommandLineExecutor;
    }

    protected void setupJavaParameters(JavaParameters params) throws ExecutionException {
        for (RunConfigurationExtension ext : (RunConfigurationExtension[])RunConfigurationExtension.EP_NAME.getExtensions()) {
            ext.updateJavaParameters((RunConfigurationBase)this.getConfiguration(), params, this.getRunnerSettings());
        }
    }

    @NotNull
    protected JavaParameters createJavaParameters() throws ExecutionException {
        JavaParameters parameters = this.doCreateJavaParameters();
        parameters.setWorkingDirectory(VfsUtilCore.virtualToIoFile((VirtualFile)this.myApplication.getRoot()));
        if (parameters.getJdk() == null) {
            Sdk sdk = ProjectRootManager.getInstance((Project)((GrailsRunConfiguration)this.myConfiguration).getProject()).getProjectSdk();
            parameters.setJdk(sdk);
        }
        if (DefaultDebugExecutor.getDebugExecutorInstance().equals(this.getEnvironment().getExecutor())) {
            Version version = this.getApplication().getVersion();
            if (version.compareTo(Version.GRAILS_1_3_4) >= 0 && !parameters.getEnv().containsKey("GROOVY_PAGE_ADD_LINE_NUMBERS")) {
                parameters.getEnv().put("GROOVY_PAGE_ADD_LINE_NUMBERS", "true");
            }
            if (version.compareTo(Version.GRAILS_2_0) >= 0 && !parameters.getVMParametersList().hasProperty("grails.full.stacktrace")) {
                parameters.getVMParametersList().addProperty("grails.full.stacktrace", "true");
            }
        }
        String runnerId = this.getEnvironment().getRunner().getRunnerId();
        this.setupJavaParameters(parameters);
        JavaParameters javaParameters = parameters;
        if (javaParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/impl/GrailsCommandLineState", "createJavaParameters"));
        }
        return javaParameters;
    }

    @NotNull
    protected JavaParameters doCreateJavaParameters() throws ExecutionException {
        if (this.myExecutor instanceof GrailsRunConfigurationExtension) {
            GrailsRunConfigurationExtension runConfigurationExtensionExecutor = (GrailsRunConfigurationExtension)((Object)this.myExecutor);
            Key key = runConfigurationExtensionExecutor.getKey();
            JavaParameters javaParameters = runConfigurationExtensionExecutor.createJavaParameters(((GrailsRunConfiguration)this.myConfiguration).getGrailsApplication(), ((GrailsRunConfiguration)this.myConfiguration).getGrailsCommand(), ((GrailsRunConfiguration)this.myConfiguration).getUserData(key));
            if (javaParameters == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/impl/GrailsCommandLineState", "doCreateJavaParameters"));
            }
            return javaParameters;
        }
        JavaParameters javaParameters = this.myExecutor.createJavaParameters(((GrailsRunConfiguration)this.myConfiguration).getGrailsApplication(), ((GrailsRunConfiguration)this.myConfiguration).getGrailsCommand());
        if (javaParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/impl/GrailsCommandLineState", "doCreateJavaParameters"));
        }
        return javaParameters;
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        ProcessHandler handler;
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/plugins/grails/runner/impl/GrailsCommandLineState", "execute"));
        }
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "org/jetbrains/plugins/grails/runner/impl/GrailsCommandLineState", "execute"));
        }
        ExecutionResult result = super.execute(executor, runner);
        if (((GrailsRunConfiguration)this.myConfiguration).isLaunchBrowser() && (handler = result.getProcessHandler()) != null) {
            handler.addProcessListener((ProcessListener)GrailsExecutionUtils.getBrowserLaunchListener(handler));
        }
        ExecutionResult executionResult = result;
        if (executionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/impl/GrailsCommandLineState", "execute"));
        }
        return executionResult;
    }

    @NotNull
    protected GrailsCommandExecutor getExecutor(GrailsApplication grailsApplication) throws ExecutionException {
        GrailsCommandExecutor grailsExecutor = GrailsCommandExecutor.getGrailsExecutor(grailsApplication);
        if (grailsExecutor == null) {
            throw new ExecutionException("Cannot execute grails application: " + grailsApplication.getRoot().getPath());
        }
        GrailsCommandExecutor grailsCommandExecutor = grailsExecutor;
        if (grailsCommandExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/impl/GrailsCommandLineState", "getExecutor"));
        }
        return grailsCommandExecutor;
    }

    @NotNull
    protected String getProgramParameters() throws ExecutionException {
        String programParameters = ((GrailsRunConfiguration)this.myConfiguration).getProgramParameters();
        if (programParameters == null) {
            throw new ExecutionException("Grails command is not selected");
        }
        String string = programParameters;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/impl/GrailsCommandLineState", "getProgramParameters"));
        }
        return string;
    }

    protected String getVMParameters() {
        return ((GrailsRunConfiguration)this.myConfiguration).getVMParameters();
    }

    public GrailsRunConfiguration getConfiguration() {
        return (GrailsRunConfiguration)super.getConfiguration();
    }
}

