/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.runner.impl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.groovy.grails.rt.GrailsRtMarker;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.runner.GrailsCommandLineExecutor;
import org.jetbrains.plugins.grails.runner.GrailsInstallationExecutor;
import org.jetbrains.plugins.grails.runner.GrailsRunConfiguration;
import org.jetbrains.plugins.grails.runner.GrailsRunConfigurationExtension;
import org.jetbrains.plugins.grails.runner.ui.GrailsRunConfigurationEditor;
import org.jetbrains.plugins.grails.runner.ui.GrailsRunConfigurationEditorWithListener;
import org.jetbrains.plugins.grails.runner.util.GrailsExecutionUtils;
import org.jetbrains.plugins.grails.sdk.GrailsSDK;
import org.jetbrains.plugins.grails.sdk.GrailsSDKManager;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.OldGrailsApplication;
import org.jetbrains.plugins.grails.structure.impl.Grails2Application;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.grails.util.version.Version;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;
import org.jetbrains.plugins.groovy.util.GroovyUtils;

public class GrailsInstallationCommandExecutor
extends GrailsCommandLineExecutor
implements GrailsRunConfigurationExtension<Boolean>,
GrailsInstallationExecutor {
    private static final Key<Boolean> DATA_KEY = Key.create((String)(GrailsInstallationCommandExecutor.class.getName() + " data key"));
    private static final String DEPS_CLASSPATH = "depsClasspath";

    @Override
    public boolean isApplicable(@NotNull GrailsApplication grailsApplication) {
        if (grailsApplication == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grailsApplication", "org/jetbrains/plugins/grails/runner/impl/GrailsInstallationCommandExecutor", "isApplicable"));
        }
        return grailsApplication instanceof OldGrailsApplication && GrailsSDKManager.getGrailsSdk(grailsApplication) != null;
    }

    @Override
    public boolean isApplicable(@NotNull GrailsSDK grailsSdk) {
        if (grailsSdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grailsSdk", "org/jetbrains/plugins/grails/runner/impl/GrailsInstallationCommandExecutor", "isApplicable"));
        }
        return grailsSdk.getVersion().isLessThan(Version.GRAILS_3_0);
    }

    @Override
    @NotNull
    public JavaParameters createJavaParameters(@NotNull GrailsApplication grailsApplication, @NotNull MvcCommand command) throws ExecutionException {
        if (grailsApplication == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grailsApplication", "org/jetbrains/plugins/grails/runner/impl/GrailsInstallationCommandExecutor", "createJavaParameters"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/grails/runner/impl/GrailsInstallationCommandExecutor", "createJavaParameters"));
        }
        JavaParameters javaParameters = this.createJavaParameters((OldGrailsApplication)grailsApplication, command, false);
        if (javaParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/impl/GrailsInstallationCommandExecutor", "createJavaParameters"));
        }
        return javaParameters;
    }

    @Override
    public void addListener(@NotNull JavaParameters params, @NotNull String listener) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "org/jetbrains/plugins/grails/runner/impl/GrailsInstallationCommandExecutor", "addListener"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/plugins/grails/runner/impl/GrailsInstallationCommandExecutor", "addListener"));
        }
        super.addListener(params, listener);
        String listenerJar = PathUtil.getJarPathForClass(GrailsRtMarker.class);
        List programParams = params.getProgramParametersList().getList();
        int cpIndex = programParams.indexOf("--classpath");
        if (cpIndex != -1 && cpIndex < programParams.size() - 1) {
            PathsList pathsList = new PathsList();
            pathsList.add((String)programParams.get(cpIndex + 1));
            pathsList.add(listenerJar);
            params.getProgramParametersList().replaceOrAppend((String)programParams.get(cpIndex + 1), pathsList.getPathsString());
        } else {
            params.getProgramParametersList().addAt(0, "--classpath");
            params.getProgramParametersList().addAt(1, listenerJar);
        }
    }

    @Override
    @NotNull
    public Key<Boolean> getKey() {
        Key<Boolean> key = DATA_KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/impl/GrailsInstallationCommandExecutor", "getKey"));
        }
        return key;
    }

    @Override
    @NotNull
    public JavaParameters createJavaParameters(@NotNull GrailsApplication grailsApplication, @NotNull MvcCommand command, @Nullable Boolean depsClassPath) throws ExecutionException {
        if (grailsApplication == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grailsApplication", "org/jetbrains/plugins/grails/runner/impl/GrailsInstallationCommandExecutor", "createJavaParameters"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/grails/runner/impl/GrailsInstallationCommandExecutor", "createJavaParameters"));
        }
        if (grailsApplication instanceof OldGrailsApplication) {
            JavaParameters javaParameters = this.createJavaParameters((OldGrailsApplication)grailsApplication, command, depsClassPath != null && depsClassPath != false);
            if (javaParameters == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/impl/GrailsInstallationCommandExecutor", "createJavaParameters"));
            }
            return javaParameters;
        }
        throw new ExecutionException("Should not get here");
    }

    @Override
    @Nullable
    public SettingsEditor<GrailsRunConfiguration> createExtensionEditor() {
        return new GrailsRunConfigurationEditorWithListener(){
            private JCheckBox myDepsClassPath = new JCheckBox();

            protected void resetEditorFrom(GrailsRunConfiguration s) {
                Boolean depsClassPath = (Boolean)s.getUserData(GrailsInstallationCommandExecutor.this.getKey());
                GrailsRunConfigurationEditor.setCBEnabled(depsClassPath != null && depsClassPath != false, this.myDepsClassPath);
            }

            protected void applyEditorTo(GrailsRunConfiguration s) throws ConfigurationException {
                s.putUserData(GrailsInstallationCommandExecutor.this.getKey(), this.myDepsClassPath.isEnabled() && this.myDepsClassPath.isSelected());
            }

            @NotNull
            protected JComponent createEditor() {
                JCheckBox jCheckBox = this.myDepsClassPath;
                if (jCheckBox == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/impl/GrailsInstallationCommandExecutor$1", "createEditor"));
                }
                return jCheckBox;
            }

            @Override
            public void applicationChanged(GrailsApplication application) {
                if (application instanceof Grails2Application) {
                    Module module = ((Grails2Application)application).getModule();
                    String depsClasspath = GrailsFramework.getInstance().getApplicationClassPath(module).getPathsString();
                    boolean hasClasspath = StringUtil.isNotEmpty((String)depsClasspath);
                    String presentable = "Add --classpath";
                    if (hasClasspath) {
                        presentable = presentable + ": " + (depsClasspath.length() > 70 ? depsClasspath.substring(0, 70) + "..." : depsClasspath);
                    }
                    this.myDepsClassPath.setText(presentable);
                    this.myDepsClassPath.setToolTipText("<html>&nbsp;" + StringUtil.replace((String)depsClasspath, (String)File.pathSeparator, (String)"<br>&nbsp;") + "</html>");
                    GrailsRunConfigurationEditor.setCBEnabled(hasClasspath, this.myDepsClassPath);
                    this.myDepsClassPath.setVisible(true);
                } else {
                    GrailsRunConfigurationEditor.setCBEnabled(false, this.myDepsClassPath);
                    this.myDepsClassPath.setVisible(false);
                }
            }
        };
    }

    @Override
    @Nullable
    public Boolean readAdditionalConfiguration(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/runner/impl/GrailsInstallationCommandExecutor", "readAdditionalConfiguration"));
        }
        return Boolean.parseBoolean(JDOMExternalizer.readString((Element)element, (String)DEPS_CLASSPATH));
    }

    @Override
    public void writeAdditionalConfiguration(@NotNull Boolean depsClassPath, @NotNull Element element) {
        if (depsClassPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "depsClassPath", "org/jetbrains/plugins/grails/runner/impl/GrailsInstallationCommandExecutor", "writeAdditionalConfiguration"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/runner/impl/GrailsInstallationCommandExecutor", "writeAdditionalConfiguration"));
        }
        JDOMExternalizer.write((Element)element, (String)DEPS_CLASSPATH, (boolean)depsClassPath);
    }

    public JavaParameters createJavaParameters(@NotNull OldGrailsApplication grailsApplication, @NotNull MvcCommand command, boolean classPathFromDependencies) throws ExecutionException {
        if (grailsApplication == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grailsApplication", "org/jetbrains/plugins/grails/runner/impl/GrailsInstallationCommandExecutor", "createJavaParameters"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/grails/runner/impl/GrailsInstallationCommandExecutor", "createJavaParameters"));
        }
        GrailsSDK grailsSdk = GrailsSDKManager.getGrailsSdk(grailsApplication);
        if (grailsSdk == null) {
            throw new ExecutionException("Grails SDK not found");
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)grailsApplication.getModule()).getSdk();
        if (sdk == null) {
            throw new ExecutionException("JDK is not configured");
        }
        JavaParameters params = this.createJavaParameters(sdk, grailsSdk, command);
        VirtualFile rootFile = grailsApplication.getRoot();
        String workDir = VfsUtilCore.virtualToIoFile((VirtualFile)rootFile).getAbsolutePath();
        params.getVMParametersList().addProperty("base.dir", workDir);
        params.setWorkingDirectory(workDir);
        params.setDefaultCharset(grailsApplication.getProject());
        if (classPathFromDependencies) {
            GrailsInstallationCommandExecutor.addToClassPath(params, GrailsFramework.getInstance().getApplicationClassPath(grailsApplication.getModule()).getVirtualFiles());
        }
        return params;
    }

    @Override
    @NotNull
    public JavaParameters createJavaParameters(@NotNull Sdk sdk, @NotNull GrailsSDK grailsSdk, @NotNull MvcCommand command) throws ExecutionException {
        File springLoadedJar;
        String grailsOpts;
        String pathStr;
        File bootStrapJar;
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/plugins/grails/runner/impl/GrailsInstallationCommandExecutor", "createJavaParameters"));
        }
        if (grailsSdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grailsSdk", "org/jetbrains/plugins/grails/runner/impl/GrailsInstallationCommandExecutor", "createJavaParameters"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/grails/runner/impl/GrailsInstallationCommandExecutor", "createJavaParameters"));
        }
        JavaParameters params = new JavaParameters();
        String grailsSdkHomePath = grailsSdk.getPath();
        params.setJdk(sdk);
        params.setupEnvs(command.getEnvVariables(), command.isPassParentEnvs());
        params.addEnv("GRAILS_HOME", FileUtil.toSystemDependentName((String)grailsSdkHomePath));
        MvcFramework.addJavaHome((Sdk)sdk, (JavaParameters)params);
        File groovyJar = GrailsInstallationCommandExecutor.findGroovyJar(grailsSdkHomePath);
        if (groovyJar != null) {
            params.getClassPath().add(groovyJar.getAbsolutePath());
        }
        if ((bootStrapJar = GrailsInstallationCommandExecutor.findBootStrapJar(grailsSdkHomePath)) != null) {
            params.getClassPath().add(bootStrapJar.getAbsolutePath());
        }
        params.setMainClass("org.codehaus.groovy.grails.cli.support.GrailsStarter");
        params.getVMParametersList().addProperty("grails.home", grailsSdkHomePath);
        SdkTypeId sdkType = sdk.getSdkType();
        if (sdkType instanceof JavaSdkType) {
            params.getVMParametersList().addProperty("tools.jar", ((JavaSdkType)sdkType).getToolsPath(sdk));
        }
        String confPath = grailsSdkHomePath + "/conf/groovy-starter.conf";
        params.getVMParametersList().addProperty("groovy.starter.conf", confPath);
        params.getProgramParametersList().add("--main");
        params.getProgramParametersList().add("org.codehaus.groovy.grails.cli.GrailsScriptRunner");
        params.getProgramParametersList().add("--conf");
        params.getProgramParametersList().add(confPath);
        Version version = grailsSdk.getVersion();
        PathsList cp = new PathsList();
        if (version.compareTo(Version.GRAILS_1_1) < 0) {
            cp.add(".");
        }
        if ((pathStr = cp.getPathsString()).length() > 0) {
            params.getProgramParametersList().add("--classpath");
            params.getProgramParametersList().add(pathStr);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(grailsOpts = System.getenv("GRAILS_OPTS")))) {
            params.getVMParametersList().addParametersString(grailsOpts);
        }
        params.getVMParametersList().addParametersString(command.getVmOptions());
        String parametersString = params.getVMParametersList().getParametersString();
        if (!JavaSdk.getInstance().isOfVersionOrHigher(sdk, JavaSdkVersion.JDK_1_8)) {
            if (version.compareTo(Version.GRAILS_2_0) >= 0) {
                if (GrailsInstallationCommandExecutor.addMemoryConstraintIfNotExists(parametersString, params, "-Xmx", "768M")) {
                    GrailsInstallationCommandExecutor.addMemoryConstraintIfNotExists(parametersString, params, "-Xms", "768M");
                }
                if (GrailsInstallationCommandExecutor.addMemoryConstraintIfNotExists(parametersString, params, "-XX:MaxPermSize=", "256m")) {
                    GrailsInstallationCommandExecutor.addMemoryConstraintIfNotExists(parametersString, params, "-XX:PermSize=", "256m");
                }
            } else {
                GrailsInstallationCommandExecutor.addMemoryConstraintIfNotExists(parametersString, params, "-Xmx", "512M");
                GrailsInstallationCommandExecutor.addMemoryConstraintIfNotExists(parametersString, params, "-XX:MaxPermSize=", "192m");
            }
        }
        GrailsExecutionUtils.addCommonJvmOptions(params);
        ParametersList grailsCommand = new ParametersList();
        command.addToParametersList(grailsCommand);
        if (!grailsCommand.hasParameter("-plain-output") && version.compareTo(Version.GRAILS_2_0) >= 0) {
            grailsCommand.add("-plain-output");
        }
        params.getProgramParametersList().add(grailsCommand.getParametersString());
        if (GrailsInstallationCommandExecutor.enableReloader(grailsCommand) && (springLoadedJar = GrailsInstallationCommandExecutor.findSpringLoadedJar(grailsSdkHomePath)) != null) {
            params.getVMParametersList().add("-javaagent:" + springLoadedJar.getAbsolutePath());
            params.getVMParametersList().add("-noverify");
            if (!params.getVMParametersList().hasProperty("springloaded")) {
                params.getVMParametersList().addProperty("springloaded", "profile=grails;cacheDir=.");
            }
        }
        JavaParameters javaParameters = params;
        if (javaParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/impl/GrailsInstallationCommandExecutor", "createJavaParameters"));
        }
        return javaParameters;
    }

    private static boolean addMemoryConstraintIfNotExists(String existedParams, JavaParameters javaParameters, String paramName, String value) {
        if (!existedParams.contains(paramName)) {
            javaParameters.getVMParametersList().add(paramName + value);
            return true;
        }
        return false;
    }

    private static boolean enableReloader(@NotNull ParametersList grailsCommand) {
        if (grailsCommand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grailsCommand", "org/jetbrains/plugins/grails/runner/impl/GrailsInstallationCommandExecutor", "enableReloader"));
        }
        return grailsCommand.hasParameter("-reloading") || grailsCommand.hasParameter("run-app") && !grailsCommand.hasParameter("-noreloading");
    }

    @Nullable
    private static File findGroovyJar(@NotNull String grailsSdkHomePath) {
        if (grailsSdkHomePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grailsSdkHomePath", "org/jetbrains/plugins/grails/runner/impl/GrailsInstallationCommandExecutor", "findGroovyJar"));
        }
        File groovyJar = GrailsUtils.findLatestJarInIvyRepository(grailsSdkHomePath + "/lib/org.codehaus.groovy/groovy-all", "groovy-all-");
        if (groovyJar != null) {
            return groovyJar;
        }
        File[] files = GroovyUtils.getFilesInDirectoryByPattern((String)(grailsSdkHomePath + "/lib"), (String)"groovy-all-\\d[^-]*\\.jar");
        if (files.length > 0) {
            groovyJar = files[0];
        }
        return groovyJar;
    }

    @Nullable
    private static File findBootStrapJar(@NotNull String grailsSdkHomePath) {
        if (grailsSdkHomePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grailsSdkHomePath", "org/jetbrains/plugins/grails/runner/impl/GrailsInstallationCommandExecutor", "findBootStrapJar"));
        }
        File[] bootstrapFiles = GroovyUtils.getFilesInDirectoryByPattern((String)(grailsSdkHomePath + "/dist/"), (String)"grails-bootstrap-\\d[^-]*(?:-SNAPSHOT)?\\.jar");
        if (bootstrapFiles.length > 0) {
            return bootstrapFiles[0];
        }
        File[] cliFiles = GroovyUtils.getFilesInDirectoryByPattern((String)(grailsSdkHomePath + "/dist/"), (String)"grails-cli-\\d[^-]*(?:-SNAPSHOT)?\\.jar");
        if (cliFiles.length > 0) {
            return cliFiles[0];
        }
        return null;
    }

    @Nullable
    private static File findSpringLoadedJar(@NotNull String grailsSdkHomePath) {
        if (grailsSdkHomePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grailsSdkHomePath", "org/jetbrains/plugins/grails/runner/impl/GrailsInstallationCommandExecutor", "findSpringLoadedJar"));
        }
        File springLoadedJar = GrailsUtils.findLatestJarInIvyRepository(grailsSdkHomePath + "/lib/org.springframework/springloaded", "springloaded-");
        if (springLoadedJar == null) {
            springLoadedJar = GrailsUtils.findLatestJarInIvyRepository(grailsSdkHomePath + "/lib/org.springsource.springloaded/springloaded-core", "springloaded-core-");
        }
        if (springLoadedJar == null) {
            springLoadedJar = GrailsUtils.findLatestJarInIvyRepository(grailsSdkHomePath + "/lib/com.springsource.springloaded/springloaded-core", "springloaded-core-");
        }
        return springLoadedJar;
    }

    private static void addToClassPath(@NotNull JavaParameters params, Collection<VirtualFile> files) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "org/jetbrains/plugins/grails/runner/impl/GrailsInstallationCommandExecutor", "addToClassPath"));
        }
        List programParams = params.getProgramParametersList().getList();
        int cpIndex = programParams.indexOf("--classpath");
        if (cpIndex != -1 && cpIndex < programParams.size() - 1) {
            PathsList pathsList = new PathsList();
            pathsList.add((String)programParams.get(cpIndex + 1));
            pathsList.addVirtualFiles(files);
            params.getProgramParametersList().replaceOrAppend((String)programParams.get(cpIndex + 1), pathsList.getPathsString());
        } else {
            PathsList pathsList = new PathsList();
            pathsList.addVirtualFiles(files);
            params.getProgramParametersList().addAt(0, "--classpath");
            params.getProgramParametersList().addAt(1, pathsList.getPathsString());
        }
    }
}

