/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.runner.ui;

import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.runner.GrailsRunConfiguration;
import org.jetbrains.plugins.grails.runner.ui.GrailsApplicationCombobox;
import org.jetbrains.plugins.grails.runner.ui.GrailsRunConfigurationEditorListener;
import org.jetbrains.plugins.grails.runner.ui.GrailsRunConfigurationEditorWithListener;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;

public class GrailsRunConfigurationEditor
extends GrailsRunConfigurationEditorWithListener
implements PanelWithAnchor {
    private final Project myProject;
    private JPanel myMainPanel;
    private GrailsApplicationCombobox myApplicationsCombo;
    private JTextField myCommandLine;
    private RawCommandLineEditor myVMParameters;
    private EnvironmentVariablesComponent myEnvVariablesComponent;
    private JBCheckBox myLaunchBrowser;
    private final Collection<SettingsEditor<GrailsRunConfiguration>> myExtensionEditors;
    private JPanel myExtensionPanel;
    private JComponent anchor;

    public GrailsRunConfigurationEditor(Project project) {
        this.$$$setupUI$$$();
        this.myExtensionEditors = ContainerUtil.newArrayList();
        this.myProject = project;
        this.myApplicationsCombo.setApplications(GrailsApplicationManager.getInstance(project).getApplications());
        this.myApplicationsCombo.addItemListener(e -> this.applicationChanged(this.getApplication()));
        this.myCommandLine.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                GrailsRunConfigurationEditor.this.commandLineChanged(GrailsRunConfigurationEditor.this.getCommandLine());
            }
        });
        this.myVMParameters.setDialogCaption("VM Options");
        this.setAnchor((JComponent)this.myEnvVariablesComponent.getLabel());
    }

    protected void resetEditorFrom(GrailsRunConfiguration configuration) {
        this.myApplicationsCombo.setSelectedApplication(configuration.getGrailsApplicationNullable());
        this.myCommandLine.setText(configuration.getProgramParameters());
        this.myVMParameters.setText(configuration.getVMParameters());
        this.myEnvVariablesComponent.setEnvs(new HashMap(configuration.getEnvs()));
        this.myEnvVariablesComponent.setPassParentEnvs(configuration.isPassParentEnvs());
        this.myLaunchBrowser.setSelected(configuration.isLaunchBrowser());
        this.myExtensionEditors.forEach(e -> e.resetFrom((Object)configuration));
    }

    protected void applyEditorTo(GrailsRunConfiguration configuration) throws ConfigurationException {
        configuration.setGrailsApplication(this.getApplication());
        configuration.setVMParameters(this.myVMParameters.getText().trim());
        configuration.setProgramParameters(this.myCommandLine.getText().trim());
        configuration.setEnvs(this.myEnvVariablesComponent.getEnvs());
        configuration.setPassParentEnvs(this.myEnvVariablesComponent.isPassParentEnvs());
        configuration.setLaunchBrowser(this.myLaunchBrowser.isSelected());
        for (SettingsEditor<GrailsRunConfiguration> editor : this.myExtensionEditors) {
            editor.applyTo((Object)configuration);
        }
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myEnvVariablesComponent.setAnchor(anchor);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/ui/GrailsRunConfigurationEditor", "createEditor"));
        }
        return jPanel;
    }

    @Override
    public void applicationChanged(GrailsApplication application) {
        for (SettingsEditor<GrailsRunConfiguration> editor : this.myExtensionEditors) {
            if (!(editor instanceof GrailsRunConfigurationEditorListener)) continue;
            ((GrailsRunConfigurationEditorListener)editor).applicationChanged(application);
        }
    }

    @Override
    public void commandLineChanged(String commandLine) {
        GrailsRunConfigurationEditor.setCBEnabled("run-app".equals(MvcCommand.parse((String)commandLine).getCommand()), (JCheckBox)this.myLaunchBrowser);
        for (SettingsEditor<GrailsRunConfiguration> editor : this.myExtensionEditors) {
            if (!(editor instanceof GrailsRunConfigurationEditorListener)) continue;
            ((GrailsRunConfigurationEditorListener)editor).commandLineChanged(commandLine);
        }
    }

    public void addExtension(@NotNull SettingsEditor<GrailsRunConfiguration> editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/grails/runner/ui/GrailsRunConfigurationEditor", "addExtension"));
        }
        this.myExtensionEditors.add(editor);
        this.myExtensionPanel.add((Component)editor.getComponent(), "First");
    }

    @Nullable
    private GrailsApplication getApplication() {
        return this.myApplicationsCombo.getSelectedApplication();
    }

    @NotNull
    private String getCommandLine() {
        String commandLine = StringUtil.trim((String)this.myCommandLine.getText());
        String string = commandLine == null ? "" : commandLine;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/ui/GrailsRunConfigurationEditor", "getCommandLine"));
        }
        return string;
    }

    public static void setCBEnabled(boolean enabled, JCheckBox checkBox) {
        boolean wasEnabled = checkBox.isEnabled();
        checkBox.setEnabled(enabled);
        if (wasEnabled && !enabled) {
            checkBox.setSelected(false);
        } else if (!wasEnabled && enabled) {
            checkBox.setSelected(true);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBCheckBox jBCheckBox;
        EnvironmentVariablesComponent environmentVariablesComponent;
        RawCommandLineEditor rawCommandLineEditor;
        JTextField jTextField;
        GrailsApplicationCombobox grailsApplicationCombobox;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Application:");
        jLabel.setDisplayedMnemonic('A');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myApplicationsCombo = grailsApplicationCombobox = new GrailsApplicationCombobox();
        jPanel2.add((Component)((Object)grailsApplicationCombobox), new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Command line:");
        jLabel2.setDisplayedMnemonic('C');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCommandLine = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("VM options:");
        jBLabel.setDisplayedMnemonic('V');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVMParameters = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel2.add((Component)rawCommandLineEditor, new GridConstraints(2, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myEnvVariablesComponent = environmentVariablesComponent = new EnvironmentVariablesComponent();
        environmentVariablesComponent.setLabelLocation("West");
        jPanel2.add((Component)environmentVariablesComponent, new GridConstraints(3, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Options:");
        jLabel3.setDisplayedMnemonic('O');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLaunchBrowser = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Launch browser");
        jBCheckBox.setMnemonic('L');
        jBCheckBox.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBCheckBox, new GridConstraints(4, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myExtensionPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(5, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jLabel2.setLabelFor(jTextField);
        jBLabel.setLabelFor((Component)rawCommandLineEditor);
        jLabel3.setLabelFor(jPanel);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

