/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.sdk;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsConfigUtils;
import org.jetbrains.plugins.grails.sdk.GrailsSDK;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsStructureListener;
import org.jetbrains.plugins.grails.util.version.VersionImpl;

@State(name="GrailsSDKManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class GrailsSDKManager
implements PersistentStateComponent<StateHolder> {
    private final Map<String, String> myGrailsSDKs = ContainerUtil.newHashMap();

    @NotNull
    public static GrailsSDKManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/sdk/GrailsSDKManager", "getInstance"));
        }
        GrailsSDKManager grailsSDKManager = (GrailsSDKManager)ServiceManager.getService((Project)project, GrailsSDKManager.class);
        if (grailsSDKManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/sdk/GrailsSDKManager", "getInstance"));
        }
        return grailsSDKManager;
    }

    @Nullable
    public static String getGrailsSdkPath(@Nullable GrailsApplication application) {
        if (application == null) {
            return null;
        }
        String rootPath = application.getRoot().getCanonicalPath();
        return GrailsSDKManager.getInstance((Project)application.getProject()).myGrailsSDKs.get(rootPath);
    }

    @Nullable
    public static GrailsSDK getGrailsSdk(@NotNull GrailsApplication application) {
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/grails/sdk/GrailsSDKManager", "getGrailsSdk"));
        }
        String sdkPath = GrailsSDKManager.getGrailsSdkPath(application);
        if (sdkPath == null) {
            return null;
        }
        String version = GrailsConfigUtils.getInstance().getSDKVersion(sdkPath);
        if (version == "undefined") {
            return null;
        }
        return new GrailsSDK(sdkPath, new VersionImpl(version));
    }

    public static void setGrailsSDK(@NotNull GrailsApplication application, @Nullable String path) {
        String oldPath;
        String rootPath;
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/grails/sdk/GrailsSDKManager", "setGrailsSDK"));
        }
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            path = null;
        }
        if ((rootPath = application.getRoot().getCanonicalPath()) != null && !Comparing.equal((String)path, (String)(oldPath = GrailsSDKManager.getInstance(application.getProject()).setGrailsSDK(rootPath, path)))) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (application == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/grails/sdk/GrailsSDKManager", "lambda$setGrailsSDK$23"));
                }
                ((GrailsStructureListener)application.getProject().getMessageBus().syncPublisher(GrailsStructureListener.LISTENER_TOPIC)).sdkChanged(application);
            });
        }
    }

    @Nullable
    public String setGrailsSDK(@NotNull String rootPath, @Nullable String path) {
        if (rootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPath", "org/jetbrains/plugins/grails/sdk/GrailsSDKManager", "setGrailsSDK"));
        }
        PropertiesComponent.getInstance().setValue("grails.last.selected.sdk.home", path);
        return this.myGrailsSDKs.put(rootPath, path);
    }

    @Nullable
    public synchronized StateHolder getState() {
        StateHolder holder = new StateHolder();
        holder.grailsSDKs.putAll(this.myGrailsSDKs);
        return holder;
    }

    public void loadState(StateHolder state) {
        this.myGrailsSDKs.clear();
        this.myGrailsSDKs.putAll(state.grailsSDKs);
    }

    public static class StateHolder {
        public Map<String, String> grailsSDKs = new THashMap();
    }
}

