/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.settings;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.config.GrailsSettings;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutorUtil;
import org.jetbrains.plugins.grails.service.GrailsBackgroundService;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;
import org.jetbrains.plugins.grails.structure.impl.Grails3Application;
import org.jetbrains.plugins.grails.structure.sync.GrailsApplicationBackgroundTask;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.SerializableStringMultiMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.mvc.ConsoleProcessDescriptor;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;

@State(name="GrailsInjectedTraitService", storages={@Storage(value="$WORKSPACE_FILE$")})
public class GrailsInjectedTraitService
implements PersistentStateComponent<MyStateHolder> {
    private static final Logger LOG = Logger.getInstance(GrailsInjectedTraitService.class);
    private static final String MARKER = "--------------------------------------";
    private static final Map<GrailsArtifact, String> ARTEFACT_TO_NAME = ContainerUtil.newHashMap((Pair)Pair.create((Object)((Object)GrailsArtifact.DOMAIN), (Object)"Domain"), (Pair[])new Pair[]{Pair.create((Object)((Object)GrailsArtifact.CONTROLLER), (Object)"Controller"), Pair.create((Object)((Object)GrailsArtifact.SERVICE), (Object)"Service"), Pair.create((Object)((Object)GrailsArtifact.INTERCEPTOR), (Object)"Interceptor"), Pair.create((Object)((Object)GrailsArtifact.TAGLIB), (Object)"TagLibrary")});
    @NotNull
    private final Project myProject;
    @NotNull
    private final GrailsBackgroundService myBackgroundService;
    private final Map<VirtualFile, TraitInfo> myState;

    public GrailsInjectedTraitService(@NotNull Project project, @NotNull GrailsBackgroundService service) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService", "<init>"));
        }
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService", "<init>"));
        }
        this.myState = new FactoryMap<VirtualFile, TraitInfo>(){

            @Nullable
            protected TraitInfo create(VirtualFile key) {
                return new TraitInfo();
            }
        };
        this.myProject = project;
        this.myBackgroundService = service;
    }

    public void queueUpdate(boolean force) {
        ApplicationManager.getApplication().invokeLater(() -> this.myBackgroundService.run(new GrailsCollectInjectedTraitsTask(this.myProject, force)));
    }

    @NotNull
    public static Collection<String> getInjectedTraits(@NotNull GrTypeDefinition clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService", "getInjectedTraits"));
        }
        GrailsApplication application = GrailsApplicationManager.findApplication((PsiElement)clazz);
        if (application == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService", "getInjectedTraits"));
            }
            return list;
        }
        String artefactName = ARTEFACT_TO_NAME.get((Object)GrailsArtifact.getType((PsiClass)clazz));
        Collection collection = GrailsInjectedTraitService.getInstance((Project)clazz.getProject()).myState.get((Object)application.getRoot()).traits.get(artefactName);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService", "getInjectedTraits"));
        }
        return collection;
    }

    @NotNull
    public static GrailsInjectedTraitService getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService", "getInstance"));
        }
        GrailsInjectedTraitService grailsInjectedTraitService = (GrailsInjectedTraitService)ServiceManager.getService((Project)project, GrailsInjectedTraitService.class);
        if (grailsInjectedTraitService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService", "getInstance"));
        }
        return grailsInjectedTraitService;
    }

    @Nullable
    private static String doCollectOutput(@NotNull Grails3Application application, @NotNull ProgressIndicator indicator) {
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService", "doCollectOutput"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService", "doCollectOutput"));
        }
        Ref descriptorRef = Ref.create(null);
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (application == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService", "lambda$doCollectOutput$20"));
            }
            descriptorRef.set((Object)GrailsCommandExecutorUtil.execute(application, new MvcCommand("idea-list-injected-traits", new String[0]), null, true, new String[0]));
        }, ModalityState.defaultModalityState());
        if (descriptorRef.isNull()) {
            return null;
        }
        ConsoleProcessDescriptor descriptor = (ConsoleProcessDescriptor)descriptorRef.get();
        final StringBuilder outputBuilder = new StringBuilder();
        descriptor.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                if (outputType.equals((Object)ProcessOutputTypes.STDOUT)) {
                    outputBuilder.append(StringUtil.convertLineSeparators((String)event.getText()));
                }
            }
        });
        descriptor.waitWith(indicator);
        return outputBuilder.toString();
    }

    @Nullable
    private static MultiMap<String, String> doCollectInjectedTraits(@NotNull Grails3Application application, @NotNull ProgressIndicator indicator) {
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService", "doCollectInjectedTraits"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService", "doCollectInjectedTraits"));
        }
        String output = GrailsInjectedTraitService.doCollectOutput(application, indicator);
        LOG.debug(output);
        if (output == null) {
            return null;
        }
        try {
            return GrailsInjectedTraitService.doParseOutput(output);
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
            return null;
        }
        catch (Error e) {
            LOG.debug((Throwable)e);
            return null;
        }
    }

    @NotNull
    private static MultiMap<String, String> doParseOutput(@NotNull String output) {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService", "doParseOutput"));
        }
        MultiMap result = MultiMap.create();
        LinkedList lines = ContainerUtil.newLinkedList((Object[])output.split("\n"));
        while (!((String)lines.pop()).equals(MARKER)) {
        }
        while (lines.size() > 1) {
            String traitName = (String)lines.pop();
            int artifactCount = Integer.parseInt((String)lines.pop());
            while (artifactCount-- > 0) {
                String artifactName = (String)lines.pop();
                result.putValue((Object)artifactName, (Object)traitName);
            }
        }
        assert (((String)lines.pop()).equals(MARKER));
        MultiMap multiMap = result;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService", "doParseOutput"));
        }
        return multiMap;
    }

    private static int getBuildFileCrc(GrailsApplication application) {
        VirtualFile buildFile = application.getRoot().findChild("build.gradle");
        if (buildFile == null) {
            return 0;
        }
        try {
            return GrailsSettings.getScriptCrc(VfsUtilCore.loadText((VirtualFile)buildFile));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return 0;
        }
    }

    @Nullable
    public synchronized MyStateHolder getState() {
        MyStateHolder result = new MyStateHolder();
        this.myState.forEach((root, info) -> {
            if (info.crc != 0) {
                result.state.put(root.getCanonicalPath(), info.copy());
            }
        });
        return result.state.isEmpty() ? null : result;
    }

    public synchronized void loadState(MyStateHolder stateHolder) {
        this.myState.clear();
        stateHolder.state.forEach((rootPath, info) -> {
            VirtualFile root = LocalFileSystem.getInstance().findFileByPath(rootPath);
            if (root != null) {
                this.myState.put(root, (TraitInfo)info);
            }
        });
    }

    public static class TraitInfo {
        public SerializableStringMultiMap traits = new SerializableStringMultiMap();
        public int crc;

        @NotNull
        TraitInfo copy() {
            TraitInfo copy = new TraitInfo();
            copy.crc = this.crc;
            copy.traits = new SerializableStringMultiMap(this.traits);
            TraitInfo traitInfo = copy;
            if (traitInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService$TraitInfo", "copy"));
            }
            return traitInfo;
        }
    }

    public static class MyStateHolder {
        public Map<String, TraitInfo> state = new THashMap();
    }

    private class GrailsCollectInjectedTraitsTask
    extends GrailsApplicationBackgroundTask {
        private final boolean myForce;
        private final Disposable myDisposable;

        public GrailsCollectInjectedTraitsTask(Project project, boolean force) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService$GrailsCollectInjectedTraitsTask", "<init>"));
            }
            super(project, GrailsBundle.message("grails.collect.traits.title", new Object[0]));
            this.myForce = force;
            this.myDisposable = Disposer.newDisposable((String)"Grails traits disposable");
            Disposer.register((Disposable)project, (Disposable)this.myDisposable);
            DaemonCodeAnalyzer.getInstance((Project)project).disableUpdateByTimer(this.myDisposable);
        }

        @Override
        protected void run(@NotNull GrailsApplication application, @NotNull ProgressIndicator indicator) {
            if (application == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService$GrailsCollectInjectedTraitsTask", "run"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService$GrailsCollectInjectedTraitsTask", "run"));
            }
            if (!(application instanceof Grails3Application)) {
                return;
            }
            int crc = GrailsInjectedTraitService.getBuildFileCrc(application);
            if (!this.myForce && ((TraitInfo)((GrailsInjectedTraitService)GrailsInjectedTraitService.this).myState.get((Object)application.getRoot())).crc == crc) {
                return;
            }
            MultiMap result = GrailsInjectedTraitService.doCollectInjectedTraits((Grails3Application)application, indicator);
            if (result == null) {
                return;
            }
            TraitInfo info = new TraitInfo();
            info.traits = new SerializableStringMultiMap((MultiMap<String, String>)(crc == 0 ? MultiMap.empty() : result));
            info.crc = crc;
            GrailsInjectedTraitService.this.myState.put(application.getRoot(), info);
        }

        protected void onFinished() {
            Disposer.dispose((Disposable)this.myDisposable);
        }
    }
}

