/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.structure;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import icons.GroovyMvcIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.structure.GrailsApplication;

public abstract class GrailsApplicationBase
extends UserDataHolderBase
implements GrailsApplication {
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myRoot;
    private boolean myDisposed;

    protected GrailsApplicationBase(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/structure/GrailsApplicationBase", "<init>"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/plugins/grails/structure/GrailsApplicationBase", "<init>"));
        }
        this.myProject = project;
        this.myRoot = root;
    }

    @Override
    @NotNull
    public final Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/structure/GrailsApplicationBase", "getProject"));
        }
        return project;
    }

    @Override
    @NotNull
    public final VirtualFile getRoot() {
        VirtualFile virtualFile = this.myRoot;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/structure/GrailsApplicationBase", "getRoot"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public final VirtualFile getAppRoot() {
        VirtualFile virtualFile = (VirtualFile)ObjectUtils.assertNotNull((Object)this.myRoot.findChild("grails-app"));
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/structure/GrailsApplicationBase", "getAppRoot"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public String getName() {
        if ("STUB_NAME" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/structure/GrailsApplicationBase", "getName"));
        }
        return "STUB_NAME";
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = GroovyMvcIcons.Grails;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/structure/GrailsApplicationBase", "getIcon"));
        }
        return icon;
    }

    @Override
    public final boolean isDisposed() {
        return this.myDisposed;
    }

    public final void dispose() {
        this.myDisposed = true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrailsApplicationBase base = (GrailsApplicationBase)o;
        if (!this.myProject.equals(base.myProject)) {
            return false;
        }
        return this.myRoot.equals(base.myRoot);
    }

    public int hashCode() {
        int result = this.myProject.hashCode();
        result = 31 * result + this.myRoot.hashCode();
        return result;
    }
}

