/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.structure;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.config.GrailsConfigUtils;
import org.jetbrains.plugins.grails.structure.GrailsApplicationBase;
import org.jetbrains.plugins.grails.structure.OldGrailsApplication;
import org.jetbrains.plugins.grails.util.version.Version;
import org.jetbrains.plugins.grails.util.version.VersionImpl;

public abstract class GrailsModuleBasedApplication
extends GrailsApplicationBase
implements OldGrailsApplication {
    @NotNull
    private final Module myModule;

    public GrailsModuleBasedApplication(@NotNull Module module, @NotNull VirtualFile root) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/structure/GrailsModuleBasedApplication", "<init>"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/plugins/grails/structure/GrailsModuleBasedApplication", "<init>"));
        }
        super(module.getProject(), root);
        this.myModule = module;
        Disposer.register((Disposable)this.myModule, (Disposable)this);
    }

    @Override
    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/structure/GrailsModuleBasedApplication", "getModule"));
        }
        return module;
    }

    @Override
    @NotNull
    public Version getVersion() {
        String version = GrailsConfigUtils.getGrailsVersion(this.getModule());
        Version version2 = version == null ? Version.LATEST_2x : new VersionImpl(version);
        if (version2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/structure/GrailsModuleBasedApplication", "getVersion"));
        }
        return version2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GrailsModuleBasedApplication that = (GrailsModuleBasedApplication)o;
        return this.myModule.equals(that.myModule);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myModule.hashCode();
        return result;
    }
}

