/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.structure.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.gradle.GrailsModuleData;
import org.jetbrains.plugins.grails.structure.GrailsApplicationBase;
import org.jetbrains.plugins.grails.util.version.Version;
import org.jetbrains.plugins.grails.util.version.VersionImpl;

public abstract class GrailsGradleApplication
extends GrailsApplicationBase {
    @NotNull
    private final String myName;
    @NotNull
    private final GrailsModuleData myData;
    @NotNull
    private final Version myVersion;

    public GrailsGradleApplication(@NotNull Project project, @NotNull VirtualFile root, @NotNull String name, @NotNull GrailsModuleData data) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/structure/impl/GrailsGradleApplication", "<init>"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/plugins/grails/structure/impl/GrailsGradleApplication", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/grails/structure/impl/GrailsGradleApplication", "<init>"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/plugins/grails/structure/impl/GrailsGradleApplication", "<init>"));
        }
        super(project, root);
        this.myName = name;
        this.myData = data;
        this.myVersion = new VersionImpl(this.myData.getGrailsVersion());
        Disposer.register((Disposable)project, (Disposable)this);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/structure/impl/GrailsGradleApplication", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public Version getVersion() {
        Version version = this.myVersion;
        if (version == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/structure/impl/GrailsGradleApplication", "getVersion"));
        }
        return version;
    }

    @NotNull
    public GrailsModuleData getData() {
        GrailsModuleData grailsModuleData = this.myData;
        if (grailsModuleData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/structure/impl/GrailsGradleApplication", "getData"));
        }
        return grailsModuleData;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GrailsGradleApplication that = (GrailsGradleApplication)o;
        if (!this.myName.equals(that.myName)) {
            return false;
        }
        return this.myData.equals((Object)that.myData);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myName.hashCode();
        result = 31 * result + this.myData.hashCode();
        return result;
    }
}

