/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.structure.impl;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationProvider;
import org.jetbrains.plugins.grails.structure.impl.Grails2Application;

public class PlainGrailsApplicationProvider
extends GrailsApplicationProvider {
    @Override
    @Nullable
    public GrailsApplication createApplication(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/structure/impl/PlainGrailsApplicationProvider", "createApplication"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/plugins/grails/structure/impl/PlainGrailsApplicationProvider", "createApplication"));
        }
        Module module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(root);
        if (module == null) {
            return null;
        }
        if (GrailsFramework.getInstance().isAuxModule(module)) {
            return null;
        }
        boolean gradleAware = ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module);
        if (!gradleAware) {
            VirtualFile properties = VfsUtil.findRelativeFile((VirtualFile)root, (String[])new String[]{"application.properties"});
            if (properties == null) {
                return null;
            }
            VirtualFile pluginXml = VfsUtil.findRelativeFile((VirtualFile)root, (String[])new String[]{"plugin.xml"});
            if (pluginXml != null) {
                return null;
            }
            return new Grails2Application(root, module);
        }
        return null;
    }
}

