/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.util.version;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.util.version.Range;
import org.jetbrains.plugins.grails.util.version.VersionImpl;

public interface Version
extends Comparable<Version> {
    public static final Version LATEST_2x = new Version(){

        @Override
        public int compareTo(@NotNull Version other) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/plugins/grails/util/version/Version$1", "compareTo"));
            }
            if (other == this) {
                return 0;
            }
            return other.compareTo(GRAILS_3_0) < 0 ? 1 : -1;
        }

        public String toString() {
            return "Latest 2.x";
        }
    };
    public static final Version GRAILS_1_1 = new VersionImpl("1.1");
    public static final Version GRAILS_1_2 = new VersionImpl("1.2");
    public static final Version GRAILS_1_3_4 = new VersionImpl("1.3.4");
    public static final Version GRAILS_2_0 = new VersionImpl("2.0");
    public static final Version GRAILS_2_3_5 = new VersionImpl("2.3.5");
    public static final Version GRAILS_2_3_10 = new VersionImpl("2.3.10");
    public static final Version GRAILS_2_4_0 = new VersionImpl("2.4.0");
    public static final Version GRAILS_3_0 = new VersionImpl("3.0");
    public static final Range<Version> LESS_THAN_3 = new Range<Version>().setEnd(GRAILS_3_0).setEndInclusive(false);
    public static final Range<Version> AT_LEAST_3 = new Range<Version>().setStart(GRAILS_3_0).setStartInclusive(true);

    @Override
    public int compareTo(@NotNull Version var1);

    default public boolean equalsToString(@Nullable String other) {
        return other != null && this.equals(new VersionImpl(other));
    }

    default public int compareToString(@NotNull String other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/plugins/grails/util/version/Version", "compareToString"));
        }
        return this.compareTo(new VersionImpl(other));
    }

    default public boolean isAtLeast(@NotNull Version other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/plugins/grails/util/version/Version", "isAtLeast"));
        }
        return this.compareTo(other) >= 0;
    }

    default public boolean isAtLeast(@NotNull String other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/plugins/grails/util/version/Version", "isAtLeast"));
        }
        return this.compareToString(other) >= 0;
    }

    default public boolean isLessThan(@NotNull Version other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/plugins/grails/util/version/Version", "isLessThan"));
        }
        return this.compareTo(other) < 0;
    }

    default public boolean isLessThan(@NotNull String other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/plugins/grails/util/version/Version", "isLessThan"));
        }
        return this.compareToString(other) < 0;
    }
}

