/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.grails;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipOutputStream;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.groovy.grails.rt.GrailsRtMarker;
import org.jetbrains.plugins.grails.runner.OldGrailsRunConfiguration;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;

public abstract class OldGrailsCommandExecutor {
    private static final String AGENT_JAR_SUFFIX = "ideaAgentJar.jar";

    public abstract boolean isApplicable(@NotNull Module var1);

    public void addListener(JavaParameters params, String listener) {
        String listeners = params.getVMParametersList().getPropertyValue("grails.build.listeners");
        listeners = listeners != null ? (listeners.startsWith("\"") && listeners.endsWith("\"") ? "\"" + listeners.substring(1, listeners.length() - 2) + "," + listener + "\"" : "\"" + listeners + "," + listener + "\"") : listener;
        params.getVMParametersList().replaceOrAppend("grails.build.listeners", "-Dgrails.build.listeners=" + listeners);
    }

    public static void addAgentJar(JavaParameters params) {
        String listenerPath = PathUtil.getJarPathForClass(GrailsRtMarker.class);
        for (String vmParam : params.getVMParametersList().getList()) {
            if (!vmParam.startsWith("-javaagent:") || !vmParam.endsWith(listenerPath) && !vmParam.endsWith(AGENT_JAR_SUFFIX)) continue;
            return;
        }
        params.getVMParametersList().add("-javaagent:" + OldGrailsCommandExecutor.ensureJar(listenerPath));
    }

    public JavaParameters createJavaParameters(@NotNull Module module, boolean forCreation, @NotNull String command, String ... args) throws ExecutionException {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/grails/OldGrailsCommandExecutor", "createJavaParameters"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/groovy/grails/OldGrailsCommandExecutor", "createJavaParameters"));
        }
        return this.createJavaParameters(module, forCreation, new MvcCommand(command, args));
    }

    public abstract JavaParameters createJavaParameters(@NotNull Module var1, boolean var2, @NotNull MvcCommand var3) throws ExecutionException;

    public abstract JavaParameters createJavaParametersForRun(@NotNull Module var1, boolean var2, @Nullable Object var3, @NotNull MvcCommand var4) throws ExecutionException;

    @Nullable
    public Pair<String, SettingsEditor<OldGrailsRunConfiguration>> createSettingsEditor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/grails/OldGrailsCommandExecutor", "createSettingsEditor"));
        }
        return null;
    }

    @Nullable
    public Object readAdditionalConfiguration(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/grails/OldGrailsCommandExecutor", "readAdditionalConfiguration"));
        }
        return null;
    }

    public void writeAdditionalConfiguration(@NotNull Object cfg, @NotNull Element element) {
        if (cfg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cfg", "org/jetbrains/plugins/groovy/grails/OldGrailsCommandExecutor", "writeAdditionalConfiguration"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/grails/OldGrailsCommandExecutor", "writeAdditionalConfiguration"));
        }
    }

    public Object cloneAdditionalConfiguration(@NotNull Object cfg) {
        if (cfg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cfg", "org/jetbrains/plugins/groovy/grails/OldGrailsCommandExecutor", "cloneAdditionalConfiguration"));
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String ensureJar(String path) {
        File file = new File(path);
        if (file.isDirectory()) {
            try {
                File tempFile = FileUtil.createTempFile((String)"idea", (String)AGENT_JAR_SUFFIX);
                tempFile.deleteOnExit();
                try (ZipOutputStream zipOutput = new ZipOutputStream(new FileOutputStream(tempFile));){
                    ZipUtil.addDirToZipRecursively((ZipOutputStream)zipOutput, null, (File)file, (String)"", null, null);
                }
                return tempFile.getAbsolutePath();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create template jar", e);
            }
        }
        return path;
    }

    protected static void addCommonJvmOptions(JavaParameters params) {
        if (SystemInfo.isWindows && !params.getVMParametersList().getParametersString().contains("-Djline.WindowsTerminal.directConsole")) {
            params.getVMParametersList().add("-Djline.WindowsTerminal.directConsole=false");
        }
        if (Boolean.getBoolean("idea.grails.disable.class.modification")) {
            params.getVMParametersList().add("-Didea.grails.disable.class.modification=true");
        }
    }
}

