/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.plugins;

import com.intellij.openapi.module.Module;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.SortableColumnModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginColumnInfo;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginDescriptor;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginIsInstalledColumnInfo;

public class AvailablePluginsModel
extends AbstractTableModel
implements SortableColumnModel {
    public static final int COLUMN_IS_INSTALLED = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_VERSION = 2;
    public static final int COLUMN_TITLE = 3;
    private final Module myModule;
    protected ColumnInfo<MvcPluginDescriptor, Object>[] myColumns;
    private final List<MvcPluginDescriptor> myAvailablePlugins = new ArrayList<MvcPluginDescriptor>();

    public AvailablePluginsModel(Module module, Set<String> installedPlugins, @Nullable Collection<MvcPluginDescriptor> availablePlugins) {
        this.myColumns = new ColumnInfo[]{new MvcPluginIsInstalledColumnInfo(installedPlugins), new MvcPluginColumnInfo(module, this, "Name", 150){

            @Override
            public String valueOf(MvcPluginDescriptor mvcPlugin) {
                return mvcPlugin.getName();
            }
        }, new MvcPluginColumnInfo(module, this, "Version", 20){

            @Override
            public String valueOf(MvcPluginDescriptor mvcPlugin) {
                return mvcPlugin.getLatestVersion();
            }
        }, new MvcPluginColumnInfo(module, this, "Title", 150){

            @Override
            public String valueOf(MvcPluginDescriptor mvcPlugin) {
                return mvcPlugin.getTitle();
            }
        }};
        this.myModule = module;
        this.myAvailablePlugins.addAll(availablePlugins);
        this.fireModelChange();
    }

    public RowSorter.SortKey getDefaultSortKey() {
        return new RowSorter.SortKey(0, SortOrder.ASCENDING);
    }

    public MvcPluginDescriptor getRowValue(int row) {
        return this.myAvailablePlugins.get(row);
    }

    public void setData(Collection<MvcPluginDescriptor> list) {
        this.myAvailablePlugins.clear();
        this.myAvailablePlugins.addAll(list);
        this.fireModelChange();
    }

    public List<MvcPluginDescriptor> getAvailablePlugins() {
        return this.myAvailablePlugins;
    }

    private void fireModelChange() {
        this.fireTableDataChanged();
    }

    public Module getModule() {
        return this.myModule;
    }

    @Override
    public int getColumnCount() {
        return this.myColumns.length;
    }

    public ColumnInfo[] getColumnInfos() {
        return this.myColumns;
    }

    public boolean isSortable() {
        return true;
    }

    public void setSortable(boolean aBoolean) {
    }

    @Override
    public String getColumnName(int column) {
        return this.myColumns[column].getName();
    }

    @Override
    public int getRowCount() {
        return this.myAvailablePlugins.size();
    }

    @Override
    @Nullable
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.myColumns[columnIndex].valueOf((Object)this.myAvailablePlugins.get(rowIndex));
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.myColumns[columnIndex].isCellEditable((Object)this.myAvailablePlugins.get(rowIndex));
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.myColumns[columnIndex].setValue((Object)this.myAvailablePlugins.get(rowIndex), aValue);
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }
}

