/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.plugins.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.IconUtil;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginDescriptor;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginUtil;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginsMain;

public class AddCustomPluginAction
extends AnAction
implements DumbAware {
    private final MvcPluginsMain myMvcPluginsMain;

    public AddCustomPluginAction(MvcPluginsMain mvcPluginsMain) {
        super("Add custom plugin", "Add custom plugin", IconUtil.getAddIcon());
        this.myMvcPluginsMain = mvcPluginsMain;
    }

    public void actionPerformed(AnActionEvent e) {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, false, true, false, false, false);
        Module module = this.myMvcPluginsMain.getModule();
        VirtualFile[] files = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)module.getProject(), null);
        if (files.length > 0) {
            String pathToPlugin = files[0].getPath();
            MvcPluginDescriptor plugin = MvcPluginUtil.extractPluginInfo(pathToPlugin);
            if (plugin == null) {
                Messages.showErrorDialog((String)"Failed to read plugin archive!", (String)"Error");
                return;
            }
            this.myMvcPluginsMain.addCustomPlugin(plugin, pathToPlugin);
            this.myMvcPluginsMain.markInstalled(plugin.getName());
            this.myMvcPluginsMain.getFilter().setFilter("");
        }
    }
}

