/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.tomcat;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.Factory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.tomcat.TomcatContexts;
import org.jetbrains.idea.tomcat.TomcatModuleDeploymentModel;
import org.jetbrains.idea.tomcat.server.TomcatLocalModel;
import org.jetbrains.idea.tomcat.server.TomcatServerModel;

public class TomcatDeploymentSettingsEditor
extends SettingsEditor<DeploymentModel> {
    private JPanel myPanel;
    private JComboBox myContextPath;
    private JPanel myInnerPanel;
    private boolean myEEArtifact = false;

    public TomcatDeploymentSettingsEditor(final CommonModel configuration, final DeploymentSource source) {
        super((Factory)new Factory<DeploymentModel>(){

            public DeploymentModel create() {
                return new TomcatModuleDeploymentModel(configuration, source);
            }
        });
        this.$$$setupUI$$$();
    }

    public void resetEditorFrom(DeploymentModel settings) {
        TomcatModuleDeploymentModel deploymentModel = (TomcatModuleDeploymentModel)settings;
        this.myEEArtifact = deploymentModel.isEEArtifact();
        this.myInnerPanel.setVisible(!this.myEEArtifact);
        if (this.myEEArtifact) {
            return;
        }
        TomcatServerModel configuration = (TomcatServerModel)settings.getServerModel();
        if (configuration instanceof TomcatLocalModel) {
            this.updateContextPaths((TomcatLocalModel)configuration);
        }
        this.setSelectedContextPath(deploymentModel.CONTEXT_PATH, true);
    }

    public void applyEditorTo(DeploymentModel settings) throws ConfigurationException {
        if (this.myEEArtifact) {
            return;
        }
        ((TomcatModuleDeploymentModel)settings).CONTEXT_PATH = this.getSelectedContextPath();
    }

    @NotNull
    public JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/tomcat/TomcatDeploymentSettingsEditor", "createEditor"));
        }
        return jPanel;
    }

    private String getSelectedContextPath() {
        String item = (String)this.myContextPath.getEditor().getItem();
        return item != null ? item.trim() : "";
    }

    private void setSelectedContextPath(String contextPath, boolean addIfNotFound) {
        int itemCount = this.myContextPath.getItemCount();
        for (int idx = 0; idx < itemCount; ++idx) {
            String path = (String)this.myContextPath.getItemAt(idx);
            if (!contextPath.equals(path)) continue;
            this.myContextPath.setSelectedIndex(idx);
            return;
        }
        if (addIfNotFound) {
            this.myContextPath.addItem(contextPath);
            this.myContextPath.setSelectedItem(contextPath);
        }
    }

    private void updateContextPaths(TomcatLocalModel configuration) {
        String selectedContextPath = this.getSelectedContextPath();
        this.myContextPath.removeAllItems();
        try {
            TomcatContexts tomcatContexts = new TomcatContexts(configuration, configuration.getSourceBaseDirectoryPath());
            for (String path : tomcatContexts.getContextPaths()) {
                this.myContextPath.addItem(path);
            }
        }
        catch (RuntimeConfigurationException runtimeConfigurationException) {
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        this.setSelectedContextPath(selectedContextPath, true);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myInnerPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/jetbrains/idea/tomcat/TomcatBundle").getString("label.deployment.configurable.application.context"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myContextPath = jComboBox = new JComboBox();
        jComboBox.setEditable(true);
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

