/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.ManipulatorsRegistryImpl;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.model.manipulators.ManipulatorsRegistry;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.persistence.util.PersistenceModelBrowserImpl;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PersistenceHelperImpl
extends PersistenceHelper {
    protected static Logger LOG = Logger.getInstance((String)"com.intellij.persistence.PersistenceHelperImpl");
    private final ManipulatorsRegistry myManipulatorsRegistry = new ManipulatorsRegistryImpl();

    @NotNull
    public ManipulatorsRegistry getManipulatorsRegistry() {
        ManipulatorsRegistry manipulatorsRegistry = this.myManipulatorsRegistry;
        if (manipulatorsRegistry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/PersistenceHelperImpl", "getManipulatorsRegistry"));
        }
        return manipulatorsRegistry;
    }

    @NotNull
    public PersistenceModelBrowser createModelBrowser() {
        PersistenceModelBrowserImpl persistenceModelBrowserImpl = new PersistenceModelBrowserImpl();
        if (persistenceModelBrowserImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/PersistenceHelperImpl", "createModelBrowser"));
        }
        return persistenceModelBrowserImpl;
    }

    public PersistenceModelBrowser getSharedModelBrowser() {
        return PersistenceModelBrowserImpl.INSTANCE;
    }

    public void runCompositeWriteCommandAction(final @NotNull Project project, final @NotNull String actionName, @NotNull Collection<PsiElement> affectedElements, final @NotNull Ref<ProgressIndicator> indicatorRef, final Runnable ... runnables) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/persistence/PersistenceHelperImpl", "runCompositeWriteCommandAction"));
        }
        if (actionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionName", "com/intellij/persistence/PersistenceHelperImpl", "runCompositeWriteCommandAction"));
        }
        if (affectedElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affectedElements", "com/intellij/persistence/PersistenceHelperImpl", "runCompositeWriteCommandAction"));
        }
        if (indicatorRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicatorRef", "com/intellij/persistence/PersistenceHelperImpl", "runCompositeWriteCommandAction"));
        }
        if (runnables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnables", "com/intellij/persistence/PersistenceHelperImpl", "runCompositeWriteCommandAction"));
        }
        if (runnables.length == 0) {
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(affectedElements)) {
            return;
        }
        final Ref commandRef = Ref.create(null);
        final CommandProcessorEx commandProcessorEx = (CommandProcessorEx)CommandProcessor.getInstance();
        commandRef.set(commandProcessorEx.startCommand(project, actionName, (Object)actionName, UndoConfirmationPolicy.REQUEST_CONFIRMATION));
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
        ProgressManager.getInstance().run((Task)new Task.Modal(project, actionName, true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/persistence/PersistenceHelperImpl$1", "run"));
                }
                indicatorRef.set((Object)indicator);
                Ref ex = Ref.create(null);
                try {
                    PersistenceHelperImpl.runInner(indicator, runnables);
                }
                catch (ProcessCanceledException processCanceledException) {
                    PersistenceHelperImpl.runInDispatchThread(new Runnable(ex){
                        final /* synthetic */ Ref val$ex;
                        {
                            this.val$ex = ref;
                        }

                        @Override
                        public void run() {
                            String message;
                            try {
                                FileDocumentManager.getInstance().saveAllDocuments();
                            }
                            finally {
                                commandProcessorEx.finishCommand(project, commandRef.get(), (Throwable)this.val$ex.get());
                            }
                            if (!this.val$ex.isNull() && StringUtil.isNotEmpty((String)(message = StringUtil.getMessage((Throwable)((Throwable)this.val$ex.get()))))) {
                                Messages.showMessageDialog((Project)project, (String)message, (String)actionName, (Icon)Messages.getErrorIcon());
                            }
                        }
                    });
                }
                catch (Exception e) {
                    try {
                        Throwable reason = e.getCause() != null ? e.getCause() : e;
                        LOG.error(reason);
                        ex.set((Object)reason);
                    }
                    catch (Throwable throwable) {
                        PersistenceHelperImpl.runInDispatchThread(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                    PersistenceHelperImpl.runInDispatchThread(new /* invalid duplicate definition of identical inner class */);
                }
                PersistenceHelperImpl.runInDispatchThread(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    private static void runInner(ProgressIndicator indicator, Runnable ... runnables) throws Exception {
        Ref throwableRef;
        block4: {
            throwableRef = Ref.create(null);
            try {
                indicator.setIndeterminate(false);
                indicator.setFraction(0.0);
                final Runnable[] clone = (Runnable[])runnables.clone();
                int i = 0;
                while (i < runnables.length && throwableRef.isNull()) {
                    Thread.yield();
                    final int index = i++;
                    indicator.setFraction((double)index * 1.0 / (double)runnables.length);
                    indicator.checkCanceled();
                    PersistenceHelperImpl.runInDispatchThread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ApplicationManager.getApplication().runWriteAction(clone[index]);
                            }
                            catch (Exception e) {
                                if (throwableRef.isNull()) {
                                    throwableRef.set((Object)e);
                                }
                            }
                            finally {
                                clone[index] = null;
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                if (!throwableRef.isNull()) break block4;
                throwableRef.set((Object)e);
            }
        }
        if (!throwableRef.isNull()) {
            throw (Exception)throwableRef.get();
        }
    }

    private static void runInDispatchThread(Runnable runnable) {
        ApplicationManager.getApplication().invokeAndWait(runnable, ModalityState.defaultModalityState());
    }
}

