/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.impl;

import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.remote.jdbc.RemoteArray;
import com.intellij.database.remote.jdbc.RemoteBlob;
import com.intellij.database.remote.jdbc.RemoteClob;
import com.intellij.database.remote.jdbc.RemoteRef;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.RemoteResultSetMetaData;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.remote.jdbc.impl.JdbcRemoteObject;
import com.intellij.database.remote.jdbc.impl.RemoteArrayImpl;
import com.intellij.database.remote.jdbc.impl.RemoteBlobImpl;
import com.intellij.database.remote.jdbc.impl.RemoteClobImpl;
import com.intellij.database.remote.jdbc.impl.RemoteRefImpl;
import com.intellij.database.remote.jdbc.impl.RemoteResultSetMetaDataImpl;
import com.intellij.database.remote.jdbc.impl.RemoteStatementImpl;
import com.intellij.execution.rmi.RemoteObject;
import com.intellij.openapi.util.Getter;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteResultSetImpl
extends JdbcRemoteObject
implements RemoteResultSet,
Getter<Connection> {
    private final ResultSet myDelegate;
    private final List<WeakReference<RemoteObject>> myExportedResults = ContainerUtil.createLockFreeCopyOnWriteList();

    protected RemoteResultSetImpl(ResultSet delegate) {
        this.myDelegate = delegate;
    }

    public static RemoteResultSetImpl wrap(ResultSet delegate) {
        return delegate == null ? null : new RemoteResultSetImpl(delegate);
    }

    private void dropExportedResults() throws RemoteException {
        this.unexportChildren(this.myExportedResults);
        this.myExportedResults.clear();
    }

    public <T extends Remote> T export2(T child) throws RemoteException {
        if (child == null) {
            return null;
        }
        this.myExportedResults.add(((JdbcRemoteObject)((Object)child)).getWeakRef());
        return (T)super.export(child);
    }

    public synchronized void unexportChildren() throws RemoteException {
        this.myExportedResults.clear();
        super.unexportChildren();
    }

    public String getCastToClassName() {
        return ResultSet.class.getName();
    }

    public Connection get() {
        try {
            return this.myDelegate.getStatement().getConnection();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Object getObject(int p1) throws RemoteException, SQLException {
        try {
            return this.wrapIfNeeded(this.myDelegate.getObject(p1), this);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public Object getObject(String p1) throws RemoteException, SQLException {
        try {
            return this.wrapIfNeeded(this.myDelegate.getObject(p1), this);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public Object getObject(String p1, Map<String, Class<?>> p2) throws RemoteException, SQLException {
        try {
            return this.wrapIfNeeded(this.myDelegate.getObject(p1, p2), this);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public Object getObject(int p1, Map<String, Class<?>> p2) throws RemoteException, SQLException {
        try {
            return this.wrapIfNeeded(this.myDelegate.getObject(p1, p2), this);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean getBoolean(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getBoolean(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean getBoolean(int p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getBoolean(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public byte getByte(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getByte(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public byte getByte(int p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getByte(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public short getShort(int p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getShort(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public short getShort(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getShort(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public int getInt(int p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getInt(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public int getInt(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getInt(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public long getLong(int p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getLong(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public long getLong(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getLong(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public float getFloat(int p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getFloat(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public float getFloat(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getFloat(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public double getDouble(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getDouble(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public double getDouble(int p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getDouble(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public byte[] getBytes(int p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getBytes(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public byte[] getBytes(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getBytes(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteArray getArray(int p1) throws RemoteException, SQLException {
        try {
            return this.export2(RemoteArrayImpl.wrap(this.myDelegate.getArray(p1)));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteArray getArray(String p1) throws RemoteException, SQLException {
        try {
            return this.export2(RemoteArrayImpl.wrap(this.myDelegate.getArray(p1)));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean next() throws RemoteException, SQLException {
        try {
            this.dropExportedResults();
            return this.myDelegate.next();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public int getType() throws RemoteException, SQLException {
        try {
            return this.myDelegate.getType();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean previous() throws RemoteException, SQLException {
        try {
            this.dropExportedResults();
            return this.myDelegate.previous();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean isClosed() throws RemoteException, SQLException {
        try {
            return this.myDelegate.isClosed();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void close() throws RemoteException, SQLException {
        try {
            this.unexportChildren();
            this.myDelegate.close();
            this.unreferenced();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteRef getRef(int p1) throws RemoteException, SQLException {
        try {
            return this.export2(RemoteRefImpl.wrap(this.myDelegate.getRef(p1)));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteRef getRef(String p1) throws RemoteException, SQLException {
        try {
            return this.export2(RemoteRefImpl.wrap(this.myDelegate.getRef(p1)));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public Date getDate(String p1, Calendar p2) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getDate(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public Date getDate(int p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getDate(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public Date getDate(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getDate(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public Date getDate(int p1, Calendar p2) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getDate(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public Time getTime(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getTime(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public Time getTime(String p1, Calendar p2) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getTime(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public Time getTime(int p1, Calendar p2) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getTime(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public Time getTime(int p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getTime(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean first() throws RemoteException, SQLException {
        try {
            this.dropExportedResults();
            return this.myDelegate.first();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean last() throws RemoteException, SQLException {
        try {
            this.dropExportedResults();
            return this.myDelegate.last();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public Timestamp getTimestamp(int p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getTimestamp(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public Timestamp getTimestamp(int p1, Calendar p2) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getTimestamp(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public Timestamp getTimestamp(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getTimestamp(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public Timestamp getTimestamp(String p1, Calendar p2) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getTimestamp(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public String getString(int p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getString(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public String getString(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getString(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public SQLWarning getWarnings() throws RemoteException, SQLException {
        try {
            return this.wrapSqlWarning(this.myDelegate.getWarnings());
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean absolute(int p1) throws RemoteException, SQLException {
        try {
            this.dropExportedResults();
            return this.myDelegate.absolute(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void afterLast() throws RemoteException, SQLException {
        try {
            this.myDelegate.afterLast();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void beforeFirst() throws RemoteException, SQLException {
        try {
            this.myDelegate.beforeFirst();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void cancelRowUpdates() throws RemoteException, SQLException {
        try {
            this.myDelegate.cancelRowUpdates();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void clearWarnings() throws RemoteException, SQLException {
        try {
            this.myDelegate.clearWarnings();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void deleteRow() throws RemoteException, SQLException {
        try {
            this.dropExportedResults();
            this.myDelegate.deleteRow();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public int findColumn(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.findColumn(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getBigDecimal(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getBigDecimal(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteBlob getBlob(int p1) throws RemoteException, SQLException {
        try {
            return this.export2(RemoteBlobImpl.wrap(this.myDelegate.getBlob(p1)));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteBlob getBlob(String p1) throws RemoteException, SQLException {
        try {
            return this.export2(RemoteBlobImpl.wrap(this.myDelegate.getBlob(p1)));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteClob getClob(int p1) throws RemoteException, SQLException {
        try {
            return this.export2(RemoteClobImpl.wrap(this.myDelegate.getClob(p1)));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteClob getClob(String p1) throws RemoteException, SQLException {
        try {
            return this.export2(RemoteClobImpl.wrap(this.myDelegate.getClob(p1)));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public int getConcurrency() throws RemoteException, SQLException {
        try {
            return this.myDelegate.getConcurrency();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public String getCursorName() throws RemoteException, SQLException {
        try {
            return this.myDelegate.getCursorName();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public int getFetchDirection() throws RemoteException, SQLException {
        try {
            return this.myDelegate.getFetchDirection();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public int getFetchSize() throws RemoteException, SQLException {
        try {
            return this.myDelegate.getFetchSize();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteResultSetMetaData getMetaData() throws RemoteException, SQLException {
        try {
            return (RemoteResultSetMetaData)((Object)this.export((Remote)((Object)RemoteResultSetMetaDataImpl.wrap(this.myDelegate.getMetaData()))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public int getRow() throws RemoteException, SQLException {
        try {
            return this.myDelegate.getRow();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteStatement getStatement() throws RemoteException, SQLException {
        try {
            return (RemoteStatement)((Object)this.export((Remote)((Object)RemoteStatementImpl.wrap(this.myDelegate.getStatement()))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void insertRow() throws RemoteException, SQLException {
        try {
            this.myDelegate.insertRow();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean isAfterLast() throws RemoteException, SQLException {
        try {
            return this.myDelegate.isAfterLast();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean isBeforeFirst() throws RemoteException, SQLException {
        try {
            return this.myDelegate.isBeforeFirst();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean isFirst() throws RemoteException, SQLException {
        try {
            return this.myDelegate.isFirst();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean isLast() throws RemoteException, SQLException {
        try {
            return this.myDelegate.isLast();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void moveToCurrentRow() throws RemoteException, SQLException {
        try {
            this.myDelegate.moveToCurrentRow();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void moveToInsertRow() throws RemoteException, SQLException {
        try {
            this.myDelegate.moveToInsertRow();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void refreshRow() throws RemoteException, SQLException {
        try {
            this.myDelegate.refreshRow();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean relative(int p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.relative(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean rowDeleted() throws RemoteException, SQLException {
        try {
            return this.myDelegate.rowDeleted();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean rowInserted() throws RemoteException, SQLException {
        try {
            return this.myDelegate.rowInserted();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean rowUpdated() throws RemoteException, SQLException {
        try {
            return this.myDelegate.rowUpdated();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void setFetchDirection(int p1) throws RemoteException, SQLException {
        try {
            this.myDelegate.setFetchDirection(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void setFetchSize(int p1) throws RemoteException, SQLException {
        try {
            this.myDelegate.setFetchSize(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateArray(String p1, Array p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateArray(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateArray(int p1, Array p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateArray(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateBigDecimal(String p1, BigDecimal p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateBigDecimal(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateBigDecimal(int p1, BigDecimal p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateBigDecimal(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateBlob(int p1, Blob p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateBlob(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateBlob(String p1, Blob p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateBlob(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateBoolean(String p1, boolean p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateBoolean(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateBoolean(int p1, boolean p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateBoolean(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateByte(int p1, byte p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateByte(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateByte(String p1, byte p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateByte(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateBytes(String p1, byte[] p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateBytes(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateBytes(int p1, byte[] p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateBytes(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateClob(String p1, Clob p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateClob(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateClob(int p1, Clob p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateClob(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateDate(int p1, Date p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateDate(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateDate(String p1, Date p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateDate(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateDouble(int p1, double p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateDouble(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateDouble(String p1, double p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateDouble(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateFloat(int p1, float p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateFloat(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateFloat(String p1, float p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateFloat(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateInt(int p1, int p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateInt(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateInt(String p1, int p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateInt(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateLong(String p1, long p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateLong(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateLong(int p1, long p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateLong(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateNull(int p1) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateNull(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateNull(String p1) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateNull(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateObject(String p1, Object p2, int p3) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateObject(p1, p2, p3);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateObject(String p1, Object p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateObject(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateObject(int p1, Object p2, int p3) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateObject(p1, p2, p3);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateObject(int p1, Object p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateObject(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateRef(String p1, Ref p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateRef(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateRef(int p1, Ref p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateRef(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateRow() throws RemoteException, SQLException {
        try {
            this.myDelegate.updateRow();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateShort(String p1, short p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateShort(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateShort(int p1, short p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateShort(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateString(int p1, String p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateString(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateString(String p1, String p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateString(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateTime(int p1, Time p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateTime(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateTime(String p1, Time p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateTime(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateTimestamp(String p1, Timestamp p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateTimestamp(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateTimestamp(int p1, Timestamp p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateTimestamp(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean wasNull() throws RemoteException, SQLException {
        try {
            return this.myDelegate.wasNull();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public int scrollToPosition(int curRowNum, int position) throws RemoteException, SQLException {
        try {
            return this.doScroll(curRowNum, position);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    private int doScroll(int rowNum, int position) throws SQLException {
        switch (this.myDelegate.getType()) {
            case 1003: {
                while (rowNum < position && this.myDelegate.next()) {
                    ++rowNum;
                }
                break;
            }
            default: {
                int actualRowNum = this.myDelegate.getRow();
                if (rowNum != actualRowNum) {
                    throw new IllegalArgumentException("Supplied current row number: " + rowNum + ". Actual: " + actualRowNum + ".\n" + "Delegate class: " + this.myDelegate.getClass().getName());
                }
                if (position < rowNum && this.myDelegate.getClass().getName().startsWith("com.sybase")) {
                    return rowNum;
                }
                if (!this.myDelegate.absolute(position)) break;
                rowNum = this.myDelegate.getRow();
            }
        }
        return rowNum;
    }

    @Override
    public List<Object[]> getObjects(int pageSize, String dialectId, int maxLobLength) throws RemoteException, SQLException {
        try {
            this.dropExportedResults();
            ResultSetMetaData metaData = this.myDelegate.getMetaData();
            ArrayList<Object[]> result = new ArrayList<Object[]>();
            int count = 0;
            while (count++ < pageSize && this.myDelegate.next()) {
                result.add(this.getCurrentRow(this.myDelegate, metaData, dialectId, maxLobLength));
            }
            return result;
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    private Object[] getCurrentRow(ResultSet resultSet, ResultSetMetaData metaData, String dialectId, int maxLobLength) throws SQLException {
        int columnCount = metaData.getColumnCount();
        Object[] objects = new Object[columnCount];
        for (int i = 1; i <= columnCount; ++i) {
            Object o;
            int jdbcType = metaData.getColumnType(i);
            try {
                block8: {
                    if (jdbcType == 2004 || jdbcType == 2005) {
                        try {
                            if (jdbcType == 2004) {
                                o = resultSet.getBlob(i);
                                break block8;
                            }
                            o = resultSet.getClob(i);
                        }
                        catch (SQLException e) {
                            o = resultSet.getObject(i);
                        }
                    } else {
                        o = jdbcType == 12 || jdbcType == 1 || jdbcType == -9 || jdbcType == -15 || "PostgresDialect".equals(dialectId) && "bit".equals(metaData.getColumnTypeName(i)) || "PostgresDialect".equals(dialectId) && "money".equals(metaData.getColumnTypeName(i)) ? resultSet.getString(i) : resultSet.getObject(i);
                    }
                }
                o = this.createInfoIfNeeded(o, maxLobLength);
            }
            catch (Throwable e) {
                o = "<failed to load>\n" + ExceptionUtil.getThrowableText((Throwable)e, (String)"com.intellij.");
            }
            objects[i - 1] = o;
        }
        return objects;
    }

    private Object createInfoIfNeeded(Object o, int maxLobLength) throws Exception {
        if (o instanceof String) {
            return LobInfo.fromString((String)o, maxLobLength);
        }
        if (o instanceof byte[]) {
            return LobInfo.fromByteArray((byte[])o, maxLobLength);
        }
        if (o instanceof Blob) {
            return LobInfo.fromBlob((Blob)o, maxLobLength);
        }
        if (o instanceof Clob) {
            return LobInfo.fromClob((Clob)o, maxLobLength);
        }
        return this.wrapIfNeeded(o, this);
    }
}

